/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.jakarta;

import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.trait.Annotated;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class UpdateAnnotationAttributeJavaxToJakarta
extends Recipe {
    @Option(displayName="Annotation signature", description="An annotation signature to match.", example="@javax.jms..*", required=false)
    private final String signature;

    public String getDisplayName() {
        return "Update annotation attributes using `javax` to `jakarta`";
    }

    public String getDescription() {
        return "Replace `javax` with `jakarta` in annotation attributes for matching annotation signatures.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Annotated.Matcher(this.signature).asVisitor(ann -> ((J.Annotation)ann.getTree()).withArguments(ListUtils.map((List)((J.Annotation)ann.getTree()).getArguments(), arg -> {
            if (arg instanceof J.Assignment) {
                J.Assignment as = (J.Assignment)arg;
                if (as.getAssignment() instanceof J.Literal) {
                    return as.withAssignment((Expression)this.maybeReplaceLiteralValue((J.Literal)as.getAssignment()));
                }
            } else if (arg instanceof J.Literal) {
                return this.maybeReplaceLiteralValue((J.Literal)arg);
            }
            return arg;
        })));
    }

    private J.Literal maybeReplaceLiteralValue(J.Literal arg) {
        String oldValue;
        if (arg.getType() == JavaType.Primitive.String && arg.getValue() instanceof String && (oldValue = (String)arg.getValue()).contains("javax.")) {
            String newValue = oldValue.replace("javax.", "jakarta.");
            return arg.withValue((Object)newValue).withValueSource('\"' + newValue + '\"');
        }
        return arg;
    }

    @ConstructorProperties(value={"signature"})
    @Generated
    public UpdateAnnotationAttributeJavaxToJakarta(String signature) {
        this.signature = signature;
    }

    @Generated
    public String getSignature() {
        return this.signature;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpdateAnnotationAttributeJavaxToJakarta(signature=" + this.getSignature() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateAnnotationAttributeJavaxToJakarta)) {
            return false;
        }
        UpdateAnnotationAttributeJavaxToJakarta other = (UpdateAnnotationAttributeJavaxToJakarta)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpdateAnnotationAttributeJavaxToJakarta;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        return result;
    }
}

