/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.io;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public final class ReplaceFileInOrOutputStreamFinalizeWithClose
extends Recipe {
    private static final String JAVA_IO_FILE_INPUT_STREAM = "java.io.FileInputStream";
    private static final String JAVA_IO_FILE_OUTPUT_STREAM = "java.io.FileOutputStream";
    private static final MethodMatcher METHOD_MATCHER = new MethodMatcher("java.lang.Object finalize()");

    public String getDisplayName() {
        return "Replace invocations of `finalize()` on `FileInputStream` and `FileOutputStream` with `close()`";
    }

    public String getDescription() {
        return "Replace invocations of the deprecated `finalize()` method on `FileInputStream` and `FileOutputStream` with `close()`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("JDK-8212050");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(9, 11), new UsesMethod(METHOD_MATCHER)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (METHOD_MATCHER.matches((MethodCall)mi)) {
                    JavaType type;
                    Expression select = mi.getSelect();
                    Object object = type = select != null ? select.getType() : ((J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class)).getType();
                    if (TypeUtils.isAssignableTo((String)ReplaceFileInOrOutputStreamFinalizeWithClose.JAVA_IO_FILE_INPUT_STREAM, (JavaType)type) || TypeUtils.isAssignableTo((String)ReplaceFileInOrOutputStreamFinalizeWithClose.JAVA_IO_FILE_OUTPUT_STREAM, (JavaType)type)) {
                        return mi.withName(mi.getName().withSimpleName("close"));
                    }
                }
                return mi;
            }
        });
    }

    @NonNull
    public String toString() {
        return "ReplaceFileInOrOutputStreamFinalizeWithClose()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceFileInOrOutputStreamFinalizeWithClose)) {
            return false;
        }
        ReplaceFileInOrOutputStreamFinalizeWithClose other = (ReplaceFileInOrOutputStreamFinalizeWithClose)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ReplaceFileInOrOutputStreamFinalizeWithClose;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

