/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

abstract class AbstractNoGuavaImmutableOf
extends Recipe {
    private final String guavaType;
    private final String javaType;

    AbstractNoGuavaImmutableOf(String guavaType, String javaType) {
        this.guavaType = guavaType;
        this.javaType = javaType;
    }

    private String getShortType(String fullyQualifiedType) {
        return fullyQualifiedType.substring(this.javaType.lastIndexOf(".") + 1);
    }

    public String getDisplayName() {
        return "Prefer `" + this.getShortType(this.javaType) + ".of(..)` in Java 9 or higher";
    }

    public String getDescription() {
        return "Replaces `" + this.getShortType(this.guavaType) + ".of(..)` if the returned type is immediately down-cast.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(10L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor check = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(9), new UsesType(this.guavaType, Boolean.valueOf(false))});
        final MethodMatcher IMMUTABLE_MATCHER = new MethodMatcher(this.guavaType + " of(..)");
        return Preconditions.check((TreeVisitor)check, (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (IMMUTABLE_MATCHER.matches((MethodCall)method) && this.isParentTypeDownCast()) {
                    this.maybeRemoveImport(AbstractNoGuavaImmutableOf.this.guavaType);
                    this.maybeAddImport(AbstractNoGuavaImmutableOf.this.javaType);
                    String template = method.getArguments().stream().map(arg -> {
                        if (arg.getType() instanceof JavaType.Primitive) {
                            String type = "";
                            if (JavaType.Primitive.Boolean == arg.getType()) {
                                type = "Boolean";
                            } else if (JavaType.Primitive.Byte == arg.getType()) {
                                type = "Byte";
                            } else if (JavaType.Primitive.Char == arg.getType()) {
                                type = "Character";
                            } else if (JavaType.Primitive.Double == arg.getType()) {
                                type = "Double";
                            } else if (JavaType.Primitive.Float == arg.getType()) {
                                type = "Float";
                            } else if (JavaType.Primitive.Int == arg.getType()) {
                                type = "Integer";
                            } else if (JavaType.Primitive.Long == arg.getType()) {
                                type = "Long";
                            } else if (JavaType.Primitive.Short == arg.getType()) {
                                type = "Short";
                            } else if (JavaType.Primitive.String == arg.getType()) {
                                type = "String";
                            }
                            return TypeUtils.asFullyQualified((JavaType)JavaType.buildType((String)("java.lang." + type)));
                        }
                        return TypeUtils.asFullyQualified((JavaType)arg.getType());
                    }).filter(Objects::nonNull).map(type -> "#{any(" + type.getFullyQualifiedName() + ")}").collect(Collectors.joining(",", AbstractNoGuavaImmutableOf.this.getShortType(AbstractNoGuavaImmutableOf.this.javaType) + ".of(", ")"));
                    return JavaTemplate.builder((String)template).contextSensitive().imports(new String[]{AbstractNoGuavaImmutableOf.this.javaType}).build().apply(this.getCursor(), method.getCoordinates().replace(), method.getArguments().get(0) instanceof J.Empty ? new Object[]{} : method.getArguments().toArray());
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }

            private boolean isParentTypeDownCast() {
                J parent = (J)this.getCursor().dropParentUntil(J.class::isInstance).getValue();
                boolean isParentTypeDownCast = false;
                if (parent instanceof J.VariableDeclarations.NamedVariable) {
                    isParentTypeDownCast = this.isParentTypeMatched(((J.VariableDeclarations.NamedVariable)parent).getType());
                } else if (parent instanceof J.Assignment) {
                    J.Assignment a = (J.Assignment)parent;
                    if (a.getVariable() instanceof J.Identifier && ((J.Identifier)a.getVariable()).getFieldType() != null) {
                        isParentTypeDownCast = this.isParentTypeMatched(((J.Identifier)a.getVariable()).getFieldType().getType());
                    } else if (a.getVariable() instanceof J.FieldAccess) {
                        isParentTypeDownCast = this.isParentTypeMatched(a.getVariable().getType());
                    }
                } else if (parent instanceof J.Return) {
                    TypeTree returnType;
                    J j = (J)this.getCursor().dropParentUntil(is -> is instanceof J.MethodDeclaration || is instanceof J.CompilationUnit).getValue();
                    if (j instanceof J.MethodDeclaration && (returnType = ((J.MethodDeclaration)j).getReturnTypeExpression()) != null) {
                        isParentTypeDownCast = this.isParentTypeMatched(returnType.getType());
                    }
                } else if (parent instanceof J.MethodInvocation) {
                    J.MethodInvocation m = (J.MethodInvocation)parent;
                    if (m.getMethodType() != null) {
                        Expression argument;
                        int index = 0;
                        Iterator iterator = m.getArguments().iterator();
                        while (iterator.hasNext() && !IMMUTABLE_MATCHER.matches(argument = (Expression)iterator.next())) {
                            ++index;
                        }
                        isParentTypeDownCast = this.isParentTypeMatched((JavaType)m.getMethodType().getParameterTypes().get(index));
                    }
                } else if (parent instanceof J.NewClass) {
                    J.NewClass c = (J.NewClass)parent;
                    int index = 0;
                    if (c.getConstructorType() != null) {
                        Expression argument;
                        Iterator iterator = c.getArguments().iterator();
                        while (iterator.hasNext() && !IMMUTABLE_MATCHER.matches(argument = (Expression)iterator.next())) {
                            ++index;
                        }
                        if (c.getConstructorType() != null) {
                            isParentTypeDownCast = this.isParentTypeMatched((JavaType)c.getConstructorType().getParameterTypes().get(index));
                        }
                    }
                } else if (parent instanceof J.NewArray) {
                    J.NewArray a = (J.NewArray)parent;
                    JavaType arrayType = a.getType();
                    while (arrayType instanceof JavaType.Array) {
                        arrayType = ((JavaType.Array)arrayType).getElemType();
                    }
                    isParentTypeDownCast = this.isParentTypeMatched(arrayType);
                }
                return isParentTypeDownCast;
            }

            private boolean isParentTypeMatched(@Nullable JavaType type) {
                JavaType.FullyQualified fq = TypeUtils.asFullyQualified((JavaType)type);
                return TypeUtils.isOfClassType((JavaType)fq, (String)AbstractNoGuavaImmutableOf.this.javaType) || TypeUtils.isOfClassType((JavaType)fq, (String)"java.lang.Object");
            }
        });
    }
}

