/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.net;

import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class URLConstructorsToURIRecipes
extends Recipe {
    public String getDisplayName() {
        return "`URLConstructorsToURI` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `org.openrewrite.java.migrate.net.URLConstructorsToURI`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new URLSingleArgumentConstructorRecipe(), new URLThreeArgumentConstructorRecipe(), new URLFourArgumentConstructorRecipe()});
    }

    @NonNullApi
    public static class URLSingleArgumentConstructorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Convert `new URL(String)` to `URI.create(String).toURL()`";
        }

        public String getDescription() {
            return "Converts `new URL(String)` constructors to `URI.create(String).toURL()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate urlConstructor = Semantics.expression((JavaVisitor)this, (String)"urlConstructor", spec -> new URL((String)spec)).build();
                final JavaTemplate uriCreateToURL = Semantics.expression((JavaVisitor)this, (String)"uriCreateToURL", spec -> URI.create(spec).toURL()).build();

                public J visitExpression(Expression elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.urlConstructor.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.uriCreateToURL.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitExpression(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("java.net.URL", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class URLThreeArgumentConstructorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Convert `new URL(String, String, String)` to `new URI(...).toURL()`";
        }

        public String getDescription() {
            return "Converts `new URL(String, String, String)` constructors to `new URI(...).toURL()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate urlConstructor = Semantics.expression((JavaVisitor)this, (String)"urlConstructor", (protocol, host, file) -> new URL((String)protocol, (String)host, (String)file)).build();
                final JavaTemplate newUriToUrl = Semantics.expression((JavaVisitor)this, (String)"newUriToUrl", (protocol, host, file) -> new URI((String)protocol, null, (String)host, -1, (String)file, null, null).toURL()).build();

                public J visitExpression(Expression elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.urlConstructor.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.newUriToUrl.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitExpression(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("java.net.URL", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class URLFourArgumentConstructorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Convert `new URL(String, String, int, String)` to `new URI(...).toURL()`";
        }

        public String getDescription() {
            return "Converts `new URL(String, String, int, String)` constructors to `new URI(...).toURL()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate urlConstructor = Semantics.expression((JavaVisitor)this, (String)"urlConstructor", (protocol, host, port, file) -> new URL((String)protocol, (String)host, (int)port, (String)file)).build();
                final JavaTemplate newUriToUrl = Semantics.expression((JavaVisitor)this, (String)"newUriToUrl", (protocol, host, port, file) -> new URI((String)protocol, null, (String)host, (int)port, (String)file, null, null).toURL()).build();

                public J visitExpression(Expression elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.urlConstructor.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.newUriToUrl.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitExpression(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("java.net.URL", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }
}

