/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.util.Collections;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.marker.Markers;

public class ThreadStopUnsupported
extends Recipe {
    private static final MethodMatcher THREAD_STOP_MATCHER = new MethodMatcher("java.lang.Thread stop()");
    private static final MethodMatcher THREAD_RESUME_MATCHER = new MethodMatcher("java.lang.Thread resume()");
    private static final MethodMatcher THREAD_SUSPEND_MATCHER = new MethodMatcher("java.lang.Thread suspend()");

    public String getDisplayName() {
        return "Replace `Thread.resume()`, `Thread.stop()`, and `Thread.suspend()` with `throw new UnsupportedOperationException()`";
    }

    public String getDescription() {
        return "`Thread.resume()`, `Thread.stop()`, and `Thread.suspend()` always throws a `new UnsupportedOperationException` in Java 21+. This recipe makes that explicit, as the migration is more complicated.See https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/lang/doc-files/threadPrimitiveDeprecation.html .";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J j = super.visitMethodInvocation(method, (Object)ctx);
                if (THREAD_STOP_MATCHER.matches((MethodCall)method) || THREAD_RESUME_MATCHER.matches((MethodCall)method) || THREAD_SUSPEND_MATCHER.matches((MethodCall)method)) {
                    if (this.usesJava21(ctx)) {
                        j = JavaTemplate.apply((String)"throw new UnsupportedOperationException()", (Cursor)this.getCursor(), (JavaCoordinates)method.getCoordinates().replace(), (Object[])new Object[0]);
                    }
                    if (j.getComments().isEmpty()) {
                        j = this.getWithComment(j, method.getName().getSimpleName());
                    }
                }
                return j;
            }

            private boolean usesJava21(ExecutionContext ctx) {
                JavaSourceFile javaSourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                return javaSourceFile != null && new UsesJavaVersion(21).visit((Tree)javaSourceFile, (Object)ctx) != javaSourceFile;
            }

            private J getWithComment(J j, String methodName) {
                String prefixWhitespace = j.getPrefix().getWhitespace();
                String commentText = prefixWhitespace + " * `Thread." + methodName + "()` always throws a `new UnsupportedOperationException()` in Java 21+." + prefixWhitespace + " * For detailed migration instructions see the migration guide available at" + prefixWhitespace + " * https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/lang/doc-files/threadPrimitiveDeprecation.html" + prefixWhitespace + " ";
                return j.withComments(Collections.singletonList(new TextComment(true, commentText, prefixWhitespace, Markers.EMPTY)));
            }
        };
    }
}

