/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lombok;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.search.MaybeUsesImport;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class LombokValToFinalVar
extends Recipe {
    private static final String LOMBOK_VAL = "lombok.val";
    private static final String LOMBOK_VAR = "lombok.var";

    public String getDisplayName() {
        return "Prefer `final var` over `lombok.val`";
    }

    public String getDescription() {
        return "Prefer the Java standard library's `final var` and `var` over third-party usage of Lombok's `lombok.val` and `lombok.var` in Java 10 or higher.";
    }

    public Set<String> getTags() {
        return Collections.singleton("lombok");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor check = Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType(LOMBOK_VAL, Boolean.valueOf(false)), new MaybeUsesImport(LOMBOK_VAR)});
        return Preconditions.check((TreeVisitor)check, (TreeVisitor)new LombokValToFinalVarVisitor());
    }

    private static class LombokValToFinalVarVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private LombokValToFinalVarVisitor() {
        }

        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit compilationUnit, ExecutionContext ctx) {
            RemoveImport op = new RemoveImport(LombokValToFinalVar.LOMBOK_VAR, true);
            if (!this.getAfterVisit().contains(op)) {
                this.doAfterVisit((TreeVisitor)op);
            }
            return super.visitCompilationUnit(compilationUnit, (Object)ctx);
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations mv, ExecutionContext ctx) {
            J.VariableDeclarations varDecls = super.visitVariableDeclarations(mv, (Object)ctx);
            if (TypeUtils.isOfClassType((JavaType)varDecls.getType(), (String)LombokValToFinalVar.LOMBOK_VAL)) {
                Object[] args;
                String finalVarVariableTemplateString;
                this.maybeRemoveImport(LombokValToFinalVar.LOMBOK_VAL);
                J.VariableDeclarations.NamedVariable nv = (J.VariableDeclarations.NamedVariable)mv.getVariables().get(0);
                if (nv.getInitializer() == null) {
                    finalVarVariableTemplateString = "final var #{}";
                    args = new Object[]{nv.getSimpleName()};
                } else {
                    finalVarVariableTemplateString = "final var #{} = #{any()};";
                    args = new Object[]{nv.getSimpleName(), nv.getInitializer()};
                }
                varDecls = (J.VariableDeclarations)JavaTemplate.builder((String)finalVarVariableTemplateString).contextSensitive().build().apply(this.updateCursor((Tree)varDecls), varDecls.getCoordinates().replace(), args);
                if (nv.getInitializer() != null) {
                    varDecls = varDecls.withVariables(ListUtils.map((List)varDecls.getVariables(), namedVar -> namedVar.withInitializer((Expression)namedVar.getInitializer().withPrefix(nv.getInitializer().getPrefix()))));
                }
            }
            return varDecls;
        }
    }
}

