/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang.var;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.migrate.lang.var.DeclarationCheck;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public class UseVarForGenericMethodInvocations
extends Recipe {
    public String getDisplayName() {
        return "Apply `var` to Generic Method Invocations";
    }

    public String getDescription() {
        return "Apply `var` to variables initialized by invocations of Generic Methods. This recipe ignores generic factory methods without parameters, because open rewrite cannot handle them correctly ATM.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesJavaVersion(10), (TreeVisitor)new UseVarForGenericsVisitor());
    }

    static final class UseVarForGenericsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final JavaTemplate template = JavaTemplate.builder((String)"var #{} = #{any()}").javaParser(JavaParser.fromJavaVersion()).build();

        UseVarForGenericsVisitor() {
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations vd, ExecutionContext ctx) {
            boolean isMethodInvocation;
            vd = super.visitVariableDeclarations(vd, (Object)ctx);
            boolean isGeneralApplicable = DeclarationCheck.isVarApplicable(this.getCursor(), vd);
            if (!isGeneralApplicable) {
                return vd;
            }
            boolean isPrimitive = DeclarationCheck.isPrimitive(vd);
            boolean usesNoGenerics = !DeclarationCheck.useGenerics(vd);
            boolean usesTernary = DeclarationCheck.initializedByTernary(vd);
            if (isPrimitive || usesTernary || usesNoGenerics) {
                return vd;
            }
            Expression initializer = ((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getInitializer();
            boolean bl = isMethodInvocation = initializer != null && initializer.unwrap() instanceof J.MethodInvocation;
            if (!isMethodInvocation) {
                return vd;
            }
            boolean hasNoTypeParams = ((J.MethodInvocation)initializer).getTypeParameters() == null;
            boolean argumentsEmpty = UseVarForGenericsVisitor.allArgumentsEmpty((J.MethodInvocation)initializer);
            if (hasNoTypeParams && argumentsEmpty) {
                return vd;
            }
            if (vd.getType() instanceof JavaType.FullyQualified) {
                this.maybeRemoveImport((JavaType.FullyQualified)vd.getType());
            }
            return this.transformToVar(vd, new ArrayList<JavaType>(), new ArrayList<JavaType>());
        }

        private static boolean allArgumentsEmpty(J.MethodInvocation invocation) {
            for (Expression argument : invocation.getArguments()) {
                if (argument instanceof J.Empty) continue;
                return false;
            }
            return true;
        }

        private J.VariableDeclarations transformToVar(J.VariableDeclarations vd, List<JavaType> leftTypes, List<JavaType> rightTypes) {
            TypeTree resultingTypeExpression;
            boolean resultHasTypeExpression;
            boolean hasModifiers;
            Expression initializer = ((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getInitializer();
            String simpleName = ((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getSimpleName();
            if (rightTypes.isEmpty() && !leftTypes.isEmpty()) {
                ArrayList<J.Identifier> typeArgument = new ArrayList<J.Identifier>();
                for (JavaType t : leftTypes) {
                    typeArgument.add(new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), ((JavaType.Class)t).getClassName(), t, null));
                }
                J.ParameterizedType typedInitializerClazz = ((J.ParameterizedType)((J.NewClass)initializer).getClazz()).withTypeParameters(typeArgument);
                initializer = ((J.NewClass)initializer).withClazz((TypeTree)typedInitializerClazz);
            }
            J.VariableDeclarations result = ((J.VariableDeclarations)this.template.apply(this.getCursor(), vd.getCoordinates().replace(), new Object[]{simpleName, initializer})).withPrefix(vd.getPrefix());
            List modifiers = vd.getModifiers();
            boolean bl = hasModifiers = !modifiers.isEmpty();
            if (hasModifiers) {
                result = result.withModifiers(modifiers);
            }
            boolean bl2 = resultHasTypeExpression = (resultingTypeExpression = result.getTypeExpression()) != null;
            if (resultHasTypeExpression) {
                result = result.withTypeExpression((TypeTree)resultingTypeExpression.withPrefix(vd.getTypeExpression().getPrefix()));
            }
            return result;
        }
    }
}

