/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class NoGuavaSetsNewConcurrentHashSet
extends Recipe {
    private static final MethodMatcher NEW_HASH_SET = new MethodMatcher("com.google.common.collect.Sets newConcurrentHashSet()");

    public String getDisplayName() {
        return "Prefer `new ConcurrentHashMap<>()`";
    }

    public String getDescription() {
        return "Prefer the Java standard library over third-party usage of Guava in simple cases like this.";
    }

    public Set<String> getTags() {
        return Collections.singleton("guava");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(NEW_HASH_SET), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (NEW_HASH_SET.matches(method)) {
                    this.maybeRemoveImport("com.google.common.collect.Sets");
                    this.maybeAddImport("java.util.Collections");
                    this.maybeAddImport("java.util.concurrent.ConcurrentHashMap");
                    return JavaTemplate.builder((String)"Collections.newSetFromMap(new ConcurrentHashMap<>())").contextSensitive().imports(new String[]{"java.util.Collections"}).imports(new String[]{"java.util.concurrent.ConcurrentHashMap"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[0]);
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }
}

