/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Base64;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.Markup;
import org.openrewrite.staticanalysis.UnnecessaryCatch;

public class UseJavaUtilBase64
extends Recipe {
    private final String sunPackage;

    public String getDisplayName() {
        return "Prefer `java.util.Base64` instead of `sun.misc`";
    }

    public String getDescription() {
        return "Prefer `java.util.Base64` instead of using `sun.misc` in Java 8 or higher. `sun.misc` is not exported by the Java module system and accessing this class will result in a warning in Java 11 and an error in Java 17.";
    }

    public UseJavaUtilBase64(String sunPackage) {
        this.sunPackage = sunPackage;
    }

    @JsonCreator
    public UseJavaUtilBase64() {
        this("sun.misc");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor check = Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType(this.sunPackage + ".BASE64Encoder", Boolean.valueOf(false)), new UsesType(this.sunPackage + ".BASE64Decoder", Boolean.valueOf(false))});
        final MethodMatcher base64EncodeMethod = new MethodMatcher(this.sunPackage + ".CharacterEncoder *(byte[])");
        final MethodMatcher base64DecodeBuffer = new MethodMatcher(this.sunPackage + ".CharacterDecoder decodeBuffer(String)");
        final MethodMatcher newBase64Encoder = new MethodMatcher(this.sunPackage + ".BASE64Encoder <constructor>()");
        final MethodMatcher newBase64Decoder = new MethodMatcher(this.sunPackage + ".BASE64Decoder <constructor>()");
        return Preconditions.check((TreeVisitor)check, (TreeVisitor)new JavaVisitor<ExecutionContext>(){
            final JavaTemplate getDecoderTemplate = JavaTemplate.builder((String)"Base64.getDecoder()").contextSensitive().imports(new String[]{"java.util.Base64"}).build();
            final JavaTemplate encodeToString = JavaTemplate.builder((String)"Base64.getEncoder().encodeToString(#{anyArray(byte)})").imports(new String[]{"java.util.Base64"}).build();
            final JavaTemplate decode = JavaTemplate.builder((String)"Base64.getDecoder().decode(#{any(String)})").imports(new String[]{"java.util.Base64"}).build();

            public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                if (UseJavaUtilBase64.this.alreadyUsingIncompatibleBase64((JavaSourceFile)cu)) {
                    return (J)Markup.warn((Tree)cu, (Throwable)new IllegalStateException("Already using a class named Base64 other than java.util.Base64. Manual intervention required."));
                }
                J.CompilationUnit c = (J.CompilationUnit)super.visitCompilationUnit(cu, (Object)ctx);
                c = (J.CompilationUnit)new ChangeType(UseJavaUtilBase64.this.sunPackage + ".BASE64Encoder", "java.util.Base64$Encoder", Boolean.valueOf(true)).getVisitor().visitNonNull((Tree)c, (Object)ctx);
                c = (J.CompilationUnit)new ChangeType(UseJavaUtilBase64.this.sunPackage + ".BASE64Decoder", "java.util.Base64$Decoder", Boolean.valueOf(true)).getVisitor().visitNonNull((Tree)c, (Object)ctx);
                return c;
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (base64EncodeMethod.matches(m) && ("encode".equals(method.getSimpleName()) || "encodeBuffer".equals(method.getSimpleName()))) {
                    m = (J.MethodInvocation)this.encodeToString.apply(this.updateCursor((Tree)m), m.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                    if (method.getSelect() instanceof J.Identifier) {
                        m = m.withSelect(method.getSelect());
                    }
                } else if (base64DecodeBuffer.matches(method)) {
                    m = (J.MethodInvocation)this.decode.apply(this.updateCursor((Tree)m), m.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                    if (method.getSelect() instanceof J.Identifier) {
                        m = m.withSelect(method.getSelect());
                    }
                    this.doAfterVisit(new UnnecessaryCatch(false).getVisitor());
                }
                return m;
            }

            public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                J.NewClass c = (J.NewClass)super.visitNewClass(newClass, (Object)ctx);
                if (newBase64Encoder.matches(c)) {
                    return JavaTemplate.compile((JavaVisitor)this, (String)"getEncoder", () -> Base64.getEncoder()).build().apply(this.updateCursor((Tree)c), c.getCoordinates().replace(), new Object[0]);
                }
                if (newBase64Decoder.matches(c)) {
                    return this.getDecoderTemplate.apply(this.updateCursor((Tree)c), c.getCoordinates().replace(), new Object[0]);
                }
                return c;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean alreadyUsingIncompatibleBase64(JavaSourceFile cu) {
        if (cu.getClasses().stream().anyMatch(it -> "Base64".equals(it.getSimpleName()))) return true;
        if (!cu.getTypesInUse().getTypesInUse().stream().filter(it -> it instanceof JavaType.FullyQualified).map(JavaType.FullyQualified.class::cast).map(JavaType.FullyQualified::getFullyQualifiedName).filter(it -> !"java.util.Base64".equals(it)).anyMatch(it -> it.endsWith(".Base64"))) return false;
        return true;
    }
}

