/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.time.Duration;
import java.util.List;
import java.util.StringJoiner;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class MigrateCollectionsUnmodifiableList
extends Recipe {
    private static final MethodMatcher UNMODIFIABLE_LIST = new MethodMatcher("java.util.Collections unmodifiableList(java.util.List)", true);
    private static final MethodMatcher ARRAYS_AS_LIST = new MethodMatcher("java.util.Arrays asList(..)", true);

    public String getDisplayName() {
        return "Use `List.of(..)` in Java 9 or higher";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public String getDescription() {
        return "Replaces `unmodifiableList(java.util.Arrays asList(<args>))` with `List.Of(<args>)`.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                this.doAfterVisit((TreeVisitor)new UsesJavaVersion(9));
                this.doAfterVisit((TreeVisitor)new UsesMethod(UNMODIFIABLE_LIST));
                return cu;
            }
        };
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)executionContext);
                if (UNMODIFIABLE_LIST.matches(method) && m.getArguments().get(0) instanceof J.MethodInvocation && ARRAYS_AS_LIST.matches((J.MethodInvocation)m.getArguments().get(0))) {
                    J.MethodInvocation arraysInvocation = (J.MethodInvocation)m.getArguments().get(0);
                    this.maybeRemoveImport("java.util.Collections");
                    this.maybeRemoveImport("java.util.Arrays");
                    this.maybeAddImport("java.util.List");
                    StringJoiner setOf = new StringJoiner(", ", "List.of(", ")");
                    List args = arraysInvocation.getArguments();
                    args.forEach(o -> setOf.add("#{any()}"));
                    return this.autoFormat(m.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)setOf.toString()).imports(new String[]{"java.util.List"}).build(), m.getCoordinates().replace(), args.toArray()), executionContext);
                }
                return m;
            }
        };
    }
}

