/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.net;

import java.time.Duration;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeFieldName;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class MigrateHttpURLConnectionHttpServerErrorToHttpInternalError
extends Recipe {
    public String getDisplayName() {
        return "Use `java.net.HttpURLConnection.HTTP_INTERNAL_ERROR`";
    }

    public String getDescription() {
        return "`java.net.HttpURLConnection.HTTP_SERVER_ERROR` has been deprecated.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("java.net.HttpURLConnection");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MigrateHttpURLConnectionHttpServerErrorToHttpInternalErrorVisitor();
    }

    private static class MigrateHttpURLConnectionHttpServerErrorToHttpInternalErrorVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private MigrateHttpURLConnectionHttpServerErrorToHttpInternalErrorVisitor() {
        }

        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            this.doAfterVisit((TreeVisitor)new ChangeFieldName("java.net.HttpURLConnection", "HTTP_SERVER_ERROR", "HTTP_INTERNAL_ERROR"));
            return super.visitCompilationUnit(cu, (Object)ctx);
        }

        public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
            JavaType.FullyQualified fq;
            if ("HTTP_SERVER_ERROR".equals(identifier.getSimpleName()) && identifier.getFieldType() != null && (fq = TypeUtils.asFullyQualified((JavaType)identifier.getFieldType().getOwner())) != null && "java.net.HttpURLConnection".equals(fq.getFullyQualifiedName())) {
                identifier = identifier.withSimpleName("HTTP_INTERNAL_ERROR");
            }
            return super.visitIdentifier(identifier, (Object)ctx);
        }
    }
}

