/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class NoGuavaOptionalFromJavaUtil
extends Recipe {
    static final MethodMatcher METHOD_MATCHER = new MethodMatcher("com.google.common.base.Optional fromJavaUtil(java.util.Optional)");

    public String getDisplayName() {
        return "Replace `com.google.common.base.Optional#fromJavaUtil(java.util.Optional)` with argument";
    }

    public String getDescription() {
        return "Replaces `com.google.common.base.Optional#fromJavaUtil(java.util.Optional)` with argument.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("RSPEC-4738", "guava"));
    }

    protected UsesType<ExecutionContext> getApplicableTest() {
        return new UsesType("com.google.common.base.Optional", Boolean.valueOf(false));
    }

    protected UsesMethod<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(METHOD_MATCHER);
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new ReplaceFromJavaUtilVisitor();
    }

    private static class ReplaceFromJavaUtilVisitor
    extends JavaVisitor<ExecutionContext> {
        private ReplaceFromJavaUtilVisitor() {
        }

        public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            J c = super.visitCompilationUnit(cu, (Object)ctx);
            this.maybeAddImport("java.util.Optional");
            this.maybeRemoveImport("com.google.common.base.Optional");
            return c;
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi;
            J j = super.visitMethodInvocation(method, (Object)ctx);
            if (j instanceof J.MethodInvocation && METHOD_MATCHER.matches(mi = (J.MethodInvocation)j)) {
                return ((Expression)mi.getArguments().get(0)).withPrefix(mi.getPrefix());
            }
            return j;
        }
    }
}

