/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class UpgradeJavaVersion
extends Recipe {
    @Option(displayName="Java version", description="The Java version to upgrade to.", example="11")
    private final Integer version;
    private static final List<String> JAVA_VERSION_XPATHS = Arrays.asList("/project/properties/java.version", "/project/properties/jdk.version", "/project/properties/javaVersion", "/project/properties/jdkVersion", "/project/properties/maven.compiler.source", "/project/properties/maven.compiler.target", "/project/properties/maven.compiler.release", "/project/build/plugins/plugin[artifactId='maven-compiler-plugin']/configuration/source", "/project/build/plugins/plugin[artifactId='maven-compiler-plugin']/configuration/target", "/project/build/plugins/plugin[artifactId='maven-compiler-plugin']/configuration/release");
    private static final List<XPathMatcher> JAVA_VERSION_XPATH_MATCHERS = JAVA_VERSION_XPATHS.stream().map(XPathMatcher::new).collect(Collectors.toList());

    public String getDisplayName() {
        return "Upgrade Java version";
    }

    public String getDescription() {
        return "Upgrade build plugin configuration to use the specified Java version. This recipe changes `java.toolchain.languageVersion` in `build.gradle(.kts)` of gradle projects, or maven-compiler-plugin target version and related settings. Will not downgrade if the version is newer than the specified version.";
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        GradleUpdateJavaVersionVisitor gradleUpdateJavaVersionVisitor = new GradleUpdateJavaVersionVisitor();
        MavenUpdateJavaVersionVisitor mavenUpdateVisitor = new MavenUpdateJavaVersionVisitor();
        before = ListUtils.map(before, s -> {
            s = (SourceFile)mavenUpdateVisitor.visit((Tree)s, ctx);
            s = (SourceFile)gradleUpdateJavaVersionVisitor.visit((Tree)s, ctx);
            return s;
        });
        String newVersion = this.version.toString();
        Optional<JavaVersion> currentMarker = before.stream().map(it -> it.getMarkers().findFirst(JavaVersion.class)).filter(Optional::isPresent).map(Optional::get).findAny();
        if (!currentMarker.isPresent() || currentMarker.get().getMajorVersion() >= this.version) {
            return before;
        }
        JavaVersion updatedMarker = currentMarker.get().withSourceCompatibility(newVersion).withTargetCompatibility(newVersion);
        return ListUtils.map((List)before, sourceFile -> sourceFile.getMarkers().findFirst(JavaVersion.class).map(version -> (SourceFile)sourceFile.withMarkers(sourceFile.getMarkers().computeByType((Marker)version, (v, acc) -> updatedMarker))).orElse((SourceFile)sourceFile));
    }

    @ConstructorProperties(value={"version"})
    public UpgradeJavaVersion(Integer version) {
        this.version = version;
    }

    public Integer getVersion() {
        return this.version;
    }

    @NonNull
    public String toString() {
        return "UpgradeJavaVersion(version=" + this.getVersion() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeJavaVersion)) {
            return false;
        }
        UpgradeJavaVersion other = (UpgradeJavaVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !((Object)this$version).equals(other$version));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeJavaVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        return result;
    }

    private class GradleUpdateJavaVersionVisitor
    extends GroovyIsoVisitor<ExecutionContext> {
        MethodMatcher javaLanguageVersionMatcher = new MethodMatcher("org.gradle.jvm.toolchain.JavaLanguageVersion of(int)");

        private GradleUpdateJavaVersionVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            if (this.javaLanguageVersionMatcher.matches(method = super.visitMethodInvocation(method, (Object)executionContext))) {
                J.Literal versionArg;
                List args = method.getArguments();
                if (args.size() == 1 && args.get(0) instanceof J.Literal && (versionArg = (J.Literal)args.get(0)).getValue() instanceof Integer) {
                    Integer versionNumber = (Integer)versionArg.getValue();
                    if (versionNumber < UpgradeJavaVersion.this.version) {
                        return method.withArguments(Collections.singletonList(versionArg.withValue((Object)UpgradeJavaVersion.this.version).withValueSource(UpgradeJavaVersion.this.version.toString())));
                    }
                    return method;
                }
                return (J.MethodInvocation)SearchResult.found((Tree)method, (String)("Attempted to update to Java version to " + UpgradeJavaVersion.this.version + "  but was unsuccessful, please update manually"));
            }
            return method;
        }
    }

    private class MavenUpdateJavaVersionVisitor
    extends MavenVisitor<ExecutionContext> {
        private MavenUpdateJavaVersionVisitor() {
        }

        public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
            tag = (Xml.Tag)super.visitTag(tag, (Object)ctx);
            if (JAVA_VERSION_XPATH_MATCHERS.stream().anyMatch(matcher -> matcher.matches(this.getCursor()))) {
                Optional maybeVersion = tag.getValue().flatMap(value -> {
                    try {
                        return Optional.of(Float.valueOf(Float.parseFloat(value)));
                    }
                    catch (NumberFormatException e) {
                        return Optional.empty();
                    }
                });
                if (!maybeVersion.isPresent()) {
                    return tag;
                }
                float currentVersion = ((Float)maybeVersion.get()).floatValue();
                if (currentVersion >= (float)UpgradeJavaVersion.this.version.intValue()) {
                    return tag;
                }
                return tag.withValue(String.valueOf(UpgradeJavaVersion.this.version));
            }
            return tag;
        }
    }
}

