/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.time.Duration;
import java.util.StringJoiner;
import org.openrewrite.Applicability;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class UseLocaleOf
extends Recipe {
    private static final MethodMatcher NEW_LOCALE = new MethodMatcher("java.util.Locale <constructor>(..)", false);

    public String getDisplayName() {
        return "Prefer `Locale.of(..)` over `new Locale(..)`";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public String getDescription() {
        return "Prefer `Locale.of(..)` over `new Locale(..)` in Java 19 or higher.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return Applicability.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(19), new UsesMethod(NEW_LOCALE)});
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                J.NewClass nc = (J.NewClass)super.visitNewClass(newClass, (Object)ctx);
                if (NEW_LOCALE.matches(nc)) {
                    StringJoiner localeOf = new StringJoiner(", ", "Locale.of(", ")");
                    nc.getArguments().forEach(a -> localeOf.add("#{any(String)}"));
                    return this.autoFormat(nc.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)localeOf.toString()).imports(new String[]{"java.util.Locale"}).build(), nc.getCoordinates().replace(), nc.getArguments().toArray()), ctx);
                }
                return nc;
            }
        };
    }
}

