/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.time.Duration;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class NoGuavaListsNewLinkedList
extends Recipe {
    private static final MethodMatcher NEW_LINKED_LIST = new MethodMatcher("com.google.common.collect.Lists newLinkedList()");
    private static final MethodMatcher NEW_LINKED_LIST_ITERABLE = new MethodMatcher("com.google.common.collect.Lists newLinkedList(java.lang.Iterable)");

    public String getDisplayName() {
        return "Use `new LinkedList<>()` instead of Guava";
    }

    public String getDescription() {
        return "Prefer the Java standard library over third-party usage of Guava in simple cases like this.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                this.doAfterVisit((TreeVisitor)new UsesMethod(NEW_LINKED_LIST));
                this.doAfterVisit((TreeVisitor)new UsesMethod(NEW_LINKED_LIST_ITERABLE));
                return cu;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            private final JavaTemplate newLinkedList = JavaTemplate.builder(() -> (this).getCursor(), (String)"new LinkedList<>()").imports(new String[]{"java.util.LinkedList"}).build();
            private final JavaTemplate newLinkedListIterable = JavaTemplate.builder(() -> (this).getCursor(), (String)"new LinkedList<>(#{any(java.lang.Iterable)})").imports(new String[]{"java.util.LinkedList"}).build();

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                if (NEW_LINKED_LIST.matches(method)) {
                    this.maybeRemoveImport("com.google.common.collect.Lists");
                    this.maybeAddImport("java.util.LinkedList");
                    return method.withTemplate((SourceTemplate)this.newLinkedList, method.getCoordinates().replace(), new Object[0]);
                }
                if (NEW_LINKED_LIST_ITERABLE.matches(method)) {
                    this.maybeRemoveImport("com.google.common.collect.Lists");
                    this.maybeAddImport("java.util.LinkedList");
                    return method.withTemplate((SourceTemplate)this.newLinkedListIterable, method.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                }
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
        };
    }
}

