/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import java.beans.ConstructorProperties;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.ChangeDependency;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class ChangeDependencyGroupIdAndArtifactId
extends Recipe {
    @Option(displayName="Old groupId", description="The old groupId to replace. The groupId is the first part of a dependency coordinate `com.google.guava:guava:VERSION`. Supports glob expressions.", example="org.openrewrite.recipe")
    private final String oldGroupId;
    @Option(displayName="Old artifactId", description="The old artifactId to replace. The artifactId is the second part of a dependency coordinate `com.google.guava:guava:VERSION`. Supports glob expressions.", example="rewrite-testing-frameworks")
    private final String oldArtifactId;
    @Option(displayName="New groupId", description="The new groupId to use. Defaults to the existing group id.", example="corp.internal.openrewrite.recipe", required=false)
    @Nullable
    private final String newGroupId;
    @Option(displayName="New artifactId", description="The new artifactId to use. Defaults to the existing artifact id.", example="rewrite-testing-frameworks", required=false)
    @Nullable
    private final String newArtifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number.", example="29.X", required=false)
    @Nullable
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;
    @Option(displayName="Override managed version", description="If the new dependency has a managed version, this flag can be used to explicitly set the version on the dependency. The default for this flag is `false`.", required=false)
    @Nullable
    private final Boolean overrideManagedVersion;
    @Option(displayName="Update dependency management", description="Also update the dependency management section. The default for this flag is `true`.", required=false)
    @Nullable
    private final Boolean changeManagedDependency;

    public String getDisplayName() {
        return "Change Gradle or Maven dependency";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.oldGroupId, this.oldArtifactId);
    }

    public String getDescription() {
        return "Change a Gradle or Maven dependency coordinate. Either the `newGroupId` or `newArtifactId` must differ from the previous value.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final TreeVisitor mavenVisitor = new org.openrewrite.maven.ChangeDependencyGroupIdAndArtifactId(this.oldGroupId, this.oldArtifactId, this.newGroupId, this.newArtifactId, this.newVersion, this.versionPattern, this.overrideManagedVersion, this.changeManagedDependency).getVisitor();
        final TreeVisitor gradleVisitor = new ChangeDependency(this.oldGroupId, this.oldArtifactId, this.newGroupId, this.newArtifactId, this.newVersion, this.versionPattern, this.overrideManagedVersion).getVisitor();
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile t = (SourceFile)tree;
                if (mavenVisitor.isAcceptable(t, (Object)ctx)) {
                    t = (SourceFile)mavenVisitor.visitNonNull((Tree)t, (Object)ctx);
                }
                if (gradleVisitor.isAcceptable(t, (Object)ctx)) {
                    t = (SourceFile)gradleVisitor.visitNonNull((Tree)t, (Object)ctx);
                }
                return t;
            }
        };
    }

    @ConstructorProperties(value={"oldGroupId", "oldArtifactId", "newGroupId", "newArtifactId", "newVersion", "versionPattern", "overrideManagedVersion", "changeManagedDependency"})
    public ChangeDependencyGroupIdAndArtifactId(String oldGroupId, String oldArtifactId, @Nullable String newGroupId, @Nullable String newArtifactId, @Nullable String newVersion, @Nullable String versionPattern, @Nullable Boolean overrideManagedVersion, @Nullable Boolean changeManagedDependency) {
        this.oldGroupId = oldGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newGroupId = newGroupId;
        this.newArtifactId = newArtifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.overrideManagedVersion = overrideManagedVersion;
        this.changeManagedDependency = changeManagedDependency;
    }

    public String getOldGroupId() {
        return this.oldGroupId;
    }

    public String getOldArtifactId() {
        return this.oldArtifactId;
    }

    @Nullable
    public String getNewGroupId() {
        return this.newGroupId;
    }

    @Nullable
    public String getNewArtifactId() {
        return this.newArtifactId;
    }

    @Nullable
    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Nullable
    public Boolean getOverrideManagedVersion() {
        return this.overrideManagedVersion;
    }

    @Nullable
    public Boolean getChangeManagedDependency() {
        return this.changeManagedDependency;
    }

    @NonNull
    public String toString() {
        return "ChangeDependencyGroupIdAndArtifactId(oldGroupId=" + this.getOldGroupId() + ", oldArtifactId=" + this.getOldArtifactId() + ", newGroupId=" + this.getNewGroupId() + ", newArtifactId=" + this.getNewArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ", overrideManagedVersion=" + this.getOverrideManagedVersion() + ", changeManagedDependency=" + this.getChangeManagedDependency() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeDependencyGroupIdAndArtifactId)) {
            return false;
        }
        ChangeDependencyGroupIdAndArtifactId other = (ChangeDependencyGroupIdAndArtifactId)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$overrideManagedVersion = this.getOverrideManagedVersion();
        Boolean other$overrideManagedVersion = other.getOverrideManagedVersion();
        if (this$overrideManagedVersion == null ? other$overrideManagedVersion != null : !((Object)this$overrideManagedVersion).equals(other$overrideManagedVersion)) {
            return false;
        }
        Boolean this$changeManagedDependency = this.getChangeManagedDependency();
        Boolean other$changeManagedDependency = other.getChangeManagedDependency();
        if (this$changeManagedDependency == null ? other$changeManagedDependency != null : !((Object)this$changeManagedDependency).equals(other$changeManagedDependency)) {
            return false;
        }
        String this$oldGroupId = this.getOldGroupId();
        String other$oldGroupId = other.getOldGroupId();
        if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
            return false;
        }
        String this$oldArtifactId = this.getOldArtifactId();
        String other$oldArtifactId = other.getOldArtifactId();
        if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
            return false;
        }
        String this$newGroupId = this.getNewGroupId();
        String other$newGroupId = other.getNewGroupId();
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$newArtifactId = this.getNewArtifactId();
        String other$newArtifactId = other.getNewArtifactId();
        if (this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeDependencyGroupIdAndArtifactId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $overrideManagedVersion = this.getOverrideManagedVersion();
        result = result * 59 + ($overrideManagedVersion == null ? 43 : ((Object)$overrideManagedVersion).hashCode());
        Boolean $changeManagedDependency = this.getChangeManagedDependency();
        result = result * 59 + ($changeManagedDependency == null ? 43 : ((Object)$changeManagedDependency).hashCode());
        String $oldGroupId = this.getOldGroupId();
        result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
        String $oldArtifactId = this.getOldArtifactId();
        result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
        String $newGroupId = this.getNewGroupId();
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $newArtifactId = this.getNewArtifactId();
        result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

