/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import java.beans.ConstructorProperties;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.dependencies.table.DependencyListReport;
import org.openrewrite.marker.Markers;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;

public final class DependencyList
extends Recipe {
    private final transient DependencyListReport report = new DependencyListReport(this);
    @Option(displayName="Scope", description="The scope of the dependencies to include in the report.", valid={"Compile", "Runtime", "TestRuntime"}, example="Compile")
    private final Scope scope;
    @Option(displayName="Include transitive dependencies", description="Whether or not to include transitive dependencies in the report. Defaults to including only direct dependencies.", example="true")
    private final boolean includeTransitive;

    public String getDisplayName() {
        return "Dependency report";
    }

    public String getDescription() {
        return "Emits a data table detailing all Gradle and Maven dependencies.This recipe makes no changes to any source file.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree == null) {
                    return null;
                }
                Markers m = tree.getMarkers();
                m.findFirst(GradleProject.class).ifPresent(gradle -> {
                    GradleDependencyConfiguration conf = gradle.getConfiguration(DependencyList.this.scope.asGradleConfigurationName());
                    if (conf != null) {
                        for (ResolvedDependency dep : conf.getResolved()) {
                            DependencyList.this.insertDependency(ctx, gradle, dep, true);
                        }
                    }
                });
                m.findFirst(MavenResolutionResult.class).ifPresent(maven -> {
                    for (ResolvedDependency dep : (List)maven.getDependencies().get(DependencyList.this.scope.asMavenScope())) {
                        DependencyList.this.insertDependency(ctx, maven, dep, true);
                    }
                });
                return tree;
            }
        };
    }

    private void insertDependency(ExecutionContext ctx, GradleProject gradle, ResolvedDependency dep, boolean direct) {
        this.report.insertRow(ctx, new DependencyListReport.Row("Gradle", "", gradle.getName(), "", dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), direct));
        if (this.includeTransitive) {
            for (ResolvedDependency transitive : dep.getDependencies()) {
                this.insertDependency(ctx, gradle, transitive, false);
            }
        }
    }

    private void insertDependency(ExecutionContext ctx, MavenResolutionResult maven, ResolvedDependency dep, boolean direct) {
        this.report.insertRow(ctx, new DependencyListReport.Row("Maven", maven.getPom().getGroupId(), maven.getPom().getArtifactId(), maven.getPom().getVersion(), dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), direct));
        if (this.includeTransitive) {
            for (ResolvedDependency transitive : dep.getDependencies()) {
                this.insertDependency(ctx, maven, transitive, false);
            }
        }
    }

    @ConstructorProperties(value={"scope", "includeTransitive"})
    public DependencyList(Scope scope, boolean includeTransitive) {
        this.scope = scope;
        this.includeTransitive = includeTransitive;
    }

    public DependencyListReport getReport() {
        return this.report;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean isIncludeTransitive() {
        return this.includeTransitive;
    }

    @NonNull
    public String toString() {
        return "DependencyList(report=" + (Object)((Object)this.getReport()) + ", scope=" + (Object)((Object)this.getScope()) + ", includeTransitive=" + this.isIncludeTransitive() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyList)) {
            return false;
        }
        DependencyList other = (DependencyList)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isIncludeTransitive() != other.isIncludeTransitive()) {
            return false;
        }
        Scope this$scope = this.getScope();
        Scope other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DependencyList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isIncludeTransitive() ? 79 : 97);
        Scope $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
        return result;
    }

    public static enum Scope {
        Compile,
        Runtime,
        TestRuntime;


        public org.openrewrite.maven.tree.Scope asMavenScope() {
            switch (this) {
                case Compile: {
                    return org.openrewrite.maven.tree.Scope.Compile;
                }
                case Runtime: {
                    return org.openrewrite.maven.tree.Scope.Runtime;
                }
                case TestRuntime: {
                    return org.openrewrite.maven.tree.Scope.Test;
                }
            }
            throw new IllegalStateException("Unexpected value: " + (Object)((Object)this));
        }

        public String asGradleConfigurationName() {
            switch (this) {
                case Compile: {
                    return "compileClasspath";
                }
                case Runtime: {
                    return "runtimeClasspath";
                }
                case TestRuntime: {
                    return "testRuntimeClasspath";
                }
            }
            throw new IllegalStateException("Unexpected value: " + (Object)((Object)this));
        }
    }
}

