/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies.table;

import java.beans.ConstructorProperties;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class RepositoryAccessibilityReport
extends DataTable<Row> {
    public RepositoryAccessibilityReport(Recipe recipe) {
        super(recipe, "Repository accessibility report", "Listing of all dependency repositories and whether they are accessible.");
    }

    public static final class Row {
        @Column(displayName="Repository URI", description="The URI of the repository")
        private final String uri;
        @Column(displayName="Exception type", description="Empty if the repository was accessible. Otherwise, the type of exception encountered when attempting to access the repository.")
        private final String exceptionType;
        @Column(displayName="Error message", description="Empty if the repository was accessible. Otherwise, the error message encountered when attempting to access the repository.")
        private final String exceptionMessage;
        @Column(displayName="HTTP code", description="The HTTP response code returned by the repository. May be empty for non-HTTP repositories.")
        @Nullable
        private final Integer httpCode;

        @ConstructorProperties(value={"uri", "exceptionType", "exceptionMessage", "httpCode"})
        public Row(String uri, String exceptionType, String exceptionMessage, @Nullable Integer httpCode) {
            this.uri = uri;
            this.exceptionType = exceptionType;
            this.exceptionMessage = exceptionMessage;
            this.httpCode = httpCode;
        }

        public String getUri() {
            return this.uri;
        }

        public String getExceptionType() {
            return this.exceptionType;
        }

        public String getExceptionMessage() {
            return this.exceptionMessage;
        }

        @Nullable
        public Integer getHttpCode() {
            return this.httpCode;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            Integer this$httpCode = this.getHttpCode();
            Integer other$httpCode = other.getHttpCode();
            if (this$httpCode == null ? other$httpCode != null : !((Object)this$httpCode).equals(other$httpCode)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            String this$exceptionType = this.getExceptionType();
            String other$exceptionType = other.getExceptionType();
            if (this$exceptionType == null ? other$exceptionType != null : !this$exceptionType.equals(other$exceptionType)) {
                return false;
            }
            String this$exceptionMessage = this.getExceptionMessage();
            String other$exceptionMessage = other.getExceptionMessage();
            return !(this$exceptionMessage == null ? other$exceptionMessage != null : !this$exceptionMessage.equals(other$exceptionMessage));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $httpCode = this.getHttpCode();
            result = result * 59 + ($httpCode == null ? 43 : ((Object)$httpCode).hashCode());
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            String $exceptionType = this.getExceptionType();
            result = result * 59 + ($exceptionType == null ? 43 : $exceptionType.hashCode());
            String $exceptionMessage = this.getExceptionMessage();
            result = result * 59 + ($exceptionMessage == null ? 43 : $exceptionMessage.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "RepositoryAccessibilityReport.Row(uri=" + this.getUri() + ", exceptionType=" + this.getExceptionType() + ", exceptionMessage=" + this.getExceptionMessage() + ", httpCode=" + this.getHttpCode() + ")";
        }
    }
}

