/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.UpgradeDependencyVersion;
import org.openrewrite.gradle.UpgradeTransitiveDependencyVersion;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.dependencies.Vulnerability;
import org.openrewrite.java.dependencies.internal.StaticVersionComparator;
import org.openrewrite.java.dependencies.internal.VersionParser;
import org.openrewrite.java.dependencies.table.VulnerabilityReport;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.marker.CommitMessage;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.AddManagedDependency;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.UpgradeDependencyVersion;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.semver.LatestPatch;
import org.openrewrite.xml.tree.Xml;

public final class DependencyVulnerabilityCheck
extends ScanningRecipe<Accumulator> {
    private final transient VersionParser versionParser = new VersionParser();
    private final transient VulnerabilityReport report = new VulnerabilityReport((Recipe)this);
    @Option(displayName="Scope", description="Match dependencies with the specified scope. Default is `compile`.", valid={"compile", "test", "runtime", "provided"}, example="compile", required=false)
    @Nullable
    private final String scope;
    @Option(displayName="Override transitives", description="When enabled transitive dependencies with vulnerabilities will have their versions overridden. By default only direct dependencies have their version numbers upgraded.", example="false", required=false)
    @Nullable
    private final Boolean overrideTransitive;
    @Option(displayName="Add search markers", description="Report each vulnerability as search result markers. When enabled you can see which dependencies are bringing in vulnerable transitives in the diff view. By default these markers are omitted, making it easier to see version upgrades within the diff.", required=false)
    @Nullable
    private final Boolean addMarkers;

    public String getDisplayName() {
        return "Find and fix vulnerable dependencies";
    }

    public String getDescription() {
        return "This software composition analysis (SCA) tool detects and upgrades dependencies with publicly disclosed vulnerabilities. This recipe both generates a report of vulnerable dependencies and upgrades to newer versions with fixes. This recipe **only** upgrades to the latest **patch** version.  If a minor or major upgrade is required to reach the fixed version, this recipe will not make any changes. Vulnerability information comes from the [GitHub Security Advisory Database](https://docs.github.com/en/code-security/security-advisories/global-security-advisories/about-the-github-advisory-database), which aggregates vulnerability data from several public databases, including the [National Vulnerability Database](https://nvd.nist.gov/) maintained by the United States government. Dependencies following [Semantic Versioning](https://semver.org/) will see their _patch_ version updated where applicable.";
    }

    public Validated<Object> validate() {
        return super.validate().and(Validated.test((String)"scope", (String)"scope is a valid Maven scope", (Object)this.scope, s -> {
            try {
                Scope.fromName((String)s);
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }));
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        Scope parsedScope = Scope.fromName((String)this.scope);
        CsvMapper csvMapper = new CsvMapper();
        csvMapper.registerModule((Module)new JavaTimeModule());
        HashMap<GroupArtifact, List<Vulnerability>> db = new HashMap<GroupArtifact, List<Vulnerability>>();
        try (InputStream resourceAsStream = DependencyVulnerabilityCheck.class.getResourceAsStream("/advisories-maven.csv");
             MappingIterator vs = csvMapper.readerWithSchemaFor(Vulnerability.class).readValues(resourceAsStream);){
            vs.forEachRemaining(v -> {
                String[] ga = v.getGroupArtifact().split(":");
                db.computeIfAbsent(new GroupArtifact(ga[0], ga[1]), g -> new ArrayList()).add(v);
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new Accumulator(db, new LinkedHashMap<String, Vulnerabilities>(), parsedScope, new UpgradeDependencyVersion.Accumulator(), new UpgradeDependencyVersion.DependencyVersionState());
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree == null) {
                    return null;
                }
                DependencyVulnerabilityCheck.this.scanMaven(acc.getDb(), acc.getProjectToVulnerabilities(), acc.getScope()).visitNonNull(tree, (Object)ctx);
                DependencyVulnerabilityCheck.this.scanGradleGroovy(acc.getDb(), acc.getProjectToVulnerabilities(), acc.getScope()).visitNonNull(tree, (Object)ctx);
                new UpgradeDependencyVersion("", "", "", null, null, null).getScanner(acc.getMavenUdvAcc()).visit(tree, (Object)ctx);
                new org.openrewrite.gradle.UpgradeDependencyVersion("", "", null, null).getScanner(acc.getGradleUdvAcc()).visit(tree, (Object)ctx);
                return tree;
            }
        };
    }

    public Collection<SourceFile> generate(Accumulator acc, ExecutionContext ctx) {
        for (Map.Entry<String, Vulnerabilities> projectToVulnerabilities : acc.getProjectToVulnerabilities().entrySet()) {
            String projectName = projectToVulnerabilities.getKey();
            for (Map.Entry<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> vulnerabilitiesByGav : projectToVulnerabilities.getValue().getGavToVulnerabilities().entrySet()) {
                for (MinimumDepthVulnerability vDepth : vulnerabilitiesByGav.getValue()) {
                    Vulnerability v = vDepth.getVulnerability();
                    ResolvedGroupArtifactVersion gav = vulnerabilitiesByGav.getKey();
                    boolean fixWithVersionUpdateOnly = (vDepth.getMinDepth() == 0 || Boolean.TRUE.equals(this.overrideTransitive)) && new LatestPatch(null).isValid(gav.getVersion(), v.getFixedVersion());
                    this.report.insertRow(ctx, new VulnerabilityReport.Row(projectName, v.getCve(), gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), v.getFixedVersion(), fixWithVersionUpdateOnly, v.getSummary(), v.getSeverity().toString(), vDepth.getMinDepth(), v.getCwes()));
                }
            }
        }
        return Collections.emptyList();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                Tree t;
                block12: {
                    block11: {
                        if (tree == null) {
                            return null;
                        }
                        t = tree;
                        if (!t.getMarkers().findFirst(MavenResolutionResult.class).isPresent()) break block11;
                        LinkedHashMap fixes = new LinkedHashMap();
                        Vulnerabilities vulnerabilities = acc.getProjectToVulnerabilities().getOrDefault(DependencyVulnerabilityCheck.projectName(t), Vulnerabilities.NONE);
                        if (vulnerabilities.getGavToVulnerabilities().isEmpty()) break block12;
                        t = DependencyVulnerabilityCheck.this.enumerateFixesMaven(vulnerabilities.getGavToVulnerabilities(), acc.getScope(), fixes).visitNonNull(t, (Object)ctx);
                        for (Map.Entry gav : fixes.entrySet()) {
                            Tree t2 = new UpgradeDependencyVersion(((GroupArtifact)gav.getKey()).getGroupId(), ((GroupArtifact)gav.getKey()).getArtifactId(), ((VersionBecause)gav.getValue()).getVersion(), null, DependencyVulnerabilityCheck.this.overrideTransitive, null).getVisitor(acc.getMavenUdvAcc()).visitNonNull(t, (Object)ctx);
                            if (t == t2 && ((VersionBecause)gav.getValue()).isDotReleaseAmbiguous()) {
                                t2 = new UpgradeDependencyVersion(((GroupArtifact)gav.getKey()).getGroupId(), ((GroupArtifact)gav.getKey()).getArtifactId(), ((VersionBecause)gav.getValue()).getVersion() + ".RELEASE", null, DependencyVulnerabilityCheck.this.overrideTransitive, null).getVisitor(acc.getMavenUdvAcc()).visitNonNull(t, (Object)ctx);
                            }
                            if (t == t2) {
                                if (!Boolean.TRUE.equals(DependencyVulnerabilityCheck.this.overrideTransitive)) continue;
                                AddManagedDependency amd = new AddManagedDependency(((GroupArtifact)gav.getKey()).getGroupId(), ((GroupArtifact)gav.getKey()).getArtifactId(), ((VersionBecause)gav.getValue()).getVersion(), null, null, null, null, null, null, null);
                                t2 = amd.getVisitor(amd.getInitialValue(ctx)).visitNonNull(t, (Object)ctx);
                                if (t == t2 && ((VersionBecause)gav.getValue()).isDotReleaseAmbiguous()) {
                                    amd = new AddManagedDependency(((GroupArtifact)gav.getKey()).getGroupId(), ((GroupArtifact)gav.getKey()).getArtifactId(), ((VersionBecause)gav.getValue()).getVersion() + ".RELEASE", null, null, null, null, null, null, null);
                                    t2 = amd.getVisitor(amd.getInitialValue(ctx)).visitNonNull(t, (Object)ctx);
                                }
                                if (t == t2) continue;
                                t = CommitMessage.message((Tree)t2, (Recipe)DependencyVulnerabilityCheck.this, (String)Objects.requireNonNull(((VersionBecause)gav.getValue()).getBecause()));
                                continue;
                            }
                            t = CommitMessage.message((Tree)t2, (Recipe)DependencyVulnerabilityCheck.this, (String)Objects.requireNonNull(((VersionBecause)gav.getValue()).getBecause()));
                        }
                        break block12;
                    }
                    if (t.getMarkers().findFirst(GradleProject.class).isPresent()) {
                        LinkedHashMap fixes = new LinkedHashMap();
                        Vulnerabilities vulnerabilities = acc.getProjectToVulnerabilities().getOrDefault(DependencyVulnerabilityCheck.projectName(t), Vulnerabilities.NONE);
                        if (!vulnerabilities.getGavToVulnerabilities().isEmpty()) {
                            t = DependencyVulnerabilityCheck.this.enumerateFixesGradleGroovy(vulnerabilities.getGavToVulnerabilities(), acc.getScope(), fixes).visitNonNull(t, (Object)ctx);
                            for (Map.Entry gaToVb : fixes.entrySet()) {
                                VersionBecause vb = (VersionBecause)gaToVb.getValue();
                                Tree t2 = new org.openrewrite.gradle.UpgradeDependencyVersion(((GroupArtifact)gaToVb.getKey()).getGroupId(), ((GroupArtifact)gaToVb.getKey()).getArtifactId(), vb.getVersion(), null).getVisitor(acc.getGradleUdvAcc()).visitNonNull(t, (Object)ctx);
                                if (t == t2 && vb.isDotReleaseAmbiguous()) {
                                    t2 = new org.openrewrite.gradle.UpgradeDependencyVersion(((GroupArtifact)gaToVb.getKey()).getGroupId(), ((GroupArtifact)gaToVb.getKey()).getArtifactId(), vb.getVersion() + ".RELEASE", null).getVisitor(acc.getGradleUdvAcc()).visitNonNull(t, (Object)ctx);
                                }
                                if (t == t2) {
                                    if (!Boolean.TRUE.equals(DependencyVulnerabilityCheck.this.overrideTransitive)) continue;
                                    t2 = new UpgradeTransitiveDependencyVersion(((GroupArtifact)gaToVb.getKey()).getGroupId(), ((GroupArtifact)gaToVb.getKey()).getArtifactId(), vb.getVersion(), null, vb.getBecause(), null).getVisitor().visitNonNull(t, (Object)ctx);
                                    if (t == t2 && vb.isDotReleaseAmbiguous()) {
                                        t2 = new UpgradeTransitiveDependencyVersion(((GroupArtifact)gaToVb.getKey()).getGroupId(), ((GroupArtifact)gaToVb.getKey()).getArtifactId(), vb.getVersion() + ".RELEASE", null, vb.getBecause(), null).getVisitor().visitNonNull(t, (Object)ctx);
                                    }
                                    if (t == t2) continue;
                                    t = CommitMessage.message((Tree)t2, (Recipe)DependencyVulnerabilityCheck.this, (String)vb.getBecause());
                                    continue;
                                }
                                t = CommitMessage.message((Tree)t2, (Recipe)DependencyVulnerabilityCheck.this, (String)vb.getBecause());
                            }
                        }
                    }
                }
                return t;
            }
        };
    }

    private MavenVisitor<ExecutionContext> scanMaven(final Map<GroupArtifact, List<Vulnerability>> db, final Map<String, Vulnerabilities> projectToVulnerabilities, final Scope aScope) {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                List scopeDependencies = (List)this.getResolutionResult().getDependencies().get(aScope);
                if (scopeDependencies != null) {
                    String projectName = DependencyVulnerabilityCheck.projectName((Tree)document);
                    for (ResolvedDependency resolvedDependency : scopeDependencies) {
                        DependencyVulnerabilityCheck.this.analyzeDependency(db, projectToVulnerabilities.computeIfAbsent(projectName, p -> new Vulnerabilities(new LinkedHashMap<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>>())), resolvedDependency);
                    }
                }
                return document;
            }
        };
    }

    private static String projectName(Tree t) {
        return t.getMarkers().findFirst(JavaProject.class).map(JavaProject::getProjectName).orElse("");
    }

    private static boolean scopeExcludesConfiguration(GradleDependencyConfiguration configuration, Scope scope) {
        switch (scope) {
            case Test: {
                return !configuration.getName().contains("test");
            }
            case Compile: 
            case Runtime: {
                return configuration.getName().contains("test");
            }
            case Provided: {
                return !configuration.getName().contains("provided") && !configuration.getName().contains("compileOnly");
            }
        }
        return false;
    }

    private GroovyVisitor<ExecutionContext> scanGradleGroovy(final Map<GroupArtifact, List<Vulnerability>> db, final Map<String, Vulnerabilities> projectToVulnerabilities, final Scope aScope) {
        return new GroovyIsoVisitor<ExecutionContext>(){

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                cu.getMarkers().findFirst(GradleProject.class).ifPresent(gradleProject -> {
                    String projectName = DependencyVulnerabilityCheck.projectName((Tree)cu);
                    for (GradleDependencyConfiguration configuration : gradleProject.getConfigurations()) {
                        if (DependencyVulnerabilityCheck.scopeExcludesConfiguration(configuration, aScope)) continue;
                        for (ResolvedDependency resolvedDependency : configuration.getResolved()) {
                            if (StringUtils.isBlank((String)resolvedDependency.getVersion())) continue;
                            DependencyVulnerabilityCheck.this.analyzeDependency(db, projectToVulnerabilities.computeIfAbsent(projectName, p -> new Vulnerabilities(new LinkedHashMap<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>>())), resolvedDependency);
                        }
                    }
                });
                return cu;
            }
        };
    }

    private void analyzeDependency(Map<GroupArtifact, List<Vulnerability>> db, Vulnerabilities vulnerabilities, ResolvedDependency resolvedDependency) {
        List<Vulnerability> vs = db.get(new GroupArtifact(resolvedDependency.getGroupId(), resolvedDependency.getArtifactId()));
        if (vs != null) {
            Set<MinimumDepthVulnerability> gavVs = null;
            StaticVersionComparator vc = new StaticVersionComparator();
            block0: for (Vulnerability v : vs) {
                boolean dotReleaseAmbiguous = resolvedDependency.getVersion().endsWith(".RELEASE") && !v.getFixedVersion().endsWith(".RELEASE");
                boolean isLessThanFixed = StringUtils.isBlank((String)v.getFixedVersion());
                if (!isLessThanFixed && vc.compare(this.versionParser.transform(DependencyVulnerabilityCheck.stripExtraneousVersionSuffix(v.getFixedVersion())), this.versionParser.transform(DependencyVulnerabilityCheck.stripExtraneousVersionSuffix(resolvedDependency.getVersion()))) > 0) {
                    isLessThanFixed = true;
                }
                if (!isLessThanFixed || vc.compare(this.versionParser.transform(DependencyVulnerabilityCheck.stripExtraneousVersionSuffix(v.getIntroducedVersion())), this.versionParser.transform(DependencyVulnerabilityCheck.stripExtraneousVersionSuffix(resolvedDependency.getVersion()))) > 0) continue;
                if (gavVs == null) {
                    gavVs = vulnerabilities.computeIfAbsent(resolvedDependency.getGav(), ga -> new TreeSet<MinimumDepthVulnerability>(Comparator.comparing(vDep -> vDep.getVulnerability().getSeverity()).reversed().thenComparing(vDep -> vDep.getVulnerability().getCve())));
                }
                for (MinimumDepthVulnerability vDep : gavVs) {
                    if (!vDep.getVulnerability().equals(v)) continue;
                    vDep.minDepth = Math.min(vDep.minDepth, resolvedDependency.getDepth());
                    continue block0;
                }
                gavVs.add(new MinimumDepthVulnerability(resolvedDependency.getDepth(), v, dotReleaseAmbiguous));
            }
        }
    }

    private MavenVisitor<ExecutionContext> enumerateFixesMaven(final Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> vulnerabilities, final Scope aScope, final Map<GroupArtifact, VersionBecause> fixes) {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                ResolvedDependency resolved;
                if (this.isDependencyTag() && (resolved = this.findDependency(tag, aScope)) != null) {
                    for (Map.Entry vulnerabilitiesByGav : vulnerabilities.entrySet()) {
                        ResolvedGroupArtifactVersion gav = (ResolvedGroupArtifactVersion)vulnerabilitiesByGav.getKey();
                        ResolvedDependency match = resolved.findDependency(Objects.requireNonNull(gav.getGroupId()), gav.getArtifactId());
                        if (match == null) continue;
                        boolean vulnerable = false;
                        for (MinimumDepthVulnerability vDepth2 : (Set)vulnerabilitiesByGav.getValue()) {
                            String fixVersion;
                            Vulnerability v = vDepth2.getVulnerability();
                            vulnerable = true;
                            GroupArtifact ga = new GroupArtifact(gav.getGroupId(), gav.getArtifactId());
                            String string = fixVersion = fixes.get(ga) == null ? null : ((VersionBecause)fixes.get(ga)).getVersion();
                            if (StringUtils.isBlank((String)v.getFixedVersion()) || !new LatestPatch(null).isValid(gav.getVersion(), v.getFixedVersion()) || fixVersion != null && new StaticVersionComparator().compare(DependencyVulnerabilityCheck.this.versionParser.transform(v.getFixedVersion()), DependencyVulnerabilityCheck.this.versionParser.transform(fixVersion)) <= 0) continue;
                            fixes.put(ga, new VersionBecause(v.getFixedVersion(), v.getCve(), vDepth2.dotReleaseAmbiguous));
                        }
                        if (!vulnerable || !Boolean.TRUE.equals(DependencyVulnerabilityCheck.this.addMarkers)) continue;
                        return (Xml.Tag)SearchResult.found((Tree)tag, (String)("This dependency includes " + gav + " which has the following vulnerabilities:\n" + ((Set)vulnerabilitiesByGav.getValue()).stream().map(vDepth -> {
                            Vulnerability v = vDepth.getVulnerability();
                            return v.getCve() + " (" + (Object)((Object)v.getSeverity()) + " severity" + (StringUtils.isBlank((String)v.getFixedVersion()) ? "" : ", fixed in " + v.getFixedVersion()) + ") - " + v.getSummary();
                        }).collect(Collectors.joining("\n"))));
                    }
                }
                return super.visitTag(tag, (Object)ctx);
            }
        };
    }

    private GroovyVisitor<ExecutionContext> enumerateFixesGradleGroovy(final Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> vulnerabilities, final Scope aScope, final Map<GroupArtifact, VersionBecause> fixes) {
        return new GroovyIsoVisitor<ExecutionContext>(){

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                G.CompilationUnit c = cu;
                GradleProject gp = (GradleProject)c.getMarkers().findFirst(GradleProject.class).get();
                for (Map.Entry vulnerabilitiesByGav : vulnerabilities.entrySet()) {
                    ResolvedGroupArtifactVersion gav = (ResolvedGroupArtifactVersion)vulnerabilitiesByGav.getKey();
                    if (Boolean.TRUE.equals(DependencyVulnerabilityCheck.this.addMarkers)) {
                        c = (G.CompilationUnit)SearchResult.found((Tree)c, (String)("This project has the following vulnerabilities:\n" + ((Set)vulnerabilitiesByGav.getValue()).stream().map(vDepth -> {
                            Vulnerability v = vDepth.getVulnerability();
                            return "Dependency " + gav + " has " + v.getCve() + " (" + (Object)((Object)v.getSeverity()) + " severity" + (StringUtils.isBlank((String)v.getFixedVersion()) ? "" : ", fixed in " + v.getFixedVersion()) + ") - " + v.getSummary();
                        }).collect(Collectors.joining("\n"))));
                    }
                    for (GradleDependencyConfiguration configuration : gp.getConfigurations()) {
                        if (DependencyVulnerabilityCheck.scopeExcludesConfiguration(configuration, aScope) || !configuration.isCanBeResolved()) continue;
                        List resolved = configuration.getResolved();
                        for (ResolvedDependency resolvedDependency : resolved) {
                            if (!Objects.equals(resolvedDependency.getGroupId(), gav.getGroupId()) || !Objects.equals(resolvedDependency.getArtifactId(), gav.getArtifactId())) continue;
                            for (MinimumDepthVulnerability vDepth2 : (Set)vulnerabilitiesByGav.getValue()) {
                                String fixVersion;
                                Vulnerability v = vDepth2.getVulnerability();
                                GroupArtifact ga = new GroupArtifact(gav.getGroupId(), gav.getArtifactId());
                                String string = fixVersion = fixes.get(ga) == null ? null : ((VersionBecause)fixes.get(ga)).getVersion();
                                if (StringUtils.isBlank((String)v.getFixedVersion()) || !new LatestPatch(null).isValid(gav.getVersion(), v.getFixedVersion()) || fixVersion != null && new StaticVersionComparator().compare(DependencyVulnerabilityCheck.this.versionParser.transform(v.getFixedVersion()), DependencyVulnerabilityCheck.this.versionParser.transform(fixVersion)) <= 0) continue;
                                fixes.put(ga, new VersionBecause(v.getFixedVersion(), v.getCve(), vDepth2.dotReleaseAmbiguous));
                            }
                        }
                    }
                }
                return c;
            }
        };
    }

    private static String stripExtraneousVersionSuffix(String version) {
        if (version.endsWith(".RELEASE")) {
            return version.substring(0, version.length() - ".RELEASE".length());
        }
        return version;
    }

    @ConstructorProperties(value={"scope", "overrideTransitive", "addMarkers"})
    @Generated
    public DependencyVulnerabilityCheck(@Nullable String scope, @Nullable Boolean overrideTransitive, @Nullable Boolean addMarkers) {
        this.scope = scope;
        this.overrideTransitive = overrideTransitive;
        this.addMarkers = addMarkers;
    }

    @Generated
    public VersionParser getVersionParser() {
        return this.versionParser;
    }

    @Generated
    public VulnerabilityReport getReport() {
        return this.report;
    }

    @Nullable
    @Generated
    public String getScope() {
        return this.scope;
    }

    @Nullable
    @Generated
    public Boolean getOverrideTransitive() {
        return this.overrideTransitive;
    }

    @Nullable
    @Generated
    public Boolean getAddMarkers() {
        return this.addMarkers;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DependencyVulnerabilityCheck(versionParser=" + this.getVersionParser() + ", report=" + (Object)((Object)this.getReport()) + ", scope=" + this.getScope() + ", overrideTransitive=" + this.getOverrideTransitive() + ", addMarkers=" + this.getAddMarkers() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyVulnerabilityCheck)) {
            return false;
        }
        DependencyVulnerabilityCheck other = (DependencyVulnerabilityCheck)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$overrideTransitive = this.getOverrideTransitive();
        Boolean other$overrideTransitive = other.getOverrideTransitive();
        if (this$overrideTransitive == null ? other$overrideTransitive != null : !((Object)this$overrideTransitive).equals(other$overrideTransitive)) {
            return false;
        }
        Boolean this$addMarkers = this.getAddMarkers();
        Boolean other$addMarkers = other.getAddMarkers();
        if (this$addMarkers == null ? other$addMarkers != null : !((Object)this$addMarkers).equals(other$addMarkers)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DependencyVulnerabilityCheck;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $overrideTransitive = this.getOverrideTransitive();
        result = result * 59 + ($overrideTransitive == null ? 43 : ((Object)$overrideTransitive).hashCode());
        Boolean $addMarkers = this.getAddMarkers();
        result = result * 59 + ($addMarkers == null ? 43 : ((Object)$addMarkers).hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }

    public static final class Vulnerabilities {
        public static Vulnerabilities NONE = new Vulnerabilities(Collections.emptyMap());
        private final Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> gavToVulnerabilities;

        public Set<MinimumDepthVulnerability> computeIfAbsent(ResolvedGroupArtifactVersion gav, Function<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> mappingFunction) {
            return this.gavToVulnerabilities.computeIfAbsent(gav, mappingFunction);
        }

        @ConstructorProperties(value={"gavToVulnerabilities"})
        @Generated
        public Vulnerabilities(Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> gavToVulnerabilities) {
            this.gavToVulnerabilities = gavToVulnerabilities;
        }

        @Generated
        public Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> getGavToVulnerabilities() {
            return this.gavToVulnerabilities;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Vulnerabilities)) {
                return false;
            }
            Vulnerabilities other = (Vulnerabilities)o;
            Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> this$gavToVulnerabilities = this.getGavToVulnerabilities();
            Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> other$gavToVulnerabilities = other.getGavToVulnerabilities();
            return !(this$gavToVulnerabilities == null ? other$gavToVulnerabilities != null : !((Object)this$gavToVulnerabilities).equals(other$gavToVulnerabilities));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> $gavToVulnerabilities = this.getGavToVulnerabilities();
            result = result * 59 + ($gavToVulnerabilities == null ? 43 : ((Object)$gavToVulnerabilities).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "DependencyVulnerabilityCheck.Vulnerabilities(gavToVulnerabilities=" + this.getGavToVulnerabilities() + ")";
        }
    }

    public static final class Accumulator {
        private final Map<GroupArtifact, List<Vulnerability>> db;
        private final Map<String, Vulnerabilities> projectToVulnerabilities;
        private final Scope scope;
        private final UpgradeDependencyVersion.Accumulator mavenUdvAcc;
        private final UpgradeDependencyVersion.DependencyVersionState gradleUdvAcc;

        @ConstructorProperties(value={"db", "projectToVulnerabilities", "scope", "mavenUdvAcc", "gradleUdvAcc"})
        @Generated
        public Accumulator(Map<GroupArtifact, List<Vulnerability>> db, Map<String, Vulnerabilities> projectToVulnerabilities, Scope scope, UpgradeDependencyVersion.Accumulator mavenUdvAcc, UpgradeDependencyVersion.DependencyVersionState gradleUdvAcc) {
            this.db = db;
            this.projectToVulnerabilities = projectToVulnerabilities;
            this.scope = scope;
            this.mavenUdvAcc = mavenUdvAcc;
            this.gradleUdvAcc = gradleUdvAcc;
        }

        @Generated
        public Map<GroupArtifact, List<Vulnerability>> getDb() {
            return this.db;
        }

        @Generated
        public Map<String, Vulnerabilities> getProjectToVulnerabilities() {
            return this.projectToVulnerabilities;
        }

        @Generated
        public Scope getScope() {
            return this.scope;
        }

        @Generated
        public UpgradeDependencyVersion.Accumulator getMavenUdvAcc() {
            return this.mavenUdvAcc;
        }

        @Generated
        public UpgradeDependencyVersion.DependencyVersionState getGradleUdvAcc() {
            return this.gradleUdvAcc;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            Map<GroupArtifact, List<Vulnerability>> this$db = this.getDb();
            Map<GroupArtifact, List<Vulnerability>> other$db = other.getDb();
            if (this$db == null ? other$db != null : !((Object)this$db).equals(other$db)) {
                return false;
            }
            Map<String, Vulnerabilities> this$projectToVulnerabilities = this.getProjectToVulnerabilities();
            Map<String, Vulnerabilities> other$projectToVulnerabilities = other.getProjectToVulnerabilities();
            if (this$projectToVulnerabilities == null ? other$projectToVulnerabilities != null : !((Object)this$projectToVulnerabilities).equals(other$projectToVulnerabilities)) {
                return false;
            }
            Scope this$scope = this.getScope();
            Scope other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
                return false;
            }
            UpgradeDependencyVersion.Accumulator this$mavenUdvAcc = this.getMavenUdvAcc();
            UpgradeDependencyVersion.Accumulator other$mavenUdvAcc = other.getMavenUdvAcc();
            if (this$mavenUdvAcc == null ? other$mavenUdvAcc != null : !this$mavenUdvAcc.equals(other$mavenUdvAcc)) {
                return false;
            }
            UpgradeDependencyVersion.DependencyVersionState this$gradleUdvAcc = this.getGradleUdvAcc();
            UpgradeDependencyVersion.DependencyVersionState other$gradleUdvAcc = other.getGradleUdvAcc();
            return !(this$gradleUdvAcc == null ? other$gradleUdvAcc != null : !this$gradleUdvAcc.equals(other$gradleUdvAcc));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<GroupArtifact, List<Vulnerability>> $db = this.getDb();
            result = result * 59 + ($db == null ? 43 : ((Object)$db).hashCode());
            Map<String, Vulnerabilities> $projectToVulnerabilities = this.getProjectToVulnerabilities();
            result = result * 59 + ($projectToVulnerabilities == null ? 43 : ((Object)$projectToVulnerabilities).hashCode());
            Scope $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            UpgradeDependencyVersion.Accumulator $mavenUdvAcc = this.getMavenUdvAcc();
            result = result * 59 + ($mavenUdvAcc == null ? 43 : $mavenUdvAcc.hashCode());
            UpgradeDependencyVersion.DependencyVersionState $gradleUdvAcc = this.getGradleUdvAcc();
            result = result * 59 + ($gradleUdvAcc == null ? 43 : $gradleUdvAcc.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "DependencyVulnerabilityCheck.Accumulator(db=" + this.getDb() + ", projectToVulnerabilities=" + this.getProjectToVulnerabilities() + ", scope=" + this.getScope() + ", mavenUdvAcc=" + this.getMavenUdvAcc() + ", gradleUdvAcc=" + this.getGradleUdvAcc() + ")";
        }
    }

    public static final class MinimumDepthVulnerability {
        private int minDepth;
        private final Vulnerability vulnerability;
        private final boolean dotReleaseAmbiguous;

        @ConstructorProperties(value={"minDepth", "vulnerability", "dotReleaseAmbiguous"})
        @Generated
        public MinimumDepthVulnerability(int minDepth, Vulnerability vulnerability, boolean dotReleaseAmbiguous) {
            this.minDepth = minDepth;
            this.vulnerability = vulnerability;
            this.dotReleaseAmbiguous = dotReleaseAmbiguous;
        }

        @Generated
        public int getMinDepth() {
            return this.minDepth;
        }

        @Generated
        public Vulnerability getVulnerability() {
            return this.vulnerability;
        }

        @Generated
        public boolean isDotReleaseAmbiguous() {
            return this.dotReleaseAmbiguous;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MinimumDepthVulnerability)) {
                return false;
            }
            MinimumDepthVulnerability other = (MinimumDepthVulnerability)o;
            if (this.getMinDepth() != other.getMinDepth()) {
                return false;
            }
            if (this.isDotReleaseAmbiguous() != other.isDotReleaseAmbiguous()) {
                return false;
            }
            Vulnerability this$vulnerability = this.getVulnerability();
            Vulnerability other$vulnerability = other.getVulnerability();
            return !(this$vulnerability == null ? other$vulnerability != null : !((Object)this$vulnerability).equals(other$vulnerability));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMinDepth();
            result = result * 59 + (this.isDotReleaseAmbiguous() ? 79 : 97);
            Vulnerability $vulnerability = this.getVulnerability();
            result = result * 59 + ($vulnerability == null ? 43 : ((Object)$vulnerability).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "DependencyVulnerabilityCheck.MinimumDepthVulnerability(minDepth=" + this.getMinDepth() + ", vulnerability=" + this.getVulnerability() + ", dotReleaseAmbiguous=" + this.isDotReleaseAmbiguous() + ")";
        }
    }

    private static final class VersionBecause {
        private final String version;
        @Nullable
        private final String because;
        private final boolean dotReleaseAmbiguous;

        @ConstructorProperties(value={"version", "because", "dotReleaseAmbiguous"})
        @Generated
        public VersionBecause(String version, @Nullable String because, boolean dotReleaseAmbiguous) {
            this.version = version;
            this.because = because;
            this.dotReleaseAmbiguous = dotReleaseAmbiguous;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Nullable
        @Generated
        public String getBecause() {
            return this.because;
        }

        @Generated
        public boolean isDotReleaseAmbiguous() {
            return this.dotReleaseAmbiguous;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VersionBecause)) {
                return false;
            }
            VersionBecause other = (VersionBecause)o;
            if (this.isDotReleaseAmbiguous() != other.isDotReleaseAmbiguous()) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$because = this.getBecause();
            String other$because = other.getBecause();
            return !(this$because == null ? other$because != null : !this$because.equals(other$because));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDotReleaseAmbiguous() ? 79 : 97);
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $because = this.getBecause();
            result = result * 59 + ($because == null ? 43 : $because.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "DependencyVulnerabilityCheck.VersionBecause(version=" + this.getVersion() + ", because=" + this.getBecause() + ", dotReleaseAmbiguous=" + this.isDotReleaseAmbiguous() + ")";
        }
    }
}

