/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.yaml.ChangeValue;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.search.FindKey;
import org.openrewrite.yaml.tree.Yaml;

public final class ChangeActionVersion
extends Recipe {
    @Option(displayName="Action", description="Name of the action to update.", example="actions/setup-java")
    private final String action;
    @Option(displayName="Version", description="Version to use.", example="v4")
    private final String version;
    private final String displayName = "Change GitHub Action version";
    private final String description = "Change the version of a GitHub Action in any workflow.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsGitHubActionsWorkflow(), (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Documents visitDocuments(Yaml.Documents documents, ExecutionContext ctx) {
                Yaml.Documents docs = super.visitDocuments(documents, (Object)ctx);
                for (Yaml uses : FindKey.find((Yaml)docs, (String)("$.jobs..[?(@.uses =~ '" + ChangeActionVersion.this.action + "(?:@.+)?')].uses"))) {
                    if (!(uses instanceof Yaml.Mapping.Entry) || !(((Yaml.Mapping.Entry)uses).getValue() instanceof Yaml.Scalar)) continue;
                    String oldAction = ((Yaml.Scalar)((Yaml.Mapping.Entry)uses).getValue()).getValue().split("@")[0];
                    docs = (Yaml.Documents)new ChangeValue("$.jobs..[?(@.uses =~ '" + oldAction + "(?:@.+)?')].uses", oldAction + '@' + ChangeActionVersion.this.version, null).getVisitor().visitNonNull((Tree)docs, (Object)ctx);
                }
                return docs;
            }
        });
    }

    @Generated
    public ChangeActionVersion(String action, String version) {
        this.action = action;
        this.version = version;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "ChangeActionVersion(action=" + this.getAction() + ", version=" + this.getVersion() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeActionVersion)) {
            return false;
        }
        ChangeActionVersion other = (ChangeActionVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChangeActionVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

