/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class AnonymousJobsRecipe
extends Recipe {
    public String getDisplayName() {
        return "Find jobs without descriptive names";
    }

    public String getDescription() {
        return "Find jobs that lack descriptive names, making them harder to identify in workflow runs. Jobs without `name` properties default to their job ID, which may not be descriptive. Based on [zizmor's anonymous-definition audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/anonymous_definition.rs).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsGitHubActionsWorkflow(), (TreeVisitor)new AnonymousJobsVisitor());
    }

    @Generated
    public AnonymousJobsRecipe() {
    }

    @Generated
    public String toString() {
        return "AnonymousJobsRecipe()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnonymousJobsRecipe)) {
            return false;
        }
        AnonymousJobsRecipe other = (AnonymousJobsRecipe)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnonymousJobsRecipe;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class AnonymousJobsVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private AnonymousJobsVisitor() {
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
            if (this.isInsideJobsMapping() && mappingEntry.getValue() instanceof Yaml.Mapping) {
                Yaml.Mapping jobMapping = (Yaml.Mapping)mappingEntry.getValue();
                boolean hasName = jobMapping.getEntries().stream().anyMatch(jobProp -> {
                    if (jobProp.getKey() instanceof Yaml.Scalar) {
                        Yaml.Scalar scalar = (Yaml.Scalar)jobProp.getKey();
                        return "name".equals(scalar.getValue());
                    }
                    return false;
                });
                boolean isReusableWorkflowCall = jobMapping.getEntries().stream().anyMatch(jobProp -> {
                    if (jobProp.getKey() instanceof Yaml.Scalar) {
                        Yaml.Scalar scalar = (Yaml.Scalar)jobProp.getKey();
                        return "uses".equals(scalar.getValue());
                    }
                    return false;
                });
                if (!hasName && !isReusableWorkflowCall) {
                    return (Yaml.Mapping.Entry)SearchResult.found((Tree)mappingEntry, (String)"Job has no name. Add a descriptive name to make it easier to identify in workflow runs.");
                }
            }
            return mappingEntry;
        }

        private boolean isInsideJobsMapping() {
            Yaml.Mapping.Entry grandParentEntry;
            Cursor current = this.getCursor();
            Cursor parent = current.getParent();
            if (parent == null) {
                return false;
            }
            Object parentValue = parent.getValue();
            if (!(parentValue instanceof Yaml.Mapping)) {
                return false;
            }
            Cursor grandParent = parent.getParent();
            if (grandParent == null) {
                return false;
            }
            Object grandParentValue = grandParent.getValue();
            if (grandParentValue instanceof Yaml.Mapping.Entry && (grandParentEntry = (Yaml.Mapping.Entry)grandParentValue).getKey() instanceof Yaml.Scalar) {
                Yaml.Scalar key = (Yaml.Scalar)grandParentEntry.getKey();
                return "jobs".equals(key.getValue());
            }
            return false;
        }
    }
}

