/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class ArtifactSecurityRecipe
extends Recipe {
    private static final Set<String> DANGEROUS_PATHS = new HashSet<String>(Arrays.asList("~/.ssh/", "~/.ssh", ".ssh/", ".ssh", "~/.aws/", "~/.aws", ".aws/", ".aws", "~/.docker/", "~/.docker", ".docker/", ".docker", "~/.kube/", "~/.kube", ".kube/", ".kube", "~/.config/", "~/.config", "~/.gitconfig", ".gitconfig", "~/.npmrc", ".npmrc", "~/.pypirc", ".pypirc", "/etc/passwd", "/etc/shadow", "/etc/hosts", "/var/log/", "/var/log", "/tmp/", "/tmp", "/root/", "/root", "~/.bash_history", ".bash_history", "~/.zsh_history", ".zsh_history", "/home/", "/home"));
    private static final String[] DANGEROUS_PATTERNS = new String[]{"config.json", "credentials", "token", "secret", "key", "password", "passwd"};

    public String getDisplayName() {
        return "Find credential persistence through GitHub Actions artifacts";
    }

    public String getDescription() {
        return "Find workflows that may persist credentials through artifact uploads. This occurs when checkout actions don't disable credential persistence and upload actions include sensitive paths that may contain credentials, SSH keys, or configuration files. Based on [zizmor's `artipacked` audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/artipacked.rs).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(".github/workflows/*.yml"), (TreeVisitor)new ArtifactSecurityVisitor());
    }

    @Generated
    public ArtifactSecurityRecipe() {
    }

    @Generated
    public String toString() {
        return "ArtifactSecurityRecipe()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArtifactSecurityRecipe)) {
            return false;
        }
        ArtifactSecurityRecipe other = (ArtifactSecurityRecipe)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArtifactSecurityRecipe;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class ArtifactSecurityVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private ArtifactSecurityVisitor() {
        }

        public Yaml.Document visitDocument(Yaml.Document document, ExecutionContext ctx) {
            Yaml.Document d = super.visitDocument(document, (Object)ctx);
            if (d.getBlock() instanceof Yaml.Mapping) {
                this.checkWorkflowForCredentialPersistence((Yaml.Mapping)d.getBlock());
            }
            return d;
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
            if (this.isUsesEntry(mappingEntry)) {
                return this.checkUsesEntry(mappingEntry);
            }
            return mappingEntry;
        }

        private boolean isUsesEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getKey() instanceof Yaml.Scalar)) {
                return false;
            }
            Yaml.Scalar key = (Yaml.Scalar)entry.getKey();
            return "uses".equals(key.getValue());
        }

        private Yaml.Mapping.Entry checkUsesEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getValue() instanceof Yaml.Scalar)) {
                return entry;
            }
            String usesValue = ((Yaml.Scalar)entry.getValue()).getValue();
            if (usesValue.startsWith("actions/checkout")) {
                return this.checkCheckoutAction(entry);
            }
            if (usesValue.startsWith("actions/upload-artifact")) {
                return this.checkUploadArtifactAction(entry);
            }
            return entry;
        }

        private Yaml.Mapping.Entry checkCheckoutAction(Yaml.Mapping.Entry entry) {
            Yaml.Mapping stepMapping = this.findParentStepMapping();
            if (stepMapping == null) {
                return entry;
            }
            Yaml.Mapping withMapping = this.findWithMapping(stepMapping);
            if (withMapping == null) {
                if (this.workflowHasArtifactUpload()) {
                    return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Checkout step does not disable credential persistence, which may expose credentials in artifacts.");
                }
            } else {
                String persistCredentials = this.getWithValue(withMapping, "persist-credentials");
                if ("true".equals(persistCredentials) && this.workflowHasArtifactUpload()) {
                    return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Checkout step explicitly enables credential persistence, which may expose credentials in artifacts.");
                }
            }
            return entry;
        }

        private Yaml.Mapping.Entry checkUploadArtifactAction(Yaml.Mapping.Entry entry) {
            Yaml.Mapping stepMapping = this.findParentStepMapping();
            if (stepMapping == null) {
                return entry;
            }
            Yaml.Mapping withMapping = this.findWithMapping(stepMapping);
            if (withMapping == null) {
                return entry;
            }
            String pathValue = this.getWithValue(withMapping, "path");
            if (pathValue != null && this.hasDangerousArtifactPaths(pathValue)) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Uploading potentially sensitive paths that may contain credentials or configuration files.");
            }
            return entry;
        }

        private void checkWorkflowForCredentialPersistence(Yaml.Mapping workflowMapping) {
        }

        private boolean workflowHasArtifactUpload() {
            for (Cursor current = this.getCursor(); current != null; current = current.getParent()) {
                Object value = current.getValue();
                if (!(value instanceof Yaml.Document)) continue;
                Yaml.Document doc = (Yaml.Document)value;
                return this.containsUploadArtifact(doc);
            }
            return false;
        }

        private boolean containsUploadArtifact(Yaml.Document document) {
            if (!(document.getBlock() instanceof Yaml.Mapping)) {
                return false;
            }
            String docContent = document.print(this.getCursor());
            return docContent.contains("actions/upload-artifact");
        }

        private boolean hasDangerousArtifactPaths(String pathValue) {
            for (String dangerousPath : DANGEROUS_PATHS) {
                if (!pathValue.contains(dangerousPath)) continue;
                return true;
            }
            String lowerPath = pathValue.toLowerCase();
            for (String pattern : DANGEROUS_PATTERNS) {
                if (!lowerPath.contains(pattern)) continue;
                return true;
            }
            return ".".equals(pathValue.trim()) || "~".equals(pathValue.trim()) || "/".equals(pathValue.trim());
        }

        private Yaml.Mapping findParentStepMapping() {
            for (Cursor current = this.getCursor(); current != null; current = current.getParent()) {
                Yaml.Mapping mapping;
                boolean hasUses;
                Object value = current.getValue();
                if (!(value instanceof Yaml.Mapping) || !(hasUses = (mapping = (Yaml.Mapping)value).getEntries().stream().anyMatch(mapEntry -> {
                    if (mapEntry.getKey() instanceof Yaml.Scalar) {
                        Yaml.Scalar key = (Yaml.Scalar)mapEntry.getKey();
                        return "uses".equals(key.getValue());
                    }
                    return false;
                }))) continue;
                return mapping;
            }
            return null;
        }

        private Yaml.Mapping findWithMapping(Yaml.Mapping stepMapping) {
            for (Yaml.Mapping.Entry stepEntry : stepMapping.getEntries()) {
                Yaml.Scalar key;
                if (!(stepEntry.getKey() instanceof Yaml.Scalar) || !"with".equals((key = (Yaml.Scalar)stepEntry.getKey()).getValue()) || !(stepEntry.getValue() instanceof Yaml.Mapping)) continue;
                return (Yaml.Mapping)stepEntry.getValue();
            }
            return null;
        }

        private String getWithValue(Yaml.Mapping withMapping, String key) {
            for (Yaml.Mapping.Entry withEntry : withMapping.getEntries()) {
                Yaml.Scalar withKey;
                if (!(withEntry.getKey() instanceof Yaml.Scalar) || !key.equals((withKey = (Yaml.Scalar)withEntry.getKey()).getValue()) || !(withEntry.getValue() instanceof Yaml.Scalar)) continue;
                return ((Yaml.Scalar)withEntry.getValue()).getValue();
            }
            return null;
        }
    }
}

