/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.SetupJavaDistributionReplacerVisitor;

public class SetupJavaAdoptOpenJDKToTemurin
extends Recipe {
    public String getDisplayName() {
        return "Use `actions/setup-java` `temurin` distribution";
    }

    public String getDescription() {
        return "Adopt OpenJDK got moved to Eclipse Temurin and won't be updated anymore. It is highly recommended to migrate workflows from adopt to temurin to keep receiving software and security updates. See more details in the [Good-bye AdoptOpenJDK post](https://blog.adoptopenjdk.net/2021/08/goodbye-adoptopenjdk-hello-adoptium/).";
    }

    public Set<String> getTags() {
        return Collections.singleton("security");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new HasSourcePath(".github/workflows/*.yml"), (TreeVisitor)new SetupJavaDistributionReplacerVisitor(Arrays.asList("adopt", "adopt-hotspot"), "temurin"));
    }
}

