/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import java.time.Duration;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.yaml.DeleteKey;
import org.openrewrite.yaml.MergeYaml;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.search.FindKey;
import org.openrewrite.yaml.tree.Yaml;

public class SetupJavaCaching
extends Recipe {
    public String getDisplayName() {
        return "Setup Java dependency caching";
    }

    public String getDescription() {
        return "Github actions supports dependency caching on Maven and Gradle projects. See the [blog post](https://github.blog/changelog/2021-08-30-github-actions-setup-java-now-supports-dependency-caching/).";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new HasSourcePath(".github/workflows/*.yml");
    }

    protected YamlVisitor<ExecutionContext> getVisitor() {
        return new YamlVisitor<ExecutionContext>(){

            public Yaml visitDocuments(Yaml.Documents documents, ExecutionContext ctx) {
                if (!FindKey.find((Yaml)documents, (String)"$.jobs.build.steps[?(@.run =~ '.*gradle.*')]").isEmpty()) {
                    this.doAfterVisit((Recipe)new MergeYaml("$.jobs.build.steps[?(@.uses =~ 'actions/setup-java(?:@v.+)?')]", "with:\n  cache: 'gradle'", Boolean.valueOf(true), null));
                    this.deleteCacheAction();
                }
                if (!FindKey.find((Yaml)documents, (String)"$.jobs.build.steps[?(@.run =~ '.*mvn.*')]").isEmpty()) {
                    this.doAfterVisit((Recipe)new MergeYaml("$.jobs.build.steps[?(@.uses =~ 'actions/setup-java(?:@v.+)?')]", "with:\n  cache: 'maven'", Boolean.valueOf(true), null));
                    this.deleteCacheAction();
                }
                return documents;
            }

            private void deleteCacheAction() {
                this.doAfterVisit((Recipe)new DeleteKey("$.jobs.build.steps[?(@.uses =~ 'actions/cache(?:@v.+)?')]", null));
            }
        };
    }
}

