/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.commons.lang;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openrewrite.apache.commons.lang.RepeatableArgumentMatcher;
import org.openrewrite.java.template.Matches;
import org.openrewrite.java.template.RecipeDescriptor;

public class ApacheCommonsStringUtils {

    @RecipeDescriptor(name="Replace `StringUtils.upperCase(String)` with JDK internals", description="Replace Apache Commons `StringUtils.upperCase(String str)` with JDK internals.")
    public static class Uppercase {
        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.upperCase((String)s);
        }

        String after(String s) {
            return s == null ? null : s.toUpperCase();
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.trim(String)` with JDK provided API", description="Replace Apache Commons `StringUtils.trim(String str)` with JDK provided API.")
    public static class Trim {
        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.trim((String)s);
        }

        String after(String s) {
            return s == null ? null : s.trim();
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.trimToNull(String)` with JDK provided API", description="Replace Apache Commons `StringUtils.trimToNull(String str)` with JDK provided API.")
    public static class TrimToNull {
        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.trimToNull((String)s);
        }

        String after(String s) {
            return s == null || s.trim().isEmpty() ? null : s.trim();
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.trimToEmpty(String)` with JDK provided API", description="Replace Apache Commons `StringUtils.trimToEmpty(String str)` with JDK provided API.")
    public static class TrimToEmpty {
        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.trimToEmpty((String)s);
        }

        String after(String s) {
            return s == null ? "" : s.trim();
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.strip(String)` with JDK provided API", description="Replace Apache Commons `StringUtils.strip(String str)` with JDK provided API.")
    public static class Strip {
        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.strip((String)s);
        }

        String after(String s) {
            return s == null ? null : s.trim();
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.split(String)` with JDK provided API", description="Replace Apache Commons `StringUtils.split(String str)` with JDK provided API.")
    public static class Split {
        String[] before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.split((String)s);
        }

        String[] after(String s) {
            return s == null ? null : s.split("\\s+");
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.reverse(String)` with JDK provided API", description="Replace Apache Commons `StringUtils.reverse(String str)` with JDK provided API.")
    public static class Reverse {
        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.reverse((String)s);
        }

        String after(String s) {
            return s == null ? null : new StringBuilder(s).reverse().toString();
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.replace(String, String, String)` with JDK provided API", description="Replace Apache Commons `StringUtils.replace(String text, String searchString, String replacement)` with JDK provided API.")
    public static class Replace {
        String before(@Matches(value=RepeatableArgumentMatcher.class) String s, @Matches(value=RepeatableArgumentMatcher.class) String search, @Matches(value=RepeatableArgumentMatcher.class) String replacement) {
            return StringUtils.replace((String)s, (String)search, (String)replacement);
        }

        String after(String s, String search, String replacement) {
            return s == null || s.isEmpty() || search == null || search.isEmpty() || replacement == null ? s : s.replace(search, replacement);
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.removeEnd(String, String)` with JDK provided API", description="Replace Apache Commons `StringUtils.removeEnd(String str, String remove)` with JDK provided API.")
    public static class RemoveEnd {
        String before(@Matches(value=RepeatableArgumentMatcher.class) String s, @Matches(value=RepeatableArgumentMatcher.class) String end) {
            return StringUtils.removeEnd((String)s, (String)end);
        }

        String after(String s, String end) {
            return s == null || s.isEmpty() || end == null || end.isEmpty() || !s.endsWith(end) ? s : s.substring(0, s.length() - end.length());
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.lowerCase(String)` with JDK provided API", description="Replace Apache Commons `StringUtils.lowerCase(String str)` with JDK provided API.")
    public static class Lowercase {
        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.lowerCase((String)s);
        }

        String after(String s) {
            return s == null ? null : s.toLowerCase();
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.equals(CharSequence, CharSequence)` with JDK provided API", description="Replace Apache Commons `StringUtils.equals(CharSequence cs1, CharSequence cs2)` with JDK provided API.")
    public static class Equals {
        boolean before(String s, String other) {
            return StringUtils.equals((CharSequence)s, (CharSequence)other);
        }

        boolean after(String s, String other) {
            return Objects.equals(s, other);
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.equalsIgnoreCase(CharSequence, CharSequence)` with JDK provided API", description="Replace Apache Commons `StringUtils.equalsIgnoreCase(CharSequence cs1, CharSequence cs2)` with JDK provided API.")
    public static class EqualsIgnoreCase {
        boolean before(@Matches(value=RepeatableArgumentMatcher.class) String s, @Matches(value=RepeatableArgumentMatcher.class) String other) {
            return StringUtils.equalsIgnoreCase((CharSequence)s, (CharSequence)other);
        }

        boolean after(String s, String other) {
            return s == null ? other == null : s.equalsIgnoreCase(other);
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.deleteWhitespace(String)` with JDK provided API", description="Replace Apache Commons `StringUtils.deleteWhitespace(String str)` with JDK provided API.")
    public static class DeleteWhitespace {
        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.deleteWhitespace((String)s);
        }

        String after(String s) {
            return s == null ? null : s.replaceAll("\\s+", "");
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.defaultString(String, String)` with JDK provided API", description="Replace Apache Commons `StringUtils.defaultString(String str, String nullDefault)` with JDK provided API.")
    public static class DefaultStringFallback {
        String before(String s, String nullDefault) {
            return StringUtils.defaultString((String)s, (String)nullDefault);
        }

        String after(String s, String nullDefault) {
            return Objects.toString(s, nullDefault);
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.defaultString(String)` with JDK provided API", description="Replace Apache Commons `StringUtils.defaultString(String str)` with JDK provided API.")
    public static class DefaultString {
        String before(String s) {
            return StringUtils.defaultString((String)s);
        }

        String after(String s) {
            return Objects.toString(s, "");
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.capitalize(String)` with JDK provided API", description="Replace Apache Commons `StringUtils.capitalize(String str)` with JDK provided API.")
    public static class Capitalize {
        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.capitalize((String)s);
        }

        String after(String s) {
            return s == null || s.isEmpty() || Character.isTitleCase(s.charAt(0)) ? s : Character.toTitleCase(s.charAt(0)) + s.substring(1);
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.abbreviate(String, int)` with JDK provided API", description="Replace Apache Commons `StringUtils.abbreviate(String str, int maxWidth)` with JDK provided API.")
    public static class Abbreviate {
        String before(@Matches(value=RepeatableArgumentMatcher.class) String s, @Matches(value=RepeatableArgumentMatcher.class) int width) {
            return StringUtils.abbreviate((String)s, (int)width);
        }

        String after(String s, int width) {
            return s == null || s.length() <= width ? s : s.substring(0, width - 3) + "...";
        }
    }
}

