/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.options.Option;
import org.gradle.util.GradleVersion;
import org.jspecify.annotations.Nullable;
import org.openrewrite.gradle.DelegatingProjectParser;
import org.openrewrite.gradle.GradleProjectParser;
import org.openrewrite.gradle.RewriteExtension;

public abstract class AbstractRewriteTask
extends DefaultTask {
    protected @Nullable Provider<Set<File>> resolvedDependencies;
    protected boolean dumpGcActivity;
    protected @Nullable GradleProjectParser gpp;
    protected @Nullable RewriteExtension extension;

    protected AbstractRewriteTask() {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.4")) >= 0) {
            this.notCompatibleWithConfigurationCache("org.openrewrite.rewrite needs to parse the whole project");
        }
    }

    public <T extends AbstractRewriteTask> T setExtension(RewriteExtension extension) {
        this.extension = extension;
        return (T)((Object)this);
    }

    public <T extends AbstractRewriteTask> T setResolvedDependencies(Provider<Set<File>> resolvedDependencies) {
        this.resolvedDependencies = resolvedDependencies;
        return (T)((Object)this);
    }

    @Option(description="Dump GC activity related to parsing.", option="dumpGcActivity")
    public void setDumpGcActivity(boolean dumpGcActivity) {
        this.dumpGcActivity = dumpGcActivity;
    }

    @Input
    public boolean isDumpGcActivity() {
        return this.dumpGcActivity;
    }

    @Inject
    public ProjectLayout getProjectLayout() {
        throw new AssertionError((Object)"unexpected; getProjectLayout() should be overridden by Gradle");
    }

    @Internal
    protected <T extends GradleProjectParser> T getProjectParser() {
        if (this.gpp == null) {
            if (this.extension == null) {
                throw new IllegalArgumentException("Must configure extension");
            }
            if (this.resolvedDependencies == null) {
                throw new IllegalArgumentException("Must configure resolvedDependencies");
            }
            Set deps = (Set)this.resolvedDependencies.getOrNull();
            if (deps == null) {
                deps = Collections.emptySet();
            }
            Set<Path> classpath = deps.stream().map(File::toPath).collect(Collectors.toSet());
            this.gpp = new DelegatingProjectParser(this.getProject(), this.extension, classpath);
        }
        return (T)this.gpp;
    }

    @Input
    public List<String> getActiveRecipes() {
        return this.getProjectParser().getActiveRecipes();
    }

    @Input
    public List<String> getActiveStyles() {
        return this.getProjectParser().getActiveStyles();
    }
}

