/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.isolated;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.gradle.RewriteExtension;
import org.openrewrite.gradle.isolated.AndroidProjectCompileOptions;
import org.openrewrite.gradle.isolated.AndroidProjectVariant;
import org.openrewrite.gradle.isolated.DefaultProjectParser;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.kotlin.KotlinParser;
import org.openrewrite.marker.Marker;
import org.openrewrite.polyglot.OmniParser;
import org.openrewrite.polyglot.ProgressBar;
import org.openrewrite.polyglot.SourceFileStream;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.tree.ParsingExecutionContextView;

class AndroidProjectParser {
    private static final Logger logger = Logging.getLogger(DefaultProjectParser.class);
    private final Path baseDir;
    private final @Nullable Repository repository;
    private final RewriteExtension rewriteExtension;
    private final List<NamedStyles> styles;

    AndroidProjectParser(Path baseDir, @Nullable Repository repository, RewriteExtension rewriteExtension, List<NamedStyles> styles) {
        this.baseDir = baseDir;
        this.repository = repository;
        this.rewriteExtension = rewriteExtension;
        this.styles = styles;
    }

    SourceFileStream parseProjectSourceSets(Project project, ProgressBar progressBar, Path buildDir, Charset sourceCharset, Set<Path> alreadyParsed, Collection<PathMatcher> exclusions, ExecutionContext ctx, OmniParser omniParser) {
        SourceFileStream sourceFileStream = SourceFileStream.build((String)project.getPath(), projectName -> progressBar.intermediateResult(":" + projectName));
        for (AndroidProjectVariant variant : this.findAndroidProjectVariants(project)) {
            JavaVersion javaVersion = this.getJavaVersion(project);
            Charset javaSourceCharset = this.getSourceFileEncoding(project, sourceCharset);
            for (String sourceSetName : variant.getSourceSetNames()) {
                Stream<SourceFile> sourceSetSourceFiles = Stream.of(new SourceFile[0]);
                int sourceSetSize = 0;
                HashSet<Path> javaAndKotlinDirectories = new HashSet<Path>();
                javaAndKotlinDirectories.addAll(variant.getJavaDirectories(sourceSetName));
                javaAndKotlinDirectories.addAll(variant.getKotlinDirectories(sourceSetName));
                Set javaAndKotlinPaths = javaAndKotlinDirectories.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(dir -> !alreadyParsed.contains(dir)).flatMap(dir -> {
                    try {
                        return Files.walk(dir, new FileVisitOption[0]);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toAbsolutePath).map(Path::normalize).filter(path -> !alreadyParsed.contains(path)).collect(Collectors.toSet());
                List<Path> javaPaths = javaAndKotlinPaths.stream().filter(path -> path.toString().endsWith(".java")).collect(Collectors.toList());
                List<Path> kotlinPaths = javaAndKotlinPaths.stream().filter(path -> path.toString().endsWith(".kt")).collect(Collectors.toList());
                JavaTypeCache javaTypeCache = new JavaTypeCache();
                HashSet<Path> dependencyPaths = new HashSet<Path>();
                try {
                    Stream.concat(variant.getCompileClasspath().stream(), variant.getRuntimeClasspath().stream()).map(Path::toAbsolutePath).map(Path::normalize).forEach(dependencyPaths::add);
                }
                catch (Exception e) {
                    logger.warn("Unable to resolve classpath for variant {} sourceSet {}:{}", new Object[]{variant.getName(), project.getPath(), sourceSetName, e});
                }
                if (!javaPaths.isEmpty()) {
                    alreadyParsed.addAll(javaPaths);
                    Stream<SourceFile> parsedJavaFiles = this.parseJavaFiles(javaPaths, ctx, buildDir, exclusions, javaSourceCharset, javaVersion, dependencyPaths, javaTypeCache);
                    sourceSetSourceFiles = Stream.concat(sourceSetSourceFiles, parsedJavaFiles);
                    sourceSetSize += javaPaths.size();
                    logger.info("Scanned {} Java sources in {}/{}", new Object[]{javaPaths.size(), project.getPath(), sourceSetName});
                }
                if (!kotlinPaths.isEmpty()) {
                    alreadyParsed.addAll(kotlinPaths);
                    Stream<SourceFile> parsedKotlinFiles = this.parseKotlinFiles(kotlinPaths, ctx, buildDir, exclusions, javaSourceCharset, javaVersion, dependencyPaths, javaTypeCache);
                    sourceSetSourceFiles = Stream.concat(sourceSetSourceFiles, parsedKotlinFiles);
                    sourceSetSize += kotlinPaths.size();
                    logger.info("Scanned {} Kotlin sources in {}/{}", new Object[]{kotlinPaths.size(), project.getPath(), sourceSetName});
                }
                for (Path resourcesDir : variant.getResourcesDirectories(sourceSetName)) {
                    if (!Files.exists(resourcesDir, new LinkOption[0]) || alreadyParsed.contains(resourcesDir)) continue;
                    Set accepted = omniParser.acceptedPaths(this.baseDir, resourcesDir).stream().filter(path -> !alreadyParsed.contains(path)).collect(Collectors.toSet());
                    sourceSetSourceFiles = Stream.concat(sourceSetSourceFiles, omniParser.parse(accepted, this.baseDir, ctx).map(it -> (SourceFile)it.withMarkers(it.getMarkers().add((Marker)javaVersion))));
                    alreadyParsed.addAll(accepted);
                    sourceSetSize += accepted.size();
                }
                JavaSourceSet sourceSetProvenance = JavaSourceSet.build((String)sourceSetName, dependencyPaths);
                sourceFileStream = sourceFileStream.concat(sourceSetSourceFiles.map(DefaultProjectParser.addProvenance((Marker)sourceSetProvenance)), sourceSetSize);
            }
        }
        return sourceFileStream;
    }

    Collection<Path> findSourceDirectories(Project project) {
        HashSet<Path> sourceDirectories = new HashSet<Path>();
        for (AndroidProjectVariant variant : this.findAndroidProjectVariants(project)) {
            for (String sourceSetName : variant.getSourceSetNames()) {
                sourceDirectories.addAll(variant.getJavaDirectories(sourceSetName));
                sourceDirectories.addAll(variant.getKotlinDirectories(sourceSetName));
                sourceDirectories.addAll(variant.getResourcesDirectories(sourceSetName));
            }
        }
        return sourceDirectories;
    }

    private List<AndroidProjectVariant> findAndroidProjectVariants(Project project) {
        ArrayList<AndroidProjectVariant> variants = new ArrayList<AndroidProjectVariant>();
        Object extension = project.getExtensions().findByName("android");
        if (extension instanceof BaseAppModuleExtension) {
            BaseAppModuleExtension appExtension = (BaseAppModuleExtension)extension;
            this.addProjectVariant(variants, (DomainObjectSet<? extends BaseVariant>)appExtension.getApplicationVariants());
            this.addProjectVariant(variants, (DomainObjectSet<? extends BaseVariant>)appExtension.getTestVariants());
            this.addProjectVariant(variants, (DomainObjectSet<? extends BaseVariant>)appExtension.getUnitTestVariants());
        } else if (extension instanceof LibraryExtension) {
            LibraryExtension libraryExtension = (LibraryExtension)extension;
            this.addProjectVariant(variants, (DomainObjectSet<? extends BaseVariant>)libraryExtension.getLibraryVariants());
            this.addProjectVariant(variants, (DomainObjectSet<? extends BaseVariant>)libraryExtension.getTestVariants());
            this.addProjectVariant(variants, (DomainObjectSet<? extends BaseVariant>)libraryExtension.getUnitTestVariants());
        } else if (extension != null) {
            throw new UnsupportedOperationException("Unhandled android extension type: " + extension.getClass());
        }
        return variants;
    }

    private void addProjectVariant(List<AndroidProjectVariant> projectVariants, DomainObjectSet<? extends BaseVariant> variantSet) {
        variantSet.stream().map(AndroidProjectVariant::fromBaseVariant).forEach(projectVariants::add);
    }

    private JavaVersion getJavaVersion(Project project) {
        String sourceCompatibility = "";
        String targetCompatibility = "";
        Object extension = project.getExtensions().findByName("android");
        if (extension instanceof BaseExtension) {
            try {
                BaseExtension baseExtension = (BaseExtension)extension;
                AndroidProjectCompileOptions compileOptions = AndroidProjectCompileOptions.fromBaseExtension(baseExtension);
                sourceCompatibility = compileOptions.getSourceCompatibility();
                targetCompatibility = compileOptions.getTargetCompatibility();
            }
            catch (Exception e) {
                logger.warn("Unable to determine Java source or target compatibility versions", (Throwable)e);
            }
        }
        return new JavaVersion(Tree.randomId(), System.getProperty("java.runtime.version"), System.getProperty("java.vm.vendor"), sourceCompatibility, targetCompatibility);
    }

    Charset getSourceFileEncoding(Project project, Charset defaultCharset) {
        Object extension = project.getExtensions().findByName("android");
        if (extension instanceof BaseExtension) {
            try {
                BaseExtension baseExtension = (BaseExtension)extension;
                AndroidProjectCompileOptions compileOptions = AndroidProjectCompileOptions.fromBaseExtension(baseExtension);
                return compileOptions.getEncoding();
            }
            catch (Exception e) {
                logger.warn("Unable to determine Java source file encoding", (Throwable)e);
            }
        }
        return defaultCharset;
    }

    private Stream<SourceFile> parseJavaFiles(List<Path> javaPaths, ExecutionContext ctx, Path buildDir, Collection<PathMatcher> exclusions, Charset javaSourceCharset, JavaVersion javaVersion, Set<Path> dependencyPaths, JavaTypeCache javaTypeCache) {
        ParsingExecutionContextView.view((ExecutionContext)ctx).setCharset(javaSourceCharset);
        return Stream.of(() -> JavaParser.fromJavaVersion().classpath((Collection)dependencyPaths).styles(this.styles).typeCache(javaTypeCache).logCompilationWarningsAndErrors(this.rewriteExtension.getLogCompilationWarningsAndErrors()).build()).map(Supplier::get).flatMap(jp -> jp.parse((Iterable)javaPaths, this.baseDir, ctx)).map(cu -> {
            if (DefaultProjectParser.isExcluded(this.repository, exclusions, cu.getSourcePath()) || cu.getSourcePath().startsWith(buildDir)) {
                return null;
            }
            return cu;
        }).filter(Objects::nonNull).map(it -> (SourceFile)it.withMarkers(it.getMarkers().add((Marker)javaVersion)));
    }

    private Stream<SourceFile> parseKotlinFiles(List<Path> kotlinPaths, ExecutionContext ctx, Path buildDir, Collection<PathMatcher> exclusions, Charset javaSourceCharset, JavaVersion javaVersion, Set<Path> dependencyPaths, JavaTypeCache javaTypeCache) {
        ParsingExecutionContextView.view((ExecutionContext)ctx).setCharset(javaSourceCharset);
        return Stream.of(() -> KotlinParser.builder().classpath((Collection)dependencyPaths).styles(this.styles).typeCache(javaTypeCache).logCompilationWarningsAndErrors(this.rewriteExtension.getLogCompilationWarningsAndErrors()).build()).map(Supplier::get).flatMap(kp -> kp.parse((Iterable)kotlinPaths, this.baseDir, ctx)).map(cu -> {
            if (DefaultProjectParser.isExcluded(this.repository, exclusions, cu.getSourcePath()) || cu.getSourcePath().startsWith(buildDir)) {
                return null;
            }
            return cu;
        }).filter(Objects::nonNull).map(it -> (SourceFile)it.withMarkers(it.getMarkers().add((Marker)javaVersion)));
    }
}

