/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.isolated;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.GroovyPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.invocation.DefaultGradle;
import org.gradle.util.GradleVersion;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.LargeSourceSet;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Parser;
import org.openrewrite.PathUtils;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeRun;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.binary.Binary;
import org.openrewrite.config.Environment;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.GradleProjectParser;
import org.openrewrite.gradle.RewriteExtension;
import org.openrewrite.gradle.SanitizedMarkerPrinter;
import org.openrewrite.gradle.isolated.AndroidProjectParser;
import org.openrewrite.gradle.isolated.ResultsContainer;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.marker.GradleProjectBuilder;
import org.openrewrite.gradle.marker.GradleSettings;
import org.openrewrite.gradle.marker.GradleSettingsBuilder;
import org.openrewrite.groovy.GroovyParser;
import org.openrewrite.internal.InMemoryLargeSourceSet;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.style.Autodetect;
import org.openrewrite.java.style.CheckstyleConfigLoader;
import org.openrewrite.java.tree.J;
import org.openrewrite.jgit.api.Git;
import org.openrewrite.jgit.lib.FileMode;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.treewalk.AbstractTreeIterator;
import org.openrewrite.jgit.treewalk.FileTreeIterator;
import org.openrewrite.jgit.treewalk.TreeWalk;
import org.openrewrite.jgit.treewalk.WorkingTreeIterator;
import org.openrewrite.jgit.treewalk.filter.PathFilterGroup;
import org.openrewrite.kotlin.KotlinParser;
import org.openrewrite.kotlin.style.Autodetect;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.BuildTool;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.OperatingSystemProvenance;
import org.openrewrite.marker.ci.BuildEnvironment;
import org.openrewrite.polyglot.NoopProgressBar;
import org.openrewrite.polyglot.OmniParser;
import org.openrewrite.polyglot.ProgressBar;
import org.openrewrite.polyglot.RemoteProgressBarSender;
import org.openrewrite.polyglot.SourceFileStream;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.quark.Quark;
import org.openrewrite.quark.QuarkParser;
import org.openrewrite.remote.Remote;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.text.PlainTextParser;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;
import org.openrewrite.xml.style.Autodetect;
import org.openrewrite.xml.tree.Xml;

public class DefaultProjectParser
implements GradleProjectParser {
    private static final String LOG_INDENT_INCREMENT = "    ";
    private static final Logger logger = Logging.getLogger(DefaultProjectParser.class);
    private final AtomicBoolean firstWarningLogged = new AtomicBoolean(false);
    protected final Path baseDir;
    protected final RewriteExtension extension;
    protected final Project project;
    private final List<Marker> sharedProvenance;
    protected final @Nullable Repository repository;
    private @Nullable List<NamedStyles> styles;
    private @Nullable Environment environment;
    private @Nullable AndroidProjectParser androidProjectParser;
    private static final Map<Path, GitProvenance> REPO_ROOT_TO_PROVENANCE = new HashMap<Path, GitProvenance>();

    public DefaultProjectParser(Project project, RewriteExtension extension) {
        this.baseDir = DefaultProjectParser.repositoryRoot(project);
        this.repository = DefaultProjectParser.getRepository(this.baseDir);
        this.extension = extension;
        this.project = project;
        BuildEnvironment buildEnvironment = BuildEnvironment.build(System::getenv);
        this.sharedProvenance = Stream.of(buildEnvironment, this.gitProvenance(this.baseDir, buildEnvironment), OperatingSystemProvenance.current(), new BuildTool(Tree.randomId(), BuildTool.Type.Gradle, project.getGradle().getGradleVersion())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    static Path repositoryRoot(Project project) {
        Path buildRoot;
        Path maybeBaseDir;
        for (maybeBaseDir = buildRoot = project.getRootProject().getProjectDir().toPath(); maybeBaseDir != null && !Files.exists(maybeBaseDir.resolve(".git"), new LinkOption[0]); maybeBaseDir = maybeBaseDir.getParent()) {
        }
        if (maybeBaseDir == null) {
            return buildRoot;
        }
        return maybeBaseDir;
    }

    static @Nullable Repository getRepository(Path rootDir) {
        Repository repository;
        block8: {
            Git git = Git.open((File)rootDir.toFile());
            try {
                repository = git.getRepository();
                if (git == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (git != null) {
                        try {
                            git.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            git.close();
        }
        return repository;
    }

    private @Nullable GitProvenance gitProvenance(Path baseDir, @Nullable BuildEnvironment buildEnvironment) {
        try {
            return REPO_ROOT_TO_PROVENANCE.computeIfAbsent(baseDir, dir -> GitProvenance.fromProjectDirectory((Path)dir, (BuildEnvironment)buildEnvironment));
        }
        catch (Exception e) {
            logger.debug("Unable to determine git provenance", (Throwable)e);
            return null;
        }
    }

    private @Nullable String getPropertyWithVariantNames(String property) {
        String maybeProp = System.getProperty("rewrite." + property + "s");
        if (maybeProp == null) {
            maybeProp = System.getProperty("rewrite." + property);
        }
        if (maybeProp == null) {
            maybeProp = System.getProperty(property + "s");
        }
        if (maybeProp == null) {
            maybeProp = System.getProperty(property);
        }
        return maybeProp;
    }

    private static boolean isAndroidProject(Project project) {
        return project.hasProperty("android");
    }

    private AndroidProjectParser getAndroidProjectParser() {
        if (this.androidProjectParser == null) {
            this.androidProjectParser = new AndroidProjectParser(this.baseDir, this.repository, this.extension, this.getStyles());
        }
        return this.androidProjectParser;
    }

    @Override
    public List<String> getActiveRecipes() {
        String activeRecipe = this.getPropertyWithVariantNames("activeRecipe");
        if (activeRecipe == null) {
            return new ArrayList<String>(this.extension.getActiveRecipes());
        }
        return Arrays.asList(activeRecipe.split(","));
    }

    @Override
    public List<String> getActiveStyles() {
        String activeStyle = this.getPropertyWithVariantNames("activeStyle");
        if (activeStyle == null) {
            return new ArrayList<String>(this.extension.getActiveStyles());
        }
        return Arrays.asList(activeStyle.split(","));
    }

    @Override
    public List<String> getAvailableStyles() {
        return this.environment().listStyles().stream().map(NamedStyles::getName).collect(Collectors.toList());
    }

    @Override
    public void discoverRecipes(ServiceRegistry serviceRegistry) {
        Collection<RecipeDescriptor> availableRecipeDescriptors = this.listRecipeDescriptors();
        List<String> activeRecipes = this.getActiveRecipes();
        List<String> availableStyles = this.getAvailableStyles();
        List<String> activeStyles = this.getActiveStyles();
        logger.quiet("Available Recipes:");
        for (RecipeDescriptor recipe : availableRecipeDescriptors) {
            logger.quiet(DefaultProjectParser.indent(1, recipe.getName()));
        }
        logger.quiet(DefaultProjectParser.indent(0, ""));
        logger.quiet("Available Styles:");
        for (String style : availableStyles) {
            logger.quiet(DefaultProjectParser.indent(1, style));
        }
        logger.quiet(DefaultProjectParser.indent(0, ""));
        logger.quiet("Active Styles:");
        for (String style : activeStyles) {
            logger.quiet(DefaultProjectParser.indent(1, style));
        }
        logger.quiet(DefaultProjectParser.indent(0, ""));
        logger.quiet("Active Recipes:");
        for (String activeRecipe : activeRecipes) {
            logger.quiet(DefaultProjectParser.indent(1, activeRecipe));
        }
        logger.quiet(DefaultProjectParser.indent(0, ""));
        logger.quiet("Found " + availableRecipeDescriptors.size() + " available recipes and " + availableStyles.size() + " available styles.");
        logger.quiet("Configured with " + activeRecipes.size() + " active recipes and " + activeStyles.size() + " active styles.");
    }

    public Collection<RecipeDescriptor> listRecipeDescriptors() {
        return this.environment().listRecipeDescriptors();
    }

    private static String indent(int indent, CharSequence content) {
        StringBuilder prefix = DefaultProjectParser.repeat(indent);
        return prefix.append(content).toString();
    }

    private static StringBuilder repeat(int repeat) {
        StringBuilder buffer = new StringBuilder(repeat * LOG_INDENT_INCREMENT.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(LOG_INDENT_INCREMENT);
        }
        return buffer;
    }

    @Override
    public Collection<Path> listSources() {
        TreeSet<Path> result = new TreeSet<Path>(this.omniParser(Collections.emptySet(), this.project).acceptedPaths(this.baseDir, this.project.getProjectDir().toPath()));
        if (DefaultProjectParser.isAndroidProject(this.project)) {
            this.getAndroidProjectParser().findSourceDirectories(this.project).stream().map(Path::toAbsolutePath).map(Path::normalize).forEach(result::add);
        } else {
            for (SourceSet sourceSet : this.findGradleSourceSets(this.project)) {
                sourceSet.getAllSource().getFiles().stream().map(File::toPath).map(Path::toAbsolutePath).map(Path::normalize).forEach(result::add);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void dryRun(Path reportPath, boolean dumpGcActivity, Consumer<Throwable> onError) {
        ParsingExecutionContextView ctx = ParsingExecutionContextView.view((ExecutionContext)new InMemoryExecutionContext(onError));
        if (dumpGcActivity) {
            final SimpleMeterRegistry meterRegistry = new SimpleMeterRegistry();
            try (JvmHeapPressureMetrics heapMetrics = new JvmHeapPressureMetrics();){
                heapMetrics.bindTo((MeterRegistry)meterRegistry);
                new JvmMemoryMetrics().bindTo((MeterRegistry)meterRegistry);
                File rewriteBuildDir = ((Directory)this.project.getLayout().getBuildDirectory().dir("rewrite").get()).getAsFile();
                if (!rewriteBuildDir.exists() && !rewriteBuildDir.mkdirs()) return;
                File rewriteGcLog = new File(rewriteBuildDir, "rewrite-gc.csv");
                try (FileOutputStream fos = new FileOutputStream(rewriteGcLog, false);
                     final BufferedWriter logWriter = new BufferedWriter(new PrintWriter(fos));){
                    logWriter.write("file,jvm.gc.overhead,g1.old.gen.size\n");
                    ctx.setParsingListener(new ParsingEventListener(){

                        public void parsed(Parser.Input input, SourceFile sourceFile) {
                            try {
                                logWriter.write(input.getPath() + ",");
                                logWriter.write(meterRegistry.get("jvm.gc.overhead").gauge().value() + ",");
                                Gauge g1Used = meterRegistry.find("jvm.memory.used").tag("id", "G1 Old Gen").gauge();
                                logWriter.write((g1Used == null ? "" : Double.toString(g1Used.value())) + "\n");
                            }
                            catch (IOException e) {
                                logger.error("Unable to write rewrite GC log");
                                throw new UncheckedIOException(e);
                            }
                        }
                    });
                    this.dryRun(reportPath, this.listResults((ExecutionContext)ctx));
                    logWriter.flush();
                    logger.lifecycle("Wrote rewrite GC log: {}", new Object[]{rewriteGcLog.getAbsolutePath()});
                    return;
                }
                catch (IOException e) {
                    logger.error("Unable to write rewrite GC log", (Throwable)e);
                    throw new UncheckedIOException(e);
                }
            }
        } else {
            this.dryRun(reportPath, this.listResults((ExecutionContext)ctx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dryRun(Path reportPath, ResultsContainer results) {
        block24: {
            try {
                RuntimeException firstException = results.getFirstException();
                if (firstException != null) {
                    logger.error("The recipe produced an error. Please report this to the recipe author.");
                    throw firstException;
                }
                if (results.isNotEmpty()) {
                    Duration estimateTimeSaved = Duration.ZERO;
                    for (Result result : results.generated) {
                        assert (result.getAfter() != null);
                        logger.warn("These recipes would generate new file {}:", (Object)result.getAfter().getSourcePath());
                        this.logRecipesThatMadeChanges(result);
                        estimateTimeSaved = DefaultProjectParser.estimateTimeSavedSum(result, estimateTimeSaved);
                    }
                    for (Result result : results.deleted) {
                        assert (result.getBefore() != null);
                        logger.warn("These recipes would delete file {}:", (Object)result.getBefore().getSourcePath());
                        this.logRecipesThatMadeChanges(result);
                        estimateTimeSaved = DefaultProjectParser.estimateTimeSavedSum(result, estimateTimeSaved);
                    }
                    for (Result result : results.moved) {
                        assert (result.getBefore() != null);
                        assert (result.getAfter() != null);
                        logger.warn("These recipes would move file from {} to {}:", (Object)result.getBefore().getSourcePath(), (Object)result.getAfter().getSourcePath());
                        this.logRecipesThatMadeChanges(result);
                        estimateTimeSaved = DefaultProjectParser.estimateTimeSavedSum(result, estimateTimeSaved);
                    }
                    for (Result result : results.refactoredInPlace) {
                        assert (result.getBefore() != null);
                        logger.warn("These recipes would make changes to {}:", (Object)result.getBefore().getSourcePath());
                        this.logRecipesThatMadeChanges(result);
                        estimateTimeSaved = DefaultProjectParser.estimateTimeSavedSum(result, estimateTimeSaved);
                    }
                    reportPath.getParent().toFile().mkdirs();
                    try (BufferedWriter writer = Files.newBufferedWriter(reportPath, new OpenOption[0]);){
                        Stream.concat(Stream.concat(results.generated.stream(), results.deleted.stream()), Stream.concat(results.moved.stream(), results.refactoredInPlace.stream())).filter(it -> !(it.getAfter() instanceof Binary) && !(it.getAfter() instanceof Quark)).map(Result::diff).forEach(diff -> {
                            try {
                                writer.write(diff + "\n");
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to generate rewrite result file.", e);
                    }
                    logger.warn("Report available:");
                    logger.warn("    {}", (Object)reportPath.normalize());
                    logger.warn("Estimate time saved: {}", (Object)DefaultProjectParser.formatDuration(estimateTimeSaved));
                    logger.warn("Run 'gradle rewriteRun' to apply the recipes.");
                    if (((RewriteExtension)this.project.getExtensions().getByType(RewriteExtension.class)).getFailOnDryRunResults()) {
                        throw new RuntimeException("Applying recipes would make changes. See logs for more details.");
                    }
                    break block24;
                }
                logger.lifecycle("Applying recipes would make no changes. No report generated.");
            }
            finally {
                this.shutdownRewrite();
            }
        }
    }

    private static String formatDuration(Duration duration) {
        return duration.toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase().trim();
    }

    @Override
    public void run(Consumer<Throwable> onError) {
        InMemoryExecutionContext ctx = new InMemoryExecutionContext(onError);
        this.run(this.listResults((ExecutionContext)ctx), (ExecutionContext)ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ResultsContainer results, ExecutionContext ctx) {
        block29: {
            try {
                if (!results.isNotEmpty()) break block29;
                Duration estimateTimeSaved = Duration.ZERO;
                RuntimeException firstException = results.getFirstException();
                if (firstException != null) {
                    logger.error("The recipe produced an error. Please report this to the recipe author.");
                    throw firstException;
                }
                for (Result result : results.generated) {
                    assert (result.getAfter() != null);
                    logger.lifecycle("Generated new file " + result.getAfter().getSourcePath() + " by:");
                    this.logRecipesThatMadeChanges(result);
                    estimateTimeSaved = DefaultProjectParser.estimateTimeSavedSum(result, estimateTimeSaved);
                }
                for (Result result : results.deleted) {
                    assert (result.getBefore() != null);
                    logger.lifecycle("Deleted file " + result.getBefore().getSourcePath() + " by:");
                    this.logRecipesThatMadeChanges(result);
                    estimateTimeSaved = DefaultProjectParser.estimateTimeSavedSum(result, estimateTimeSaved);
                }
                for (Result result : results.moved) {
                    assert (result.getAfter() != null);
                    assert (result.getBefore() != null);
                    logger.lifecycle("File has been moved from " + result.getBefore().getSourcePath() + " to " + result.getAfter().getSourcePath() + " by:");
                    this.logRecipesThatMadeChanges(result);
                    estimateTimeSaved = DefaultProjectParser.estimateTimeSavedSum(result, estimateTimeSaved);
                }
                for (Result result : results.refactoredInPlace) {
                    assert (result.getBefore() != null);
                    logger.lifecycle("Changes have been made to " + result.getBefore().getSourcePath() + " by:");
                    this.logRecipesThatMadeChanges(result);
                    estimateTimeSaved = DefaultProjectParser.estimateTimeSavedSum(result, estimateTimeSaved);
                }
                logger.lifecycle("Please review and commit the results.");
                logger.lifecycle("Estimate time saved: {}", new Object[]{DefaultProjectParser.formatDuration(estimateTimeSaved)});
                try {
                    Path originalLocation;
                    for (Result result : results.generated) {
                        DefaultProjectParser.writeAfter(results.getProjectRoot(), result, ctx);
                    }
                    for (Result result : results.deleted) {
                        assert (result.getBefore() != null);
                        originalLocation = results.getProjectRoot().resolve(result.getBefore().getSourcePath());
                        boolean deleteSucceeded = originalLocation.toFile().delete();
                        if (deleteSucceeded) continue;
                        throw new IOException("Unable to delete file " + originalLocation.toAbsolutePath());
                    }
                    for (Result result : results.moved) {
                        assert (result.getBefore() != null);
                        originalLocation = results.getProjectRoot().resolve(result.getBefore().getSourcePath());
                        File originalParentDir = originalLocation.toFile().getParentFile();
                        assert (result.getAfter() != null);
                        Path afterLocation = results.getProjectRoot().resolve(result.getAfter().getSourcePath());
                        File afterParentDir = afterLocation.toFile().getParentFile();
                        if (afterParentDir.exists() && afterParentDir.getAbsolutePath().equalsIgnoreCase(originalParentDir.getAbsolutePath()) && !afterParentDir.getAbsolutePath().equals(originalParentDir.getAbsolutePath())) {
                            if (!originalParentDir.renameTo(afterParentDir)) {
                                throw new RuntimeException("Unable to rename directory from " + originalParentDir.getAbsolutePath() + " To: " + afterParentDir.getAbsolutePath());
                            }
                        } else if (!afterParentDir.exists() && !afterParentDir.mkdirs()) {
                            throw new RuntimeException("Unable to create directory " + afterParentDir.getAbsolutePath());
                        }
                        if (result.getAfter() instanceof Quark) {
                            Files.move(originalLocation, results.getProjectRoot().resolve(result.getAfter().getSourcePath()), new CopyOption[0]);
                            continue;
                        }
                        originalLocation.toFile().delete();
                        DefaultProjectParser.writeAfter(results.getProjectRoot(), result, ctx);
                    }
                    for (Result result : results.refactoredInPlace) {
                        DefaultProjectParser.writeAfter(results.getProjectRoot(), result, ctx);
                    }
                    List<Path> emptyDirectories = results.newlyEmptyDirectories();
                    if (!emptyDirectories.isEmpty()) {
                        logger.quiet("Removing {} newly empty directories:", new Object[]{emptyDirectories.size()});
                        for (Path emptyDirectory : emptyDirectories) {
                            logger.quiet("  {}", new Object[]{emptyDirectory});
                            Files.delete(emptyDirectory);
                        }
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to rewrite source files", e);
                }
            }
            finally {
                this.shutdownRewrite();
            }
        }
    }

    private static Duration estimateTimeSavedSum(Result result, Duration timeSaving) {
        if (null != result.getTimeSavings()) {
            return timeSaving.plus(result.getTimeSavings());
        }
        return timeSaving;
    }

    private static void writeAfter(Path root, Result result, ExecutionContext ctx) {
        File targetFile;
        block32: {
            assert (result.getAfter() != null);
            Path targetPath = root.resolve(result.getAfter().getSourcePath());
            targetFile = targetPath.toFile();
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            if (result.getAfter() instanceof Binary) {
                try (FileOutputStream sourceFileWriter = new FileOutputStream(targetFile);){
                    sourceFileWriter.write(((Binary)result.getAfter()).getBytes());
                    break block32;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to rewrite source files", e);
                }
            }
            if (result.getAfter() instanceof Remote) {
                Remote remote = (Remote)result.getAfter();
                try (FileOutputStream sourceFileWriter = new FileOutputStream(targetFile);){
                    int length;
                    InputStream source = remote.getInputStream(ctx);
                    byte[] buf = new byte[4096];
                    while ((length = source.read(buf)) > 0) {
                        sourceFileWriter.write(buf, 0, length);
                    }
                    break block32;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to rewrite source files", e);
                }
            }
            if (!(result.getAfter() instanceof Quark)) {
                Charset charset = result.getAfter().getCharset() == null ? StandardCharsets.UTF_8 : result.getAfter().getCharset();
                try (BufferedWriter sourceFileWriter = Files.newBufferedWriter(targetPath, charset, new OpenOption[0]);){
                    sourceFileWriter.write(result.getAfter().printAll(new PrintOutputCapture((Object)0, (PrintOutputCapture.MarkerPrinter)new SanitizedMarkerPrinter())));
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to rewrite source files", e);
                }
            }
        }
        if (result.getAfter().getFileAttributes() != null) {
            FileAttributes fileAttributes = result.getAfter().getFileAttributes();
            if (targetFile.canRead() != fileAttributes.isReadable()) {
                targetFile.setReadable(fileAttributes.isReadable());
            }
            if (targetFile.canWrite() != fileAttributes.isWritable()) {
                targetFile.setWritable(fileAttributes.isWritable());
            }
            if (targetFile.canExecute() != fileAttributes.isExecutable()) {
                targetFile.setExecutable(fileAttributes.isExecutable());
            }
        }
    }

    protected Environment environment() {
        if (this.environment == null) {
            Environment.Builder env;
            block10: {
                Map<Object, Object> gradleProps = this.project.getProperties().entrySet().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                Properties properties = new Properties();
                properties.putAll(gradleProps);
                env = Environment.builder();
                env.scanClassLoader(this.getClass().getClassLoader());
                File rewriteConfig = this.extension.getConfigFile();
                if (rewriteConfig.exists()) {
                    try (FileInputStream is = new FileInputStream(rewriteConfig);){
                        YamlResourceLoader resourceLoader = new YamlResourceLoader((InputStream)is, rewriteConfig.toURI(), properties, this.getClass().getClassLoader());
                        env.load((ResourceLoader)resourceLoader);
                        break block10;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to load rewrite configuration", e);
                    }
                }
                if (this.extension.getConfigFileSetDeliberately()) {
                    logger.warn("Rewrite configuration file {} does not exist.", (Object)rewriteConfig);
                }
            }
            this.environment = env.build();
        }
        return this.environment;
    }

    public Stream<SourceFile> parse(ExecutionContext ctx) {
        Stream<SourceFile> builder = Stream.of(new SourceFile[0]);
        HashSet<Path> alreadyParsed = new HashSet<Path>();
        if (this.project == this.project.getRootProject()) {
            for (Project subProject : this.project.getSubprojects()) {
                builder = Stream.concat(builder, this.parse(subProject, alreadyParsed, ctx));
            }
        }
        return Stream.concat(builder, this.parse(this.project, alreadyParsed, ctx)).map(this::logParseErrors);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Stream<SourceFile> parse(Project subproject, Set<Path> alreadyParsed, ExecutionContext ctx) {
        String cliPort = System.getenv("MODERNE_CLI_PORT");
        try (NoopProgressBar progressBar = StringUtils.isBlank((String)cliPort) ? new NoopProgressBar() : new RemoteProgressBarSender(Integer.parseInt(cliPort));){
            List<Marker> projectProvenance;
            SourceFileStream sourceFileStream = SourceFileStream.build((String)subproject.getPath(), arg_0 -> DefaultProjectParser.lambda$parse$4((ProgressBar)progressBar, arg_0));
            Collection exclusions = this.extension.getExclusions().stream().map(pattern -> subproject.getProjectDir().toPath().getFileSystem().getPathMatcher("glob:" + pattern)).collect(Collectors.toList());
            if (DefaultProjectParser.isExcluded(this.repository, exclusions, this.baseDir.relativize(subproject.getProjectDir().toPath()))) {
                logger.lifecycle("Skipping project {} because it is excluded", new Object[]{subproject.getPath()});
                Stream<SourceFile> stream2 = Stream.empty();
                return stream2;
            }
            logger.lifecycle("Scanning sources in project {}", new Object[]{subproject.getPath()});
            List<NamedStyles> styles = this.getStyles();
            logger.lifecycle("Using active styles {}", new Object[]{styles.stream().map(NamedStyles::getName).collect(Collectors.toList())});
            if (subproject.getPlugins().hasPlugin("org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension") || subproject.getExtensions().findByName("kotlin") != null && subproject.getExtensions().getByName("kotlin").getClass().getCanonicalName().startsWith("org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension")) {
                sourceFileStream = sourceFileStream.concat(this.parseMultiplatformKotlinProject(subproject, exclusions, alreadyParsed, ctx));
            }
            Charset sourceCharset = Charset.forName(System.getProperty("file.encoding", "UTF-8"));
            Path buildDirPath = this.baseDir.relativize(((Directory)subproject.getLayout().getBuildDirectory().get()).getAsFile().toPath());
            SourceFileStream projectSourceFileStream = DefaultProjectParser.isAndroidProject(subproject) ? this.parseAndroidProjectSourceSets(subproject, (ProgressBar)progressBar, buildDirPath, sourceCharset, alreadyParsed, exclusions, ctx) : this.parseGradleProjectSourceSets(subproject, (ProgressBar)progressBar, buildDirPath, sourceCharset, alreadyParsed, exclusions, ctx);
            sourceFileStream = sourceFileStream.concat((Stream)projectSourceFileStream, projectSourceFileStream.size());
            if (projectSourceFileStream.size() == 0) {
                projectProvenance = this.sharedProvenance;
            } else {
                projectProvenance = new ArrayList<Marker>(this.sharedProvenance);
                projectProvenance.add((Marker)new JavaProject(Tree.randomId(), subproject.getName(), new JavaProject.Publication(subproject.getGroup().toString(), subproject.getName(), subproject.getVersion().toString())));
            }
            SourceFileStream gradleFiles = this.parseGradleFiles(subproject, exclusions, alreadyParsed, ctx);
            sourceFileStream = sourceFileStream.concat((Stream)gradleFiles, gradleFiles.size());
            SourceFileStream gradleWrapperFiles = this.parseGradleWrapperFiles(exclusions, alreadyParsed, ctx);
            sourceFileStream = sourceFileStream.concat((Stream)gradleWrapperFiles, gradleWrapperFiles.size());
            SourceFileStream nonProjectResources = this.parseNonProjectResources(subproject, alreadyParsed, ctx);
            sourceFileStream = sourceFileStream.concat((Stream)nonProjectResources, nonProjectResources.size());
            Stream stream = sourceFileStream.map(this.addProvenance(projectProvenance));
            return stream;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private SourceFileStream parseGradleProjectSourceSets(Project subproject, ProgressBar progressBar, Path buildDir, Charset sourceCharset, Set<Path> alreadyParsed, Collection<PathMatcher> exclusions, ExecutionContext ctx) {
        SourceFileStream sourceFileStream = SourceFileStream.build((String)subproject.getPath(), projectName -> progressBar.intermediateResult(":" + projectName));
        for (SourceSet sourceSet : this.findGradleSourceSets(subproject)) {
            Object groovyPaths;
            Stream<SourceFile> sourceSetSourceFiles = Stream.of(new SourceFile[0]);
            int sourceSetSize = 0;
            JavaTypeCache javaTypeCache = new JavaTypeCache();
            JavaCompile javaCompileTask = (JavaCompile)subproject.getTasks().getByName(sourceSet.getCompileJavaTaskName());
            JavaVersion javaVersion = this.getJavaVersion(javaCompileTask);
            Charset javaSourceCharset = this.getSourceFileEncoding(javaCompileTask, sourceCharset);
            List unparsedSources = sourceSet.getAllSource().getSourceDirectories().filter(File::exists).filter(dir -> !alreadyParsed.contains(dir.toPath())).getFiles().stream().map(File::toPath).flatMap(dirPath -> {
                try {
                    return Files.walk(dirPath, new FileVisitOption[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toAbsolutePath).map(Path::normalize).distinct().collect(Collectors.toList());
            List<Path> javaPaths = unparsedSources.stream().filter(path -> !alreadyParsed.contains(path)).filter(path -> path.toString().endsWith(".java")).collect(Collectors.toList());
            HashSet<Path> dependencyPaths = new HashSet<Path>();
            try {
                Stream.concat(sourceSet.getRuntimeClasspath().getFiles().stream(), sourceSet.getCompileClasspath().getFiles().stream()).map(File::toPath).map(Path::toAbsolutePath).map(Path::normalize).forEach(dependencyPaths::add);
            }
            catch (Exception e) {
                logger.warn("Unable to resolve classpath for sourceSet {}:{}", new Object[]{subproject.getPath(), sourceSet.getName(), e});
            }
            if (!javaPaths.isEmpty()) {
                alreadyParsed.addAll(javaPaths);
                Stream<SourceFile> parsedJavaFiles = this.parseJavaFiles(javaPaths, ctx, buildDir, exclusions, javaSourceCharset, javaVersion, dependencyPaths, javaTypeCache);
                sourceSetSourceFiles = Stream.concat(sourceSetSourceFiles, parsedJavaFiles);
                sourceSetSize += javaPaths.size();
                logger.info("Scanned {} Java sources in {}/{}", new Object[]{javaPaths.size(), subproject.getPath(), sourceSet.getName()});
            }
            if (subproject.getPlugins().hasPlugin("org.jetbrains.kotlin.jvm")) {
                String excludedProtosPath = subproject.getProjectDir().getPath() + "/protos/build/generated";
                List<Path> kotlinPaths = unparsedSources.stream().filter(it -> it.toString().endsWith(".kt")).filter(it -> !it.toString().startsWith(excludedProtosPath)).collect(Collectors.toList());
                if (!kotlinPaths.isEmpty()) {
                    alreadyParsed.addAll(kotlinPaths);
                    Stream<SourceFile> parsedKotlinFiles = this.parseKotlinFiles(kotlinPaths, ctx, buildDir, exclusions, javaSourceCharset, javaVersion, dependencyPaths, javaTypeCache);
                    sourceSetSourceFiles = Stream.concat(sourceSetSourceFiles, parsedKotlinFiles);
                    sourceSetSize += kotlinPaths.size();
                    logger.info("Scanned {} Kotlin sources in {}/{}", new Object[]{kotlinPaths.size(), subproject.getPath(), sourceSet.getName()});
                }
            }
            if (subproject.getPlugins().hasPlugin(GroovyPlugin.class) && !(groovyPaths = unparsedSources.stream().filter(it -> it.toString().endsWith(".groovy")).collect(Collectors.toList())).isEmpty()) {
                List dependenciesWithBuildDirs = Stream.concat(dependencyPaths.stream(), sourceSet.getOutput().getClassesDirs().getFiles().stream().map(File::toPath)).collect(Collectors.toList());
                alreadyParsed.addAll((Collection<Path>)groovyPaths);
                Stream<SourceFile> cus = Stream.of(() -> GroovyParser.builder().classpath((Collection)dependenciesWithBuildDirs).typeCache(javaTypeCache).logCompilationWarningsAndErrors(false).build()).map(Supplier::get).flatMap(arg_0 -> this.lambda$parseGradleProjectSourceSets$16((List)groovyPaths, ctx, arg_0)).map(cu -> {
                    if (DefaultProjectParser.isExcluded(this.repository, exclusions, cu.getSourcePath()) || cu.getSourcePath().startsWith(buildDir)) {
                        return null;
                    }
                    return cu;
                }).filter(Objects::nonNull).map(it -> (SourceFile)it.withMarkers(it.getMarkers().add((Marker)javaVersion)));
                sourceSetSourceFiles = Stream.concat(sourceSetSourceFiles, cus);
                sourceSetSize += groovyPaths.size();
                logger.info("Scanned {} Groovy sources in {}/{}", new Object[]{groovyPaths.size(), subproject.getPath(), sourceSet.getName()});
            }
            groovyPaths = sourceSet.getResources().getSourceDirectories().iterator();
            while (groovyPaths.hasNext()) {
                File resourcesDir = (File)groovyPaths.next();
                if (!resourcesDir.exists() || alreadyParsed.contains(resourcesDir.toPath())) continue;
                OmniParser omniParser = this.omniParser(alreadyParsed, subproject);
                List accepted = omniParser.acceptedPaths(this.baseDir, resourcesDir.toPath());
                sourceSetSourceFiles = Stream.concat(sourceSetSourceFiles, omniParser.parse((Iterable)accepted, this.baseDir, ctx).map(it -> (SourceFile)it.withMarkers(it.getMarkers().add((Marker)javaVersion))));
                alreadyParsed.addAll(accepted);
                sourceSetSize += accepted.size();
            }
            JavaSourceSet sourceSetProvenance = JavaSourceSet.build((String)sourceSet.getName(), dependencyPaths);
            sourceFileStream = sourceFileStream.concat(sourceSetSourceFiles.map(DefaultProjectParser.addProvenance((Marker)sourceSetProvenance)), sourceSetSize);
            for (File file : sourceSet.getAllSource().getSourceDirectories().getFiles()) {
                alreadyParsed.add(file.toPath());
            }
        }
        return sourceFileStream;
    }

    private SourceFileStream parseAndroidProjectSourceSets(Project subproject, ProgressBar progressBar, Path buildDir, Charset sourceCharset, Set<Path> alreadyParsed, Collection<PathMatcher> exclusions, ExecutionContext ctx) {
        return this.getAndroidProjectParser().parseProjectSourceSets(subproject, progressBar, buildDir, sourceCharset, alreadyParsed, exclusions, ctx, this.omniParser(alreadyParsed, subproject));
    }

    private Stream<SourceFile> parseJavaFiles(List<Path> javaPaths, ExecutionContext ctx, Path buildDir, Collection<PathMatcher> exclusions, Charset javaSourceCharset, JavaVersion javaVersion, Set<Path> dependencyPaths, JavaTypeCache javaTypeCache) {
        ParsingExecutionContextView.view((ExecutionContext)ctx).setCharset(javaSourceCharset);
        return Stream.of(() -> JavaParser.fromJavaVersion().classpath((Collection)dependencyPaths).typeCache(javaTypeCache).logCompilationWarningsAndErrors(this.extension.getLogCompilationWarningsAndErrors()).build()).map(Supplier::get).flatMap(jp -> jp.parse((Iterable)javaPaths, this.baseDir, ctx)).map(cu -> {
            if (DefaultProjectParser.isExcluded(this.repository, exclusions, cu.getSourcePath()) || cu.getSourcePath().startsWith(buildDir)) {
                return null;
            }
            return cu;
        }).filter(Objects::nonNull).map(it -> (SourceFile)it.withMarkers(it.getMarkers().add((Marker)javaVersion)));
    }

    private Stream<SourceFile> parseKotlinFiles(List<Path> kotlinPaths, ExecutionContext ctx, Path buildDir, Collection<PathMatcher> exclusions, Charset javaSourceCharset, JavaVersion javaVersion, Set<Path> dependencyPaths, JavaTypeCache javaTypeCache) {
        ParsingExecutionContextView.view((ExecutionContext)ctx).setCharset(javaSourceCharset);
        return Stream.of(() -> KotlinParser.builder().classpath((Collection)dependencyPaths).typeCache(javaTypeCache).logCompilationWarningsAndErrors(this.extension.getLogCompilationWarningsAndErrors()).build()).map(Supplier::get).flatMap(kp -> kp.parse((Iterable)kotlinPaths, this.baseDir, ctx)).map(cu -> {
            if (DefaultProjectParser.isExcluded(this.repository, exclusions, cu.getSourcePath()) || cu.getSourcePath().startsWith(buildDir)) {
                return null;
            }
            return cu;
        }).filter(Objects::nonNull).map(it -> (SourceFile)it.withMarkers(it.getMarkers().add((Marker)javaVersion)));
    }

    private GradleParser gradleParser() {
        List settingsClasspath;
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.4")) >= 0) {
            try {
                SettingsInternal settings = ((DefaultGradle)this.project.getGradle()).getSettings();
                settingsClasspath = settings.getBuildscript().getConfigurations().getByName("classpath").resolve().stream().map(File::toPath).collect(Collectors.toList());
            }
            catch (IllegalStateException e) {
                settingsClasspath = Collections.emptyList();
            }
        } else {
            settingsClasspath = Collections.emptyList();
        }
        List buildscriptClasspath = this.project.getBuildscript().getConfigurations().getByName("classpath").resolve().stream().map(File::toPath).collect(Collectors.toList());
        JavaTypeCache typeCache = new JavaTypeCache();
        return GradleParser.builder().groovyParser(GroovyParser.builder().typeCache(typeCache).logCompilationWarningsAndErrors(false)).kotlinParser(KotlinParser.builder().typeCache(typeCache).logCompilationWarningsAndErrors(false)).buildscriptClasspath(buildscriptClasspath).settingsClasspath(settingsClasspath).build();
    }

    private SourceFileStream parseGradleFiles(final Project subproject, final Collection<PathMatcher> exclusions, final Set<Path> alreadyParsed, ExecutionContext ctx) {
        File buildscriptLockfile;
        File gradlePropertiesFile;
        File settingsGradleFile;
        Path buildScriptPath;
        Stream<SourceFile> sourceFiles = Stream.empty();
        int gradleFileCount = 0;
        GradleParser gradleParser = null;
        GradleProject gradleProject = GradleProjectBuilder.gradleProject((Project)subproject);
        File buildGradleFile = subproject.getBuildscript().getSourceFile();
        if (buildGradleFile != null && !DefaultProjectParser.isExcluded(this.repository, exclusions, buildScriptPath = this.baseDir.relativize(buildGradleFile.toPath())) && buildGradleFile.exists()) {
            gradleParser = this.gradleParser();
            sourceFiles = gradleParser.parse(Collections.singleton(buildGradleFile.toPath()), this.baseDir, ctx);
            ++gradleFileCount;
            sourceFiles = sourceFiles.map(sourceFile -> (SourceFile)sourceFile.withMarkers(sourceFile.getMarkers().add((Marker)gradleProject)));
            alreadyParsed.add(buildGradleFile.toPath());
        }
        if (subproject == this.project.getRootProject() && (settingsGradleFile = this.determineGradleSettingsFile(subproject)) != null) {
            Path settingsPath = this.baseDir.relativize(settingsGradleFile.toPath());
            if (!DefaultProjectParser.isExcluded(this.repository, exclusions, settingsPath)) {
                GradleSettings gs = null;
                if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.4")) >= 0) {
                    gs = GradleSettingsBuilder.gradleSettings((Settings)((DefaultGradle)this.project.getGradle()).getSettings());
                }
                GradleSettings finalGs = gs;
                if (gradleParser == null) {
                    gradleParser = this.gradleParser();
                }
                sourceFiles = Stream.concat(sourceFiles, gradleParser.parse(Collections.singleton(settingsGradleFile.toPath()), this.baseDir, ctx).map(sourceFile -> {
                    if (finalGs == null) {
                        return sourceFile;
                    }
                    return (SourceFile)sourceFile.withMarkers(sourceFile.getMarkers().add((Marker)finalGs));
                }));
                ++gradleFileCount;
            }
            alreadyParsed.add(settingsGradleFile.toPath());
        }
        if ((gradlePropertiesFile = subproject.file((Object)"gradle.properties")).exists()) {
            Path gradlePropertiesPath = this.baseDir.relativize(gradlePropertiesFile.toPath());
            if (!DefaultProjectParser.isExcluded(this.repository, exclusions, gradlePropertiesPath)) {
                GradleProject finalGradleProject = gradleProject;
                sourceFiles = Stream.concat(sourceFiles, new PropertiesParser().parse(Collections.singleton(gradlePropertiesFile.toPath()), this.baseDir, ctx).map(sourceFile -> (SourceFile)sourceFile.withMarkers(sourceFile.getMarkers().add((Marker)finalGradleProject))));
                ++gradleFileCount;
            }
            alreadyParsed.add(gradlePropertiesFile.toPath());
        }
        try {
            final ArrayList freeStandingScripts = new ArrayList();
            Files.walkFileTree(subproject.getProjectDir().toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    Path dirFromRoot = DefaultProjectParser.this.baseDir.relativize(dir);
                    String name = dirFromRoot.toString();
                    if (((File)subproject.getLayout().getBuildDirectory().getAsFile().get()).toPath().equals(dir) || name.startsWith(".") || "out".equals(name) || subproject.getSubprojects().stream().anyMatch(sp -> dir.equals(sp.getProjectDir().toPath())) || subproject.getGradle().getIncludedBuilds().stream().anyMatch(ib -> dir.equals(ib.getProjectDir().toPath())) || DefaultProjectParser.isExcluded(DefaultProjectParser.this.repository, exclusions, DefaultProjectParser.this.baseDir.relativize(dir))) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if ((file.toString().endsWith(".gradle") || file.toString().endsWith(".gradle.kts")) && !alreadyParsed.contains(file) && !DefaultProjectParser.isExcluded(DefaultProjectParser.this.repository, exclusions, DefaultProjectParser.this.baseDir.relativize(file))) {
                        freeStandingScripts.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            if (!freeStandingScripts.isEmpty()) {
                if (gradleParser == null) {
                    gradleParser = this.gradleParser();
                }
                sourceFiles = Stream.concat(sourceFiles, gradleParser.parse(freeStandingScripts, this.baseDir, ctx).map(sourceFile -> (SourceFile)sourceFile.withMarkers(sourceFile.getMarkers().add((Marker)gradleProject))));
                alreadyParsed.addAll(freeStandingScripts);
                gradleFileCount += freeStandingScripts.size();
            }
        }
        catch (IOException e) {
            logger.warn("Unable to walk file tree for project {}", (Object)subproject.getPath(), (Object)e);
        }
        File lockfile = subproject.file((Object)"gradle.lockfile");
        if (lockfile.exists()) {
            sourceFiles = Stream.concat(sourceFiles, PlainTextParser.builder().build().parse(Collections.singletonList(lockfile.toPath()), this.baseDir, ctx).map(sourceFile -> (SourceFile)sourceFile.withMarkers(sourceFile.getMarkers().add((Marker)gradleProject))));
        }
        if ((buildscriptLockfile = subproject.file((Object)"buildscript-gradle.lockfile")).exists()) {
            sourceFiles = Stream.concat(sourceFiles, PlainTextParser.builder().build().parse(Collections.singletonList(buildscriptLockfile.toPath()), this.baseDir, ctx).map(sourceFile -> (SourceFile)sourceFile.withMarkers(sourceFile.getMarkers().add((Marker)gradleProject))));
        }
        return SourceFileStream.build((String)"", s -> {}).concat(sourceFiles, gradleFileCount);
    }

    private @Nullable File determineGradleSettingsFile(Project rootProject) {
        File settingsFile = rootProject.file((Object)"settings.gradle.kts");
        if (settingsFile.exists()) {
            return settingsFile;
        }
        settingsFile = rootProject.file((Object)"settings.gradle");
        if (settingsFile.exists()) {
            return settingsFile;
        }
        return null;
    }

    private SourceFileStream parseGradleWrapperFiles(Collection<PathMatcher> exclusions, Set<Path> alreadyParsed, ExecutionContext ctx) {
        Stream sourceFiles = Stream.empty();
        int fileCount = 0;
        if (this.project == this.project.getRootProject()) {
            OmniParser omniParser = this.omniParser(alreadyParsed, this.project);
            List gradleWrapperFiles = Stream.of("gradlew", "gradlew.bat", "gradle/wrapper/gradle-wrapper.jar", "gradle/wrapper/gradle-wrapper.properties").map(arg_0 -> ((Project)this.project).file(arg_0)).filter(File::exists).map(File::toPath).filter(it -> !DefaultProjectParser.isExcluded(this.repository, exclusions, it)).filter(arg_0 -> ((OmniParser)omniParser).accept(arg_0)).collect(Collectors.toList());
            sourceFiles = omniParser.parse(gradleWrapperFiles, this.baseDir, ctx);
            fileCount = gradleWrapperFiles.size();
        }
        return SourceFileStream.build((String)"wrapper", s -> {}).concat(sourceFiles, fileCount);
    }

    protected SourceFileStream parseNonProjectResources(Project subproject, Set<Path> alreadyParsed, ExecutionContext ctx) {
        OmniParser omniParser = this.omniParser(alreadyParsed, subproject);
        List accepted = omniParser.acceptedPaths(this.baseDir, subproject.getProjectDir().toPath());
        return SourceFileStream.build((String)"", s -> {}).concat(omniParser.parse((Iterable)accepted, this.baseDir, ctx), accepted.size());
    }

    private OmniParser omniParser(Set<Path> alreadyParsed, Project project) {
        return OmniParser.builder((List)OmniParser.defaultResourceParsers(), (Parser[])new Parser[]{PlainTextParser.builder().plainTextMasks(this.baseDir, this.extension.getPlainTextMasks()).build(), QuarkParser.builder().build()}).exclusionMatchers(this.pathMatchers(this.baseDir, DefaultProjectParser.mergeExclusions(project, this.baseDir, this.extension))).exclusions(alreadyParsed).sizeThresholdMb(this.extension.getSizeThresholdMb()).build();
    }

    private static Collection<String> mergeExclusions(Project project, Path baseDir, RewriteExtension extension) {
        return Stream.concat(project.getSubprojects().stream().map(subproject -> PathUtils.separatorsToUnix((String)baseDir.relativize(subproject.getProjectDir().toPath()).toString())), extension.getExclusions().stream()).collect(Collectors.toList());
    }

    private Collection<PathMatcher> pathMatchers(Path basePath, Collection<String> pathExpressions) {
        return pathExpressions.stream().map(o -> basePath.getFileSystem().getPathMatcher("glob:" + o)).collect(Collectors.toList());
    }

    private SourceFileStream parseMultiplatformKotlinProject(Project subproject, Collection<PathMatcher> exclusions, Set<Path> alreadyParsed, ExecutionContext ctx) {
        SortedSet sourceSetNames;
        NamedDomainObjectContainer sourceSets;
        Object kotlinExtension = subproject.getExtensions().getByName("kotlin");
        try {
            Class<?> clazz = kotlinExtension.getClass().getClassLoader().loadClass("org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension");
            sourceSets = (NamedDomainObjectContainer)clazz.getMethod("getSourceSets", new Class[0]).invoke(kotlinExtension, new Object[0]);
        }
        catch (Exception e) {
            logger.warn("Failed to resolve KotlinMultiplatformExtension from {}. No sources files from KotlinMultiplatformExtension will be parsed.", (Object)subproject.getPath());
            return SourceFileStream.build((String)subproject.getPath(), s -> {});
        }
        SourceFileStream sourceFileStream = SourceFileStream.build((String)subproject.getPath(), s -> {});
        try {
            sourceSetNames = (SortedSet)sourceSets.getClass().getMethod("getNames", new Class[0]).invoke((Object)sourceSets, new Object[0]);
        }
        catch (Exception e) {
            logger.warn("Failed to resolve SourceSetNames in KotlinMultiplatformExtension from {}. No sources files from KotlinMultiplatformExtension will be parsed.", (Object)subproject.getPath());
            return sourceFileStream;
        }
        Path buildDirPath = this.baseDir.relativize(((Directory)subproject.getLayout().getBuildDirectory().get()).getAsFile().toPath());
        for (String sourceSetName : sourceSetNames) {
            try {
                Set implementationClasspath;
                Object sourceSet = sourceSets.getClass().getMethod("getByName", String.class).invoke((Object)sourceSets, sourceSetName);
                SourceDirectorySet kotlinDirectorySet = (SourceDirectorySet)sourceSet.getClass().getMethod("getKotlin", new Class[0]).invoke(sourceSet, new Object[0]);
                List kotlinPaths = kotlinDirectorySet.getFiles().stream().filter(it -> it.isFile() && it.getName().endsWith(".kt")).map(File::toPath).map(Path::toAbsolutePath).map(Path::normalize).collect(Collectors.toList());
                String implementationName = (String)sourceSet.getClass().getMethod("getImplementationConfigurationName", new Class[0]).invoke(sourceSet, new Object[0]);
                Configuration implementation = subproject.getConfigurations().getByName(implementationName);
                Configuration rewriteImplementation = (Configuration)subproject.getConfigurations().maybeCreate("rewrite" + implementationName);
                if (!rewriteImplementation.getExtendsFrom().contains(implementation)) {
                    rewriteImplementation.extendsFrom(new Configuration[]{implementation});
                }
                try {
                    implementationClasspath = rewriteImplementation.resolve();
                }
                catch (Exception e) {
                    logger.warn("Failed to resolve dependencies from {}:{}. Some type information may be incomplete", (Object)subproject.getPath(), (Object)implementationName);
                    implementationClasspath = Collections.emptySet();
                }
                String compileName = (String)sourceSet.getClass().getMethod("getCompileOnlyConfigurationName", new Class[0]).invoke(sourceSet, new Object[0]);
                Configuration compileOnly = subproject.getConfigurations().getByName(compileName);
                Configuration rewriteCompileOnly = (Configuration)subproject.getConfigurations().maybeCreate("rewrite" + compileName);
                rewriteCompileOnly.setCanBeResolved(true);
                rewriteCompileOnly.extendsFrom(new Configuration[]{compileOnly});
                List dependencyPaths = Stream.concat(implementationClasspath.stream(), rewriteCompileOnly.getFiles().stream()).map(File::toPath).map(Path::toAbsolutePath).map(Path::normalize).distinct().collect(Collectors.toList());
                if (kotlinPaths.isEmpty()) continue;
                JavaTypeCache javaTypeCache = new JavaTypeCache();
                KotlinParser kp = KotlinParser.builder().classpath(dependencyPaths).typeCache(javaTypeCache).logCompilationWarningsAndErrors(this.extension.getLogCompilationWarningsAndErrors()).build();
                Stream<SourceFile> cus = kp.parse(kotlinPaths, this.baseDir, ctx);
                alreadyParsed.addAll(kotlinPaths);
                cus = cus.map(cu -> {
                    if (DefaultProjectParser.isExcluded(this.repository, exclusions, cu.getSourcePath()) || cu.getSourcePath().startsWith(buildDirPath)) {
                        return null;
                    }
                    return cu;
                }).filter(Objects::nonNull);
                JavaSourceSet sourceSetProvenance = JavaSourceSet.build((String)sourceSetName, dependencyPaths);
                sourceFileStream = sourceFileStream.concat(cus.map(DefaultProjectParser.addProvenance((Marker)sourceSetProvenance)), kotlinPaths.size());
                logger.info("Scanned {} Kotlin sources in {}/{}", new Object[]{kotlinPaths.size(), subproject.getPath(), kotlinDirectorySet.getName()});
            }
            catch (Exception e) {
                logger.warn("Failed to resolve sourceSet from {}:{}. Some type information may be incomplete", (Object)subproject.getPath(), (Object)sourceSetName);
            }
        }
        return sourceFileStream;
    }

    private SourceFile logParseErrors(SourceFile source) {
        source.getMarkers().findFirst(ParseExceptionResult.class).ifPresent(e -> {
            if (this.firstWarningLogged.compareAndSet(false, true)) {
                logger.warn("There were problems parsing some source files, run with --info to see full stack traces");
            }
            logger.warn("There were problems parsing {}", (Object)source.getSourcePath());
            logger.debug(e.getMessage());
        });
        return source;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean isExcluded(@Nullable Repository repository, Collection<PathMatcher> exclusions, Path path) {
        for (PathMatcher excluded : exclusions) {
            if (!excluded.matches(path)) continue;
            return true;
        }
        if (!path.isAbsolute() && !path.startsWith(File.separator)) {
            return DefaultProjectParser.isExcluded(repository, exclusions, Paths.get("/" + path, new String[0]));
        }
        if (repository == null) return false;
        String repoRelativePath = PathUtils.separatorsToUnix((String)path.toString());
        if (repoRelativePath.isEmpty()) return false;
        if ("/".equals(repoRelativePath)) {
            return false;
        }
        try (TreeWalk walk = new TreeWalk(repository);){
            walk.addTree((AbstractTreeIterator)new FileTreeIterator(repository));
            walk.setFilter(PathFilterGroup.createFromStrings((String[])new String[]{repoRelativePath}));
            while (walk.next()) {
                WorkingTreeIterator workingTreeIterator = (WorkingTreeIterator)walk.getTree(0, WorkingTreeIterator.class);
                if (walk.getPathString().equals(repoRelativePath)) {
                    boolean bl = workingTreeIterator.isEntryIgnored();
                    return bl;
                }
                if (!workingTreeIterator.getEntryFileMode().equals(FileMode.TREE)) continue;
                if (workingTreeIterator.isEntryIgnored()) {
                    boolean bl = true;
                    return bl;
                }
                walk.enterSubtree();
            }
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private List<NamedStyles> getStyles() {
        if (this.styles == null) {
            this.styles = this.environment().activateStyles(this.getActiveStyles());
            File checkstyleConfig = this.extension.getCheckstyleConfigFile();
            if (checkstyleConfig != null && checkstyleConfig.exists()) {
                try {
                    this.styles.add((NamedStyles)CheckstyleConfigLoader.loadCheckstyleConfig((Path)checkstyleConfig.toPath(), this.extension.getCheckstyleProperties()));
                }
                catch (Exception e) {
                    logger.warn("Unable to parse Checkstyle configuration", (Throwable)e);
                }
            }
        }
        return this.styles;
    }

    protected ResultsContainer listResults(ExecutionContext ctx) {
        Environment env = this.environment();
        Recipe recipe = env.activateRecipes(this.getActiveRecipes());
        if ("org.openrewrite.Recipe$Noop".equals(recipe.getName())) {
            logger.warn("No recipes were activated. Activate a recipe with rewrite.activeRecipe(\"com.fully.qualified.RecipeClassName\") in your build file, or on the command line with -DactiveRecipe=com.fully.qualified.RecipeClassName");
            return new ResultsContainer(this.baseDir, null);
        }
        logger.lifecycle("Validating active recipes");
        Collection validated = recipe.validateAll(ctx, new ArrayList());
        List<Validated.Invalid> failedValidations = validated.stream().map(Validated::failures).flatMap(Collection::stream).collect(Collectors.toList());
        if (!failedValidations.isEmpty()) {
            failedValidations.forEach(failedValidation -> logger.error("Recipe validation error in {}: {}", new Object[]{failedValidation.getProperty(), failedValidation.getMessage(), failedValidation.getException()}));
            if (this.extension.getFailOnInvalidActiveRecipes()) {
                throw new RuntimeException("Recipe validation errors detected as part of one or more activeRecipe(s). Please check error logs.");
            }
            logger.error("Recipe validation errors detected as part of one or more activeRecipe(s). Execution will continue regardless.");
        }
        Autodetect.Detector javaDetector = Autodetect.detector();
        Autodetect.Detector kotlinDetector = org.openrewrite.kotlin.style.Autodetect.detector();
        Autodetect.Detector xmlDetector = org.openrewrite.xml.style.Autodetect.detector();
        List sourceFiles = this.parse(ctx).peek(s -> {
            if (s instanceof K.CompilationUnit) {
                kotlinDetector.sample(s);
            } else if (s instanceof J.CompilationUnit) {
                javaDetector.sample(s);
            }
        }).peek(arg_0 -> ((Autodetect.Detector)xmlDetector).sample(arg_0)).collect(Collectors.toList());
        HashMap<Class<? extends SourceFile>, NamedStyles> stylesByType = new HashMap<Class<? extends SourceFile>, NamedStyles>();
        stylesByType.put((Class<? extends SourceFile>)J.CompilationUnit.class, (NamedStyles)javaDetector.build());
        stylesByType.put((Class<? extends SourceFile>)K.CompilationUnit.class, (NamedStyles)kotlinDetector.build());
        stylesByType.put((Class<? extends SourceFile>)Xml.Document.class, (NamedStyles)xmlDetector.build());
        sourceFiles = ListUtils.map(sourceFiles, this.applyAutodetected(stylesByType));
        logger.lifecycle("All sources parsed, running active recipes: {}", new Object[]{String.join((CharSequence)", ", this.getActiveRecipes())});
        RecipeRun recipeRun = recipe.run((LargeSourceSet)new InMemoryLargeSourceSet(sourceFiles), ctx);
        if (this.extension.isExportDatatables()) {
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss-SSS"));
            Path datatableDirectoryPath = ((Directory)this.project.getLayout().getBuildDirectory().dir("reports/rewrite/datatables/" + timestamp).get()).getAsFile().toPath();
            logger.info(String.format("Printing available datatables to: %s", datatableDirectoryPath));
            recipeRun.exportDatatablesToCsv(datatableDirectoryPath, ctx);
        }
        return new ResultsContainer(this.baseDir, recipeRun);
    }

    @Override
    public void shutdownRewrite() {
        REPO_ROOT_TO_PROVENANCE.clear();
        GradleProjectBuilder.clearCaches();
        if (this.repository != null) {
            this.repository.close();
        }
    }

    private UnaryOperator<SourceFile> applyAutodetected(Map<Class<? extends SourceFile>, NamedStyles> stylesByType) {
        return before -> {
            for (Map.Entry styleTypeEntry : stylesByType.entrySet()) {
                if (!((Class)styleTypeEntry.getKey()).isAssignableFrom(before.getClass())) continue;
                before = (SourceFile)before.withMarkers(before.getMarkers().add((Marker)styleTypeEntry.getValue()));
            }
            return before;
        };
    }

    private <T extends SourceFile> UnaryOperator<T> addProvenance(List<Marker> projectProvenance) {
        return s -> {
            Markers m = s.getMarkers();
            for (Marker marker : projectProvenance) {
                m = m.addIfAbsent(marker);
            }
            for (NamedStyles style : this.getStyles()) {
                m = m.addIfAbsent((Marker)style);
            }
            return (SourceFile)s.withMarkers(m);
        };
    }

    static <T extends SourceFile> UnaryOperator<T> addProvenance(Marker sourceSet) {
        return s -> {
            Markers m = s.getMarkers();
            m = m.addIfAbsent(sourceSet);
            return (SourceFile)s.withMarkers(m);
        };
    }

    protected void logRecipesThatMadeChanges(Result result) {
        String indent = LOG_INDENT_INCREMENT;
        String prefix = LOG_INDENT_INCREMENT;
        for (RecipeDescriptor recipeDescriptor : result.getRecipeDescriptorsThatMadeChanges()) {
            this.logRecipe(recipeDescriptor, prefix);
            prefix = prefix + indent;
        }
    }

    private void logRecipe(RecipeDescriptor rd, String prefix) {
        String opts;
        StringBuilder recipeString = new StringBuilder(prefix + rd.getName());
        if (!rd.getOptions().isEmpty() && !(opts = rd.getOptions().stream().map(option -> {
            if (option.getValue() != null) {
                return option.getName() + "=" + option.getValue();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.joining(", "))).isEmpty()) {
            recipeString.append(": {").append(opts).append("}");
        }
        logger.warn("{}", (Object)recipeString);
        for (RecipeDescriptor rChild : rd.getRecipeList()) {
            this.logRecipe(rChild, prefix + LOG_INDENT_INCREMENT);
        }
    }

    private List<SourceSet> findGradleSourceSets(Project project) {
        List sourceSets = Collections.emptyList();
        if (project.getGradle().getGradleVersion().compareTo("7.1") >= 0) {
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().findByType(JavaPluginExtension.class);
            if (javaPluginExtension != null) {
                sourceSets = new ArrayList(javaPluginExtension.getSourceSets());
            }
        } else {
            JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
            if (javaConvention != null) {
                sourceSets = new ArrayList(javaConvention.getSourceSets());
            }
        }
        return sourceSets.stream().sorted(Comparator.comparingInt(sourceSet -> {
            if ("main".equals(sourceSet.getName())) {
                return 0;
            }
            if ("test".equals(sourceSet.getName())) {
                return 1;
            }
            return 2;
        })).collect(Collectors.toList());
    }

    private JavaVersion getJavaVersion(@Nullable JavaCompile javaCompileTask) {
        String sourceCompatibility = "";
        String targetCompatibility = "";
        if (javaCompileTask != null) {
            sourceCompatibility = javaCompileTask.getSourceCompatibility();
            targetCompatibility = javaCompileTask.getTargetCompatibility();
        }
        return new JavaVersion(Tree.randomId(), System.getProperty("java.runtime.version"), System.getProperty("java.vm.vendor"), sourceCompatibility, targetCompatibility);
    }

    private Charset getSourceFileEncoding(@Nullable JavaCompile javaCompileTask, Charset defaultCharset) {
        String sourceEncoding = null;
        if (javaCompileTask != null) {
            CompileOptions compileOptions = javaCompileTask.getOptions();
            sourceEncoding = compileOptions.getEncoding();
        }
        return Optional.ofNullable(sourceEncoding).map(Charset::forName).orElse(defaultCharset);
    }

    private /* synthetic */ Stream lambda$parseGradleProjectSourceSets$16(List groovyPaths, ExecutionContext ctx, GroovyParser gp) {
        return gp.parse((Iterable)groovyPaths, this.baseDir, ctx);
    }

    private static /* synthetic */ void lambda$parse$4(ProgressBar progressBar, String projectName) {
        progressBar.intermediateResult(":" + projectName);
    }
}

