/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.toolingapi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.jspecify.annotations.Nullable;
import org.openrewrite.gradle.toolingapi.OpenRewriteModel;
import org.opentest4j.TestAbortedException;

public class OpenRewriteModelBuilder {
    public static OpenRewriteModel forProjectDirectory(File projectDir, @Nullable File buildFile) {
        return OpenRewriteModelBuilder.forProjectDirectory(projectDir, buildFile, null);
    }

    /*
     * Loose catch block
     */
    public static OpenRewriteModel forProjectDirectory(File projectDir, @Nullable File buildFile, @Nullable String initScript) {
        DefaultGradleConnector connector = (DefaultGradleConnector)GradleConnector.newConnector();
        if (Files.exists(projectDir.toPath().resolve("gradle/wrapper/gradle-wrapper.properties"), new LinkOption[0])) {
            connector.useBuildDistribution();
        } else {
            connector.useGradleVersion("8.4");
        }
        connector.forProjectDirectory(projectDir);
        ArrayList<String> arguments = new ArrayList<String>();
        if (buildFile != null && buildFile.exists()) {
            arguments.add("-b");
            arguments.add(buildFile.getAbsolutePath());
        }
        arguments.add("--init-script");
        Path init = projectDir.toPath().resolve("openrewrite-tooling.gradle").toAbsolutePath();
        arguments.add(init.toString());
        try (ProjectConnection connection = connector.connect();){
            ModelBuilder customModelBuilder = connection.model(OpenRewriteModel.class);
            try {
                Object is;
                if (initScript == null) {
                    is = OpenRewriteModel.class.getResourceAsStream("/init.gradle");
                    try {
                        if (is == null) {
                            throw new IllegalStateException("Expected to find init.gradle on the classpath");
                        }
                        Files.copy((InputStream)is, init, new CopyOption[0]);
                    }
                    finally {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                } else {
                    Files.write(init, initScript.getBytes(), new OpenOption[0]);
                }
                customModelBuilder.withArguments(arguments);
                is = (OpenRewriteModel)customModelBuilder.get();
                return is;
            }
            catch (IOException e) {
                throw new TestAbortedException("Failed to load Gradle tooling API", (Throwable)e);
            }
            finally {
                try {
                    Files.delete(init);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }
}

