/*
 * Decompiled with CFR 0.152.
 */
package com.colloquial.io;

import java.io.IOException;
import java.io.InputStream;

public final class BitInput {
    private final InputStream _in;
    private int _nextByte;
    private int _nextBitIndex;
    private boolean _endOfStream = false;

    public BitInput(InputStream in) throws IOException {
        this._in = in;
        this.readAhead();
    }

    public long available() throws IOException {
        return this.endOfStream() ? 0L : 1L;
    }

    public void close() throws IOException {
        this._in.close();
    }

    public boolean endOfStream() {
        return this._endOfStream;
    }

    public boolean readBit() throws IOException {
        if (this._nextBitIndex > 0) {
            return (this._nextByte & 1 << this._nextBitIndex--) != 0;
        }
        boolean result = (this._nextByte & 1) != 0;
        this.readAhead();
        return result;
    }

    private void readAhead() throws IOException {
        if (this._endOfStream) {
            return;
        }
        this._nextByte = this._in.read();
        if (this._nextByte == -1) {
            this._endOfStream = true;
            return;
        }
        this._nextBitIndex = 7;
    }
}

