/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Cleanly;
import org.openqa.selenium.internal.TemporaryFilesystem;

public class FileHandler {
    private static final int BUF_SIZE = 16384;
    private static final Method JDK6_SETWRITABLE = FileHandler.findJdk6SetWritableMethod();
    private static final File CHMOD_SETWRITABLE = FileHandler.findChmodCommand();

    public static File unzip(InputStream resource) throws IOException {
        File output = TemporaryFilesystem.createTempDir("unzip", "stream");
        ZipInputStream zipStream = new ZipInputStream(new BufferedInputStream(resource, 16384));
        ZipEntry entry = zipStream.getNextEntry();
        while (entry != null) {
            if (entry.isDirectory()) {
                FileHandler.createDir(new File(output, entry.getName()));
            } else {
                FileHandler.unzipFile(output, zipStream, entry.getName());
            }
            entry = zipStream.getNextEntry();
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzipFile(File output, InputStream zipStream, String name) throws IOException {
        File toWrite = new File(output, name);
        if (!FileHandler.createDir(toWrite.getParentFile())) {
            throw new IOException("Cannot create parent director for: " + name);
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(toWrite), 16384);
        try {
            int read;
            byte[] buffer = new byte[16384];
            while ((read = zipStream.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResource(File outputDir, Class forClassLoader, String ... names) throws IOException {
        for (String name : names) {
            InputStream is = FileHandler.locateResource(forClassLoader, name);
            try {
                FileHandler.unzipFile(outputDir, is, name);
            }
            finally {
                Cleanly.close(is);
            }
        }
    }

    private static InputStream locateResource(Class forClassLoader, String name) throws IOException {
        String[] alternatives;
        String arch = System.getProperty("os.arch").toLowerCase() + "/";
        for (String possibility : alternatives = new String[]{name, "/" + name, arch + name, "/" + arch + name}) {
            InputStream stream = FileHandler.class.getResourceAsStream(possibility);
            if (stream != null) {
                return stream;
            }
            stream = forClassLoader.getResourceAsStream(possibility);
            if (stream == null) continue;
            return stream;
        }
        throw new IOException("Unable to locate: " + name);
    }

    public static boolean createDir(File dir) throws IOException {
        if ((dir.exists() || dir.mkdirs()) && dir.canWrite()) {
            return true;
        }
        if (dir.exists()) {
            FileHandler.makeWritable(dir);
            return dir.canWrite();
        }
        return FileHandler.createDir(dir.getParentFile());
    }

    public static boolean makeWritable(File file) throws IOException {
        block8: {
            if (file.canWrite()) {
                return true;
            }
            if (JDK6_SETWRITABLE != null) {
                try {
                    return (Boolean)JDK6_SETWRITABLE.invoke((Object)file, true);
                }
                catch (IllegalAccessException e) {
                    break block8;
                }
                catch (InvocationTargetException e) {
                    break block8;
                }
            }
            if (CHMOD_SETWRITABLE != null) {
                try {
                    Process process = Runtime.getRuntime().exec(new String[]{CHMOD_SETWRITABLE.getAbsolutePath(), "+x", file.getAbsolutePath()});
                    process.waitFor();
                    return file.canWrite();
                }
                catch (InterruptedException e1) {
                    throw new WebDriverException(e1);
                }
            }
        }
        return false;
    }

    public static boolean isZipped(String fileName) {
        return fileName.endsWith(".zip") || fileName.endsWith(".xpi");
    }

    public static boolean delete(File toDelete) {
        boolean deleted = true;
        if (toDelete.isDirectory()) {
            for (File child : toDelete.listFiles()) {
                deleted &= child.canWrite() && FileHandler.delete(child);
            }
        }
        return deleted && toDelete.canWrite() && toDelete.delete();
    }

    public static void copy(File from, File to) throws IOException {
        if (!from.exists()) {
            return;
        }
        if (from.isDirectory()) {
            FileHandler.copyDir(from, to);
        } else {
            FileHandler.copyFile(from, to);
        }
    }

    private static void copyDir(File from, File to) throws IOException {
        String[] children;
        FileHandler.createDir(to);
        for (String child : children = from.list()) {
            if (".parentlock".equals(child) || "parent.lock".equals(child)) continue;
            FileHandler.copy(new File(from, child), new File(to, child));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File from, File to) throws IOException {
        FileChannel out = null;
        FileChannel in = null;
        try {
            in = new FileInputStream(from).getChannel();
            out = new FileOutputStream(to).getChannel();
            long length = in.size();
            long copied = in.transferTo(0L, in.size(), out);
            if (copied != length) {
                throw new IOException("Could not transfer all bytes.");
            }
        }
        catch (Throwable throwable) {
            Cleanly.close(out);
            Cleanly.close(in);
            throw throwable;
        }
        Cleanly.close(out);
        Cleanly.close(in);
    }

    private static Method findJdk6SetWritableMethod() {
        try {
            return File.class.getMethod("setWritable", Boolean.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static File findChmodCommand() {
        String[] paths;
        String allPaths = System.getenv("PATH");
        for (String path : paths = allPaths.split(File.pathSeparator)) {
            File chmod = new File(path, "chmod");
            if (!chmod.exists()) continue;
            return chmod;
        }
        return null;
    }
}

