/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.commons.logging.Log;
import org.mortbay.http.HashUserRealm;
import org.mortbay.http.HttpContext;
import org.mortbay.http.SecurityConstraint;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.SecurityHandler;
import org.mortbay.jetty.Server;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.ClasspathResourceLocator;
import org.openqa.selenium.server.FsResourceLocator;
import org.openqa.selenium.server.InjectionHelper;
import org.openqa.selenium.server.ProxyHandler;
import org.openqa.selenium.server.SeleniumDriverResourceHandler;
import org.openqa.selenium.server.SingleEntryAsyncQueue;
import org.openqa.selenium.server.StaticContentHandler;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.htmlrunner.HTMLLauncher;
import org.openqa.selenium.server.htmlrunner.HTMLResultsListener;
import org.openqa.selenium.server.htmlrunner.SeleniumHTMLRunnerResultsHandler;
import org.openqa.selenium.server.htmlrunner.SingleTestSuiteResourceHandler;
import org.openqa.selenium.server.log.MaxLevelFilter;
import org.openqa.selenium.server.log.StdOutHandler;
import org.openqa.selenium.server.log.TerseFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumServer {
    private static Log log;
    private Server server;
    private SeleniumDriverResourceHandler driver;
    private SeleniumHTMLRunnerResultsHandler postResultsHandler;
    private StaticContentHandler staticContentHandler;
    private int port;
    private boolean multiWindow = false;
    private Thread shutDownHook;
    private static ProxyHandler customProxyHandler;
    private static String debugURL;
    private static boolean browserSideLogEnabled;
    private static boolean avoidProxy;
    private static boolean proxyInjectionMode;
    private static File firefoxProfileTemplate;
    private static Handler[] defaultHandlers;
    private static Map<Handler, Formatter> defaultFormatters;
    private static Map<Handler, Level> defaultLevels;
    private static Map<File, FileHandler> seleniumFileHandlers;
    public static final int DEFAULT_PORT = 4444;
    private static int portDriversShouldContact;
    private static String logOutFileName;
    private static String forcedBrowserMode;
    public static final int DEFAULT_TIMEOUT = 1800;
    public static int timeoutInSeconds;
    public static final int MIN_JETTY_THREADS = 1;
    public static final int MAX_JETTY_THREADS = 1024;
    public static final int DEFAULT_JETTY_THREADS = 512;
    private static int jettyThreads;
    private static Boolean reusingBrowserSessions;
    private static String dontInjectRegex;
    private static boolean FORCE_PROXY_CHAIN;
    private static boolean debugMode;
    private static boolean dontTouchLogging;

    public static void main(String[] args) throws Exception {
        int port = SeleniumServer.getDefaultPort();
        boolean interactive = false;
        boolean htmlSuite = false;
        boolean selfTest = false;
        File selfTestDir = null;
        boolean multiWindow = false;
        File userExtensions = null;
        boolean proxyInjectionModeArg = false;
        int portDriversShouldContactArg = 0;
        boolean userJsInjection = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-help".equalsIgnoreCase(arg)) {
                SeleniumServer.usage(null);
                System.exit(1);
                continue;
            }
            if ("-defaultBrowserString".equalsIgnoreCase(arg)) {
                SeleniumServer.usage("-defaultBrowserString has been renamed -forcedBrowserMode");
                continue;
            }
            if ("-forcedBrowserMode".equalsIgnoreCase(arg)) {
                ++i;
                while (i < args.length) {
                    forcedBrowserMode = forcedBrowserMode == null ? "" : forcedBrowserMode + " ";
                    forcedBrowserMode = forcedBrowserMode + args[i];
                    ++i;
                }
                continue;
            }
            if ("-log".equalsIgnoreCase(arg)) {
                logOutFileName = SeleniumServer.getArg(args, ++i);
                continue;
            }
            if ("-port".equalsIgnoreCase(arg)) {
                port = Integer.parseInt(SeleniumServer.getArg(args, ++i));
                continue;
            }
            if ("-multiWindow".equalsIgnoreCase(arg)) {
                multiWindow = true;
                continue;
            }
            if ("-avoidProxy".equalsIgnoreCase(arg)) {
                SeleniumServer.setAvoidProxy(true);
                continue;
            }
            if ("-proxyInjectionMode".equalsIgnoreCase(arg)) {
                proxyInjectionModeArg = true;
                continue;
            }
            if ("-portDriversShouldContact".equalsIgnoreCase(arg)) {
                portDriversShouldContactArg = Integer.parseInt(SeleniumServer.getArg(args, ++i));
                continue;
            }
            if ("-noBrowserSessionReuse".equalsIgnoreCase(arg)) {
                reusingBrowserSessions = Boolean.FALSE;
                continue;
            }
            if ("-browserSessionReuse".equalsIgnoreCase(arg)) {
                reusingBrowserSessions = Boolean.TRUE;
                continue;
            }
            if ("-firefoxProfileTemplate".equalsIgnoreCase(arg)) {
                if ((firefoxProfileTemplate = new File(SeleniumServer.getArg(args, ++i))).exists()) continue;
                System.err.println("Firefox profile template doesn't exist: " + firefoxProfileTemplate.getAbsolutePath());
                System.exit(1);
                continue;
            }
            if ("-dontInjectRegex".equalsIgnoreCase(arg)) {
                dontInjectRegex = SeleniumServer.getArg(args, ++i);
                continue;
            }
            if ("-browserSideLog".equalsIgnoreCase(arg)) {
                SeleniumServer.setBrowserSideLogEnabled(true);
                continue;
            }
            if ("-debug".equalsIgnoreCase(arg)) {
                SeleniumServer.setDebugMode(true);
                continue;
            }
            if ("-debugURL".equalsIgnoreCase(arg)) {
                debugURL = SeleniumServer.getArg(args, ++i);
                continue;
            }
            if ("-timeout".equalsIgnoreCase(arg)) {
                timeoutInSeconds = Integer.parseInt(SeleniumServer.getArg(args, ++i));
                continue;
            }
            if ("-jettyThreads".equalsIgnoreCase(arg)) {
                int jettyThreads = Integer.parseInt(SeleniumServer.getArg(args, ++i));
                SeleniumServer.setJettyThreads(jettyThreads);
                continue;
            }
            if ("-userJsInjection".equalsIgnoreCase(arg)) {
                userJsInjection = true;
                if (InjectionHelper.addUserJsInjectionFile(SeleniumServer.getArg(args, ++i))) continue;
                SeleniumServer.usage(null);
                System.exit(1);
                continue;
            }
            if ("-userContentTransformation".equalsIgnoreCase(arg)) {
                if (InjectionHelper.addUserContentTransformation(SeleniumServer.getArg(args, ++i), SeleniumServer.getArg(args, ++i))) continue;
                SeleniumServer.usage(null);
                System.exit(1);
                continue;
            }
            if ("-userExtensions".equalsIgnoreCase(arg)) {
                if (!(userExtensions = new File(SeleniumServer.getArg(args, ++i))).exists()) {
                    System.err.println("User Extensions file doesn't exist: " + userExtensions.getAbsolutePath());
                    System.exit(1);
                }
                if ("user-extensions.js".equalsIgnoreCase(userExtensions.getName())) continue;
                System.err.println("User extensions file MUST be called \"user-extensions.js\": " + userExtensions.getAbsolutePath());
                System.exit(1);
                continue;
            }
            if ("-selfTest".equalsIgnoreCase(arg)) {
                selfTest = true;
                selfTestDir = new File(SeleniumServer.getArg(args, ++i));
                selfTestDir.mkdirs();
                continue;
            }
            if ("-htmlSuite".equalsIgnoreCase(arg)) {
                try {
                    System.setProperty("htmlSuite.browserString", args[++i]);
                    System.setProperty("htmlSuite.startURL", args[++i]);
                    System.setProperty("htmlSuite.suiteFilePath", args[++i]);
                    System.setProperty("htmlSuite.resultFilePath", args[++i]);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.err.println("Not enough command line arguments for -htmlSuite");
                    System.err.println("-htmlSuite requires you to specify:");
                    System.err.println("* browserString (e.g. \"*firefox\")");
                    System.err.println("* startURL (e.g. \"http://www.google.com\")");
                    System.err.println("* suiteFile (e.g. \"c:\\absolute\\path\\to\\my\\HTMLSuite.html\")");
                    System.err.println("* resultFile (e.g. \"c:\\absolute\\path\\to\\my\\results.html\")");
                    System.exit(1);
                }
                htmlSuite = true;
                continue;
            }
            if ("-interactive".equalsIgnoreCase(arg)) {
                timeoutInSeconds = Integer.MAX_VALUE;
                interactive = true;
                continue;
            }
            if (arg.startsWith("-D")) {
                SeleniumServer.setSystemProperty(arg);
                continue;
            }
            SeleniumServer.usage("unrecognized argument " + arg);
            System.exit(1);
        }
        if (userJsInjection && !proxyInjectionModeArg) {
            System.err.println("User js injection can only be used w/ -proxyInjectionMode");
            System.exit(1);
        }
        if (portDriversShouldContactArg == 0) {
            portDriversShouldContactArg = port;
        }
        System.setProperty("org.mortbay.http.HttpRequest.maxFormContentSize", "0");
        final SeleniumServer seleniumProxy = new SeleniumServer(port);
        seleniumProxy.multiWindow = multiWindow;
        SeleniumServer.checkArgsSanity(port, interactive, htmlSuite, selfTest, proxyInjectionModeArg, portDriversShouldContactArg, seleniumProxy);
        Thread jetty = new Thread(new Runnable(){

            public void run() {
                try {
                    seleniumProxy.start();
                }
                catch (Exception e) {
                    log.error("jetty run exception seen", e);
                }
            }
        });
        if (interactive) {
            jetty.setDaemon(true);
        }
        seleniumProxy.start();
        if (userExtensions != null) {
            seleniumProxy.addNewStaticContent(userExtensions.getParentFile());
        }
        if (selfTest) {
            boolean result = new HTMLLauncher(seleniumProxy).runSelfTests(selfTestDir);
            System.exit(result ? 0 : 1);
        }
        if (htmlSuite) {
            SeleniumServer.runHtmlSuite(seleniumProxy);
            return;
        }
        if (interactive) {
            String userInput;
            AsyncExecute.sleepTight(500L);
            System.out.println("Entering interactive mode... type Selenium commands here (e.g: cmd=open&1=http://www.yahoo.com)");
            BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in));
            final String[] lastSessionId = new String[]{""};
            while ((userInput = stdIn.readLine()) != null) {
                boolean newBrowserSession;
                if ("exit".equals(userInput = userInput.trim()) || "quit".equals(userInput)) {
                    System.out.println("Stopping...");
                    seleniumProxy.stop();
                    System.exit(0);
                }
                if ("".equals(userInput)) continue;
                if (!userInput.startsWith("cmd=") && !userInput.startsWith("commandResult=")) {
                    System.err.println("ERROR -  Invalid command: \"" + userInput + "\"");
                    continue;
                }
                boolean bl = newBrowserSession = userInput.indexOf("getNewBrowserSession") != -1;
                if (userInput.indexOf("sessionId") == -1 && !newBrowserSession) {
                    userInput = userInput + "&sessionId=" + lastSessionId[0];
                }
                final URL url = new URL("http://localhost:" + port + "/selenium-server/driver?" + userInput);
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        block4: {
                            try {
                                log.info("---> Requesting " + url.toString());
                                URLConnection conn = url.openConnection();
                                conn.connect();
                                InputStream is = conn.getInputStream();
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                byte[] buffer = new byte[2048];
                                int length = -1;
                                while ((length = is.read(buffer)) != -1) {
                                    out.write(buffer, 0, length);
                                }
                                is.close();
                                String output = out.toString();
                                if (newBrowserSession && output.startsWith("OK,")) {
                                    lastSessionId[0] = output.substring(3);
                                }
                            }
                            catch (IOException e) {
                                System.err.println(e.getMessage());
                                if (!SeleniumServer.isDebugMode()) break block4;
                                e.printStackTrace();
                            }
                        }
                    }
                });
                t.start();
            }
        }
    }

    private static void checkArgsSanity(int port, boolean interactive, boolean htmlSuite, boolean selfTest, boolean proxyInjectionModeArg, int portDriversShouldContactArg, SeleniumServer seleniumProxy) throws Exception {
        if (interactive) {
            if (htmlSuite) {
                System.err.println("You can't use -interactive and -htmlSuite on the same line!");
                System.exit(1);
            }
            if (selfTest) {
                System.err.println("You can't use -interactive and -selfTest on the same line!");
                System.exit(1);
            }
        } else if (selfTest && htmlSuite) {
            System.err.println("You can't use -selfTest and -htmlSuite on the same line!");
            System.exit(1);
        }
        SingleEntryAsyncQueue.setDefaultTimeout(timeoutInSeconds);
        seleniumProxy.setProxyInjectionMode(proxyInjectionModeArg);
        if (!SeleniumServer.isProxyInjectionMode() && (InjectionHelper.userContentTransformationsExist() || InjectionHelper.userJsInjectionsExist())) {
            SeleniumServer.usage("-userJsInjection and -userContentTransformation are only valid in combination with -proxyInjectionMode");
            System.exit(1);
        }
        if (!SeleniumServer.isProxyInjectionMode() && SeleniumServer.reusingBrowserSessions()) {
            SeleniumServer.usage("-reusingBrowserSessions only valid in combination with -proxyInjectionMode (because of the need for multiple domain support, which only -proxyInjectionMode provides).");
            System.exit(1);
        }
    }

    private static String getArg(String[] args, int i) {
        if (i >= args.length) {
            SeleniumServer.usage("expected at least one more argument");
            System.exit(-1);
        }
        return args[i];
    }

    private static void setSystemProperty(String arg) {
        if (arg.indexOf(61) == -1) {
            SeleniumServer.usage("poorly formatted Java property setting (I expect to see '=') " + arg);
            System.exit(1);
        }
        String property = arg.replaceFirst("-D", "").replaceFirst("=.*", "");
        String value = arg.replaceFirst("[^=]*=", "");
        System.err.println("Setting system property " + property + " to " + value);
        System.setProperty(property, value);
    }

    private static void usage(String msg) {
        if (msg != null) {
            System.err.println(msg + ":");
        }
        String INDENT = "  ";
        String INDENT2X = INDENT + INDENT;
        SeleniumServer.printWrappedErrorLine("", "Usage: java -jar selenium-server.jar [-interactive] [options]\n");
        SeleniumServer.printWrappedErrorLine(INDENT, "-port <nnnn>: the port number the selenium server should use (default 4444)");
        SeleniumServer.printWrappedErrorLine(INDENT, "-timeout <nnnn>: an integer number of seconds before we should give up");
        SeleniumServer.printWrappedErrorLine(INDENT, "-interactive: puts you into interactive mode.  See the tutorial for more details");
        SeleniumServer.printWrappedErrorLine(INDENT, "-multiWindow: puts you into a mode where the test web site executes in a separate window, and selenium supports frames");
        SeleniumServer.printWrappedErrorLine(INDENT, "-forcedBrowserMode <browser>: sets the browser mode (e.g. \"*iexplore\" for all sessions, no matter what is passed to getNewBrowserSession");
        SeleniumServer.printWrappedErrorLine(INDENT, "-userExtensions <file>: indicates a JavaScript file that will be loaded into selenium");
        SeleniumServer.printWrappedErrorLine(INDENT, "-browserSessionReuse: stops re-initialization and spawning of the browser between tests");
        SeleniumServer.printWrappedErrorLine(INDENT, "-avoidProxy: By default, we proxy every browser request; set this flag to make the browser use our proxy only for URLs containing '/selenium-server'");
        SeleniumServer.printWrappedErrorLine(INDENT, "-firefoxProfileTemplate <dir>: normally, we generate a fresh empty Firefox profile every time we launch.  You can specify a directory to make us copy your profile directory instead.");
        SeleniumServer.printWrappedErrorLine(INDENT, "-debug: puts you into debug mode, with more trace information and diagnostics on the console");
        SeleniumServer.printWrappedErrorLine(INDENT, "-browserSideLog: enables logging on the browser side; logging messages will be transmitted to the server.  This can affect performance.");
        SeleniumServer.printWrappedErrorLine(INDENT, "-log <logFileName>: writes lots of debug information out to a log file");
        SeleniumServer.printWrappedErrorLine(INDENT, "-htmlSuite <browser> <startURL> <suiteFile> <resultFile>: Run a single HTML Selenese (Selenium Core) suite and then exit immediately, using the specified browser (e.g. \"*firefox\") on the specified URL (e.g. \"http://www.google.com\").  You need to specify the absolute path to the HTML test suite as well as the path to the HTML results file we'll generate.");
        SeleniumServer.printWrappedErrorLine(INDENT, "-proxyInjectionMode: puts you into proxy injection mode, a mode where the selenium server acts as a proxy server for all content going to the test application.  Under this mode, multiple domains can be visited, and the following additional flags are supported:\n");
        SeleniumServer.printWrappedErrorLine(INDENT2X, "-dontInjectRegex <regex>: an optional regular expression that proxy injection mode can use to know when to bypss injection");
        SeleniumServer.printWrappedErrorLine(INDENT2X, "-userJsInjection <file>: specifies a JavaScript file which will then be injected into all pages");
        SeleniumServer.printWrappedErrorLine(INDENT2X, "-userContentTransformation <regex> <replacement>: a regular expression which is matched against all test HTML content; the second is a string which will replace matches.  These flags can be used any number of times.  A simple example of how this could be useful: if you add \"-userContentTransformation https http\" then all \"https\" strings in the HTML of the test application will be changed to be \"http\".");
    }

    private static void printWrappedErrorLine(String prefix, String msg) {
        SeleniumServer.printWrappedErrorLine(prefix, msg, true);
    }

    private static void printWrappedErrorLine(String prefix, String msg, boolean first) {
        int defaultWrap;
        int wrap;
        System.err.print(prefix);
        if (!first) {
            System.err.print("  ");
        }
        if ((wrap = (defaultWrap = 70) - prefix.length()) > msg.length()) {
            System.err.println(msg);
            return;
        }
        String lineRaw = msg.substring(0, wrap);
        int spaceIndex = lineRaw.lastIndexOf(32);
        if (spaceIndex == -1) {
            spaceIndex = lineRaw.length();
        }
        String line = lineRaw.substring(0, spaceIndex);
        System.err.println(line);
        SeleniumServer.printWrappedErrorLine(prefix, msg.substring(spaceIndex + 1), false);
    }

    public SeleniumServer(int port, boolean slowResources, boolean multiWindow) throws Exception {
        SeleniumServer.configureLogging();
        log.info("Java: " + System.getProperty("java.vm.vendor") + ' ' + System.getProperty("java.vm.version"));
        log.info("OS: " + System.getProperty("os.name") + ' ' + System.getProperty("os.version") + ' ' + System.getProperty("os.arch"));
        SeleniumServer.logVersionNumber();
        if (debugMode) {
            log.info("Selenium server running in debug mode.");
        }
        if (proxyInjectionMode) {
            log.info("The selenium server will execute in proxyInjection mode.");
        }
        if (SeleniumServer.reusingBrowserSessions()) {
            log.info("Will recycle browser sessions when possible.");
        }
        if (forcedBrowserMode != null) {
            log.info("\"" + forcedBrowserMode + "\" will be used as the browser " + "mode for all sessions, no matter what is passed to getNewBrowserSession.");
        }
        this.port = port;
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (Integer.toString(port).equals(proxyPort)) {
            log.debug("http.proxyPort is the same as the Selenium Server port " + port);
            log.debug("http.proxyHost=" + proxyHost);
            if ("localhost".equals(proxyHost) || "127.0.0.1".equals(proxyHost)) {
                log.info("Forcing http.proxyHost to '' to avoid infinite loop");
                System.setProperty("http.proxyHost", "");
            }
        }
        if (portDriversShouldContact == 0) {
            SeleniumServer.setPortDriversShouldContact(port);
        }
        this.multiWindow = multiWindow;
        this.server = new Server();
        SocketListener socketListener = new SocketListener();
        socketListener.setMaxIdleTimeMs(60000);
        socketListener.setMaxThreads(jettyThreads);
        socketListener.setPort(port);
        this.server.addListener(socketListener);
        this.configServer();
        this.assembleHandlers(slowResources);
    }

    public static synchronized void configureLogging() {
        if (dontTouchLogging) {
            log = LogFactory.getLog(SeleniumServer.class);
            return;
        }
        Logger logger = Logger.getLogger("");
        SeleniumServer.resetLogger();
        for (Handler handler : logger.getHandlers()) {
            Formatter formatter;
            if (!(handler instanceof ConsoleHandler) || !((formatter = handler.getFormatter()) instanceof SimpleFormatter)) continue;
            Level originalLevel = handler.getLevel();
            handler.setFormatter(new TerseFormatter(false));
            handler.setLevel(Level.WARNING);
            StdOutHandler stdOutHandler = new StdOutHandler();
            stdOutHandler.setFormatter(new TerseFormatter(false));
            stdOutHandler.setFilter(new MaxLevelFilter(Level.INFO));
            stdOutHandler.setLevel(originalLevel);
            logger.addHandler(stdOutHandler);
            if (!SeleniumServer.isDebugMode() || originalLevel.intValue() <= Level.FINE.intValue()) continue;
            stdOutHandler.setLevel(Level.FINE);
        }
        if (SeleniumServer.isDebugMode()) {
            logger.setLevel(Level.FINE);
        }
        log = LogFactory.getLog(SeleniumServer.class);
        if (logOutFileName == null && System.getProperty("selenium.log") != null) {
            logOutFileName = System.getProperty("selenium.log");
        }
        if (logOutFileName != null) {
            try {
                File logFile = new File(logOutFileName);
                FileHandler fileHandler = seleniumFileHandlers.get(logFile);
                if (fileHandler == null) {
                    fileHandler = new FileHandler(logFile.getAbsolutePath());
                    seleniumFileHandlers.put(logFile, fileHandler);
                }
                fileHandler.setFormatter(new TerseFormatter(true));
                logger.setLevel(Level.FINE);
                fileHandler.setLevel(Level.FINE);
                logger.addHandler(fileHandler);
                log.info("Writing debug logs to " + logFile.getAbsolutePath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void logVersionNumber() throws IOException {
        InputStream stream = SeleniumServer.class.getResourceAsStream("/VERSION.txt");
        if (stream == null) {
            log.error("Couldn't determine version number");
            return;
        }
        Properties p = new Properties();
        p.load(stream);
        String rcVersion = p.getProperty("selenium.rc.version");
        String rcRevision = p.getProperty("selenium.rc.revision");
        String coreVersion = p.getProperty("selenium.core.version");
        String coreRevision = p.getProperty("selenium.core.revision");
        log.info("v" + rcVersion + " [" + rcRevision + "], with Core v" + coreVersion + " [" + coreRevision + "]");
    }

    private static void resetLogger() {
        Logger logger = Logger.getLogger("");
        if (defaultHandlers == null) {
            defaultHandlers = logger.getHandlers();
            defaultFormatters = new HashMap<Handler, Formatter>();
            defaultLevels = new HashMap<Handler, Level>();
            for (Handler handler : defaultHandlers) {
                defaultFormatters.put(handler, handler.getFormatter());
                defaultLevels.put(handler, handler.getLevel());
            }
        } else {
            for (Handler handler : logger.getHandlers()) {
                logger.removeHandler(handler);
            }
            for (Handler handler : defaultHandlers) {
                logger.addHandler(handler);
                handler.setFormatter(defaultFormatters.get(handler));
                handler.setLevel(defaultLevels.get(handler));
            }
        }
    }

    public SeleniumServer(int port, boolean slowResources) throws Exception {
        this(port, slowResources, false);
    }

    private void assembleHandlers(boolean slowResources) {
        ProxyHandler proxyHandler;
        HttpContext root = new HttpContext();
        root.setContextPath("/");
        if (customProxyHandler == null) {
            proxyHandler = new ProxyHandler();
            root.addHandler(proxyHandler);
        } else {
            proxyHandler = customProxyHandler;
            root.addHandler(proxyHandler);
        }
        if (browserSideLogEnabled) {
            proxyHandler.generateSSLCertsForLoggingHosts(this.server);
        }
        this.server.addContext(root);
        HttpContext context = new HttpContext();
        context.setContextPath("/selenium-server");
        context.setMimeMapping("xhtml", "application/xhtml+xml");
        SecurityConstraint constraint = new SecurityConstraint();
        constraint.setName("BASIC");
        constraint.addRole("user");
        constraint.setAuthenticate(true);
        context.addSecurityConstraint("/tests/html/basicAuth/*", constraint);
        HashUserRealm realm = new HashUserRealm("MyRealm");
        realm.put("alice", "foo");
        realm.addUserToRole("alice", "user");
        context.setRealm(realm);
        SecurityHandler sh = new SecurityHandler();
        context.addHandler(sh);
        StaticContentHandler.setSlowResources(slowResources);
        this.staticContentHandler = new StaticContentHandler();
        String overrideJavascriptDir = System.getProperty("selenium.javascript.dir");
        if (overrideJavascriptDir != null) {
            this.staticContentHandler.addStaticContent(new FsResourceLocator(new File(overrideJavascriptDir)));
        }
        this.staticContentHandler.addStaticContent(new ClasspathResourceLocator());
        context.addHandler(this.staticContentHandler);
        context.addHandler(new SingleTestSuiteResourceHandler());
        this.postResultsHandler = new SeleniumHTMLRunnerResultsHandler();
        context.addHandler(this.postResultsHandler);
        HttpContext driverContext = new HttpContext();
        driverContext.setContextPath("/selenium-server/driver");
        this.driver = new SeleniumDriverResourceHandler(this);
        context.addHandler(this.driver);
        this.server.addContext(context);
        this.server.addContext(driverContext);
    }

    private void configServer() {
        if (SeleniumServer.getForcedBrowserMode() == null) {
            if (null != System.getProperty("selenium.defaultBrowserString")) {
                System.err.println("The selenium.defaultBrowserString property is no longer supported; use selenium.forcedBrowserMode instead.");
                System.exit(-1);
            }
            SeleniumServer.setForcedBrowserMode(System.getProperty("selenium.forcedBrowserMode"));
        }
        if (!SeleniumServer.isProxyInjectionMode() && System.getProperty("selenium.proxyInjectionMode") != null) {
            this.setProxyInjectionMode("true".equals(System.getProperty("selenium.proxyInjectionMode")));
        }
        if (!SeleniumServer.isDebugMode() && System.getProperty("selenium.debugMode") != null) {
            SeleniumServer.setDebugMode("true".equals(System.getProperty("selenium.debugMode")));
        }
        if (!SeleniumServer.isBrowserSideLogEnabled() && System.getProperty("selenium.browserSideLog") != null) {
            SeleniumServer.setBrowserSideLogEnabled("true".equals(System.getProperty("selenium.browserSideLog")));
        }
    }

    public SeleniumServer(int port) throws Exception {
        this(port, SeleniumServer.slowResourceProperty());
    }

    public SeleniumServer() throws Exception {
        this(SeleniumServer.getDefaultPort(), SeleniumServer.slowResourceProperty());
    }

    public static int getDefaultPort() {
        String portString = System.getProperty("selenium.port", "4444");
        return Integer.parseInt(portString);
    }

    public static File getFirefoxProfileTemplate() {
        return firefoxProfileTemplate;
    }

    public static void setFirefoxProfileTemplate(File template) {
        firefoxProfileTemplate = template;
    }

    private static boolean slowResourceProperty() {
        return "true".equals(System.getProperty("slowResources"));
    }

    public static void setTimeoutInSeconds(int timeoutInSeconds) {
        SeleniumServer.timeoutInSeconds = timeoutInSeconds;
    }

    public void addNewStaticContent(File directory) {
        this.staticContentHandler.addStaticContent(new FsResourceLocator(directory));
    }

    public void handleHTMLRunnerResults(HTMLResultsListener listener) {
        this.postResultsHandler.addListener(listener);
    }

    public void start() throws Exception {
        System.setProperty("org.mortbay.http.HttpRequest.maxFormContentSize", "0");
        this.server.start();
        this.shutDownHook = new Thread(new ShutDownHook(this));
        this.shutDownHook.setName("SeleniumServerShutDownHook");
        Runtime.getRuntime().addShutdownHook(this.shutDownHook);
    }

    public static boolean isForceProxyChain() {
        return FORCE_PROXY_CHAIN;
    }

    public static void setForceProxyChain(boolean force) {
        FORCE_PROXY_CHAIN = force;
    }

    public static void setCustomProxyHandler(ProxyHandler customProxyHandler) {
        SeleniumServer.customProxyHandler = customProxyHandler;
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.driver.stopAllBrowsers();
            try {
                if (this.shutDownHook != null) {
                    Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
                }
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    public Map<String, BrowserLauncher> getBrowserLaunchers() {
        return this.driver.getLaunchers();
    }

    public int getPort() {
        return this.port;
    }

    public boolean isMultiWindow() {
        return this.multiWindow;
    }

    public Server getServer() {
        return this.server;
    }

    public InputStream getResourceAsStream(String path) throws IOException {
        return this.staticContentHandler.getResource(path).getInputStream();
    }

    public void registerBrowserLauncher(String sessionId, BrowserLauncher launcher) {
        this.driver.registerBrowserLauncher(sessionId, launcher);
    }

    public static int getJettyThreads() {
        return jettyThreads;
    }

    public static void setJettyThreads(int jettyThreads) {
        if (jettyThreads < 1 || jettyThreads > 1024) {
            throw new IllegalArgumentException("Number of jetty threads specified as an argument must be greater than zero and less than 1024");
        }
        SeleniumServer.jettyThreads = jettyThreads;
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static boolean isBrowserSideLogEnabled() {
        return browserSideLogEnabled;
    }

    public static void setDebugMode(boolean debugMode) {
        SeleniumServer.debugMode = debugMode;
    }

    public static void setBrowserSideLogEnabled(boolean browserSideLogEnabled) {
        SeleniumServer.browserSideLogEnabled = browserSideLogEnabled;
    }

    public static boolean isProxyInjectionMode() {
        return proxyInjectionMode;
    }

    @Deprecated
    public static void setAlwaysProxy(boolean alwaysProxy) {
        SeleniumServer.setAvoidProxy(!alwaysProxy);
    }

    public static void setAvoidProxy(boolean avoidProxy) {
        SeleniumServer.avoidProxy = avoidProxy;
    }

    @Deprecated
    public static boolean isAlwaysProxy() {
        return !SeleniumServer.isAvoidProxy();
    }

    public static boolean isAvoidProxy() {
        return avoidProxy;
    }

    public static int getPortDriversShouldContact() {
        return portDriversShouldContact;
    }

    private static void setPortDriversShouldContact(int port) {
        portDriversShouldContact = port;
    }

    public void setProxyInjectionMode(boolean proxyInjectionMode) {
        SeleniumServer.proxyInjectionMode = proxyInjectionMode;
    }

    public static String getForcedBrowserMode() {
        return forcedBrowserMode;
    }

    public static int getTimeoutInSeconds() {
        return timeoutInSeconds;
    }

    public static void setForcedBrowserMode(String s) {
        forcedBrowserMode = s;
    }

    public static void setDontInjectRegex(String dontInjectRegex) {
        SeleniumServer.dontInjectRegex = dontInjectRegex;
    }

    public static void setDontTouchLogging(boolean dontTouchLogging) {
        SeleniumServer.dontTouchLogging = dontTouchLogging;
    }

    public static boolean reusingBrowserSessions() {
        if (reusingBrowserSessions == null) {
            reusingBrowserSessions = Boolean.FALSE;
        }
        return reusingBrowserSessions;
    }

    public static boolean shouldInject(String path) {
        if (dontInjectRegex == null) {
            return true;
        }
        return !path.matches(dontInjectRegex);
    }

    public static String getDebugURL() {
        return debugURL;
    }

    private static String getRequiredSystemProperty(String name) {
        String value = System.getProperty(name);
        if (value == null) {
            SeleniumServer.usage("expected property " + name + " to be defined");
            System.exit(1);
        }
        return value;
    }

    private static void runHtmlSuite(SeleniumServer seleniumProxy) {
        String result = null;
        try {
            String suiteFilePath = SeleniumServer.getRequiredSystemProperty("htmlSuite.suiteFilePath");
            File suiteFile = new File(suiteFilePath);
            if (!suiteFile.exists()) {
                SeleniumServer.usage("Can't find HTML Suite file:" + suiteFile.getAbsolutePath());
                System.exit(1);
            }
            seleniumProxy.addNewStaticContent(suiteFile.getParentFile());
            String startURL = SeleniumServer.getRequiredSystemProperty("htmlSuite.startURL");
            HTMLLauncher launcher = new HTMLLauncher(seleniumProxy);
            String resultFilePath = SeleniumServer.getRequiredSystemProperty("htmlSuite.resultFilePath");
            File resultFile = new File(resultFilePath);
            resultFile.createNewFile();
            if (!resultFile.canWrite()) {
                SeleniumServer.usage("can't write to result file " + resultFilePath);
                System.exit(1);
            }
            if (!"PASSED".equals(result = launcher.runHTMLSuite(SeleniumServer.getRequiredSystemProperty("htmlSuite.browserString"), startURL, suiteFile, resultFile, timeoutInSeconds, seleniumProxy.isMultiWindow()))) {
                System.err.println("Tests failed, see result file for details: " + resultFile.getAbsolutePath());
                System.exit(1);
            } else {
                System.exit(0);
            }
        }
        catch (Exception e) {
            System.err.println("HTML suite exception seen:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void setReusingBrowserSessions(boolean reusingBrowserSessions) {
        SeleniumServer.reusingBrowserSessions = reusingBrowserSessions;
    }

    static {
        debugURL = "";
        browserSideLogEnabled = false;
        avoidProxy = false;
        proxyInjectionMode = false;
        firefoxProfileTemplate = null;
        seleniumFileHandlers = new HashMap<File, FileHandler>();
        portDriversShouldContact = 0;
        logOutFileName = null;
        forcedBrowserMode = null;
        timeoutInSeconds = 1800;
        jettyThreads = 512;
        reusingBrowserSessions = null;
        dontInjectRegex = null;
        FORCE_PROXY_CHAIN = false;
        debugMode = false;
        dontTouchLogging = false;
    }

    private class ShutDownHook
    implements Runnable {
        SeleniumServer selenium;

        ShutDownHook(SeleniumServer selenium) {
            this.selenium = selenium;
        }

        public void run() {
            log.info("Shutting down...");
            this.selenium.stop();
        }
    }
}

