/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.regex.Pattern;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;

public class OperaCustomProfileLauncher
implements BrowserLauncher {
    private static final String DEFAULT_NONWINDOWS_LOCATION = "/Applications/Opera.app/Contents/MacOS/opera";
    private static boolean simple = false;
    private int port;
    private String sessionId;
    private File customProfileDir;
    private String[] cmdarray;
    private boolean closed = false;
    private String commandPath;
    private Process process;
    private static AsyncExecute exe = new AsyncExecute();
    static final Pattern JAVA_STYLE_UNC_URL = Pattern.compile("^file:////([^/]+/.*)$");
    static final Pattern JAVA_STYLE_LOCAL_URL = Pattern.compile("^file:/([A-Z]:/.*)$");

    public OperaCustomProfileLauncher(int port, String sessionId) {
        this(port, sessionId, OperaCustomProfileLauncher.findBrowserLaunchLocation());
    }

    public OperaCustomProfileLauncher(int port, String sessionId, String browserLaunchLocation) {
        this.commandPath = browserLaunchLocation;
        this.port = port;
        this.sessionId = sessionId;
        if (!WindowsUtils.thisIsWindows()) {
            File execDirect;
            File operaBin = AsyncExecute.whichExec(this.commandPath);
            if (operaBin == null && (execDirect = new File(this.commandPath)).isAbsolute() && execDirect.exists()) {
                operaBin = execDirect;
            }
            if (operaBin != null) {
                String libPathKey = OperaCustomProfileLauncher.getLibPathKey();
                String libPath = WindowsUtils.loadEnvironment().getProperty(libPathKey);
                exe.setEnvironment(new String[]{"MOZ_NO_REMOTE=1", libPathKey + "=" + libPath + ":" + operaBin.getParent()});
            }
        }
    }

    private static String getLibPathKey() {
        if (WindowsUtils.thisIsWindows()) {
            return WindowsUtils.getExactPathEnvKey();
        }
        if (Os.isFamily("mac")) {
            return "DYLD_LIBRARY_PATH";
        }
        return "LD_LIBRARY_PATH";
    }

    private static String findBrowserLaunchLocation() {
        File defaultLocation;
        String defaultPath = System.getProperty("operaDefaultPath");
        if (defaultPath == null) {
            defaultPath = WindowsUtils.thisIsWindows() ? WindowsUtils.getProgramFilesPath() + "\\Opera\\opera.exe" : DEFAULT_NONWINDOWS_LOCATION;
        }
        if ((defaultLocation = new File(defaultPath)).exists()) {
            return defaultLocation.getAbsolutePath();
        }
        if (WindowsUtils.thisIsWindows()) {
            File operaEXE = AsyncExecute.whichExec("opera.exe");
            if (operaEXE != null) {
                return operaEXE.getAbsolutePath();
            }
            throw new RuntimeException("Opera couldn't be found in the path!\nPlease add the directory containing opera.exe to your PATH environment\nvariable, or explicitly specify a path to Opera like this:\n*opera c:\\blah\\opera.exe");
        }
        File operaBin = AsyncExecute.whichExec("opera");
        if (operaBin != null) {
            return operaBin.getAbsolutePath();
        }
        throw new RuntimeException("Opera couldn't be found in the path!\nPlease add the directory containing 'opera' to your PATH environment\nvariable, or explicitly specify a path to Opera like this:\n*opera /blah/blah/opera");
    }

    public void launch(String url) {
        try {
            File opera6ini = this.makeCustomProfile();
            System.out.println("Launching Opera...");
            this.cmdarray = WindowsUtils.thisIsWindows() ? new String[]{this.commandPath, "/settings", opera6ini.getAbsolutePath(), url} : new String[]{this.commandPath, "-personaldir", opera6ini.getParentFile().getAbsolutePath(), url};
            exe.setCommandline(this.cmdarray);
            this.process = exe.asyncSpawn();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File makeCustomProfile() throws IOException {
        this.customProfileDir = LauncherUtils.createCustomProfileDir(this.sessionId);
        if (simple) {
            return this.customProfileDir;
        }
        File proxyPAC = LauncherUtils.makeProxyPAC(this.customProfileDir, this.port);
        File opera6ini = new File(this.customProfileDir, "opera6.ini");
        PrintStream out = new PrintStream(new FileOutputStream(opera6ini));
        out.println("[Proxy]");
        out.println("HTTP server=localhost:" + this.port);
        out.println("Enable HTTP 1.1 for proxy=1");
        out.println("Use Proxy On Local Names Check=1");
        out.println("Use HTTP=1");
        out.println("Use HTTPS=0");
        out.println("Use FTP=0");
        out.println("Use GOPHER=0");
        out.println("Use WAIS=0");
        out.println("Use Automatic Proxy Configuration=0");
        out.println("HTTPS server=localhost:" + this.port);
        out.println("FTP server=localhost:" + this.port);
        out.println("Gopher server=localhost:" + this.port);
        out.println("WAIS server");
        out.println("Automatic Proxy Configuration URL=" + proxyPAC.getAbsolutePath());
        out.println("No Proxy Servers");
        out.println("No Proxy Servers Check=0");
        out.println("");
        out.println("[State]");
        out.println("Run=0");
        out.println("[User Prefs]");
        out.println("Opera Directory=" + this.customProfileDir.getAbsolutePath());
        out.println("Shown First Time Setup=1");
        out.println("One Time Page=");
        out.println("Show Setupdialog On Start=0");
        out.println("Enable Wand=0");
        out.println("Ignore Unrequested Popups=0");
        out.println("Show Default Browser Dialog=0");
        out.println("Startup Type=4");
        out.println("[Install]");
        out.println("HELLO=NO");
        out.close();
        return opera6ini;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        System.out.println("Killing Opera...");
        Throwable taskKillException = null;
        FileLockRemainedException fileLockException = null;
        this.process.destroy();
        int exitValue = AsyncExecute.waitForProcessDeath(this.process, 10000L);
        if (exitValue == 0) {
            System.err.println("WARNING: Opera seems to have ended on its own (did we kill the real browser???)");
        }
        try {
            this.waitForFileLockToGoAway(0L, 500L);
        }
        catch (FileLockRemainedException e1) {
            fileLockException = e1;
        }
        try {
            LauncherUtils.deleteTryTryAgain(this.customProfileDir, 6);
        }
        catch (RuntimeException e) {
            if (taskKillException != null || fileLockException != null) {
                e.printStackTrace();
                System.err.print("Perhaps caused by: ");
                if (taskKillException != null) {
                    taskKillException.printStackTrace();
                }
                if (fileLockException != null) {
                    fileLockException.printStackTrace();
                }
                throw new RuntimeException("Couldn't delete custom Opera profile directory, presumably because task kill failed; see stderr!", e);
            }
            throw e;
        }
        this.closed = true;
    }

    private void waitForFileLockToGoAway(long timeout, long timeToWait) throws FileLockRemainedException {
        File lock = new File(this.customProfileDir, "parent.lock");
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeout) {
            AsyncExecute.sleepTight(500L);
            if (lock.exists() || !this.makeSureFileLockRemainsGone(lock, timeToWait)) continue;
            return;
        }
        if (lock.exists()) {
            throw new FileLockRemainedException("Lock file still present! " + lock.getAbsolutePath());
        }
    }

    private boolean makeSureFileLockRemainsGone(File lock, long timeToWait) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeToWait) {
            AsyncExecute.sleepTight(500L);
            if (!lock.exists()) continue;
            return false;
        }
        return !lock.exists();
    }

    public static void main(String[] args) throws Exception {
        OperaCustomProfileLauncher l = new OperaCustomProfileLauncher(4444, "CUSTFF");
        l.launch("http://www.google.com");
        int seconds = 15;
        System.out.println("Killing browser in " + Integer.toString(seconds) + " seconds");
        AsyncExecute.sleepTight(seconds * 1000);
        l.close();
        System.out.println("He's dead now, right?");
    }

    public void launchHTMLSuite(String suiteUrl, String browserURL) {
        this.launch(LauncherUtils.getDefaultHTMLSuiteUrl(browserURL, suiteUrl));
    }

    public void launchRemoteSession(String browserURL) {
        this.launch(LauncherUtils.getDefaultRemoteSessionUrl(browserURL, this.sessionId));
    }

    private class FileLockRemainedException
    extends Exception {
        FileLockRemainedException(String message) {
            super(message);
        }
    }
}

