/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.servlet;

import java.util.Arrays;

public class MissingParameterException
extends RuntimeException {
    private static final long serialVersionUID = -3100193382920197884L;
    protected String missingParameter;
    protected String[] requiredParameters;

    public MissingParameterException(String missingParameter) {
        this(missingParameter, new String[]{missingParameter});
    }

    public MissingParameterException(String missingParameter, String[] requiredParameters) {
        if (missingParameter == null || requiredParameters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        this.missingParameter = missingParameter;
        this.requiredParameters = Arrays.copyOf(requiredParameters, requiredParameters.length);
    }

    public String getMissingParameter() {
        return this.missingParameter;
    }

    public String[] getRequiredParameters() {
        return this.requiredParameters;
    }

    @Override
    public String getMessage() {
        StringBuilder b = new StringBuilder();
        b.append("Missing parameter \"" + this.getMissingParameter() + "\" out of required parameters: ");
        String[] requiredParameters = this.getRequiredParameters();
        for (int i = 0; i < requiredParameters.length; ++i) {
            if (i != 0) {
                b.append(", ");
            }
            b.append(requiredParameters[i]);
        }
        return b.toString();
    }
}

