/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.sample;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.CompletableFuture;
import org.opennms.integration.api.v1.pollers.PollerRequest;
import org.opennms.integration.api.v1.pollers.PollerResult;
import org.opennms.integration.api.v1.pollers.ServicePoller;
import org.opennms.integration.api.v1.pollers.Status;
import org.opennms.integration.api.v1.pollers.immutables.ImmutablePollerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamplePoller
implements ServicePoller {
    private static final Logger LOG = LoggerFactory.getLogger(SamplePoller.class);

    public CompletableFuture<PollerResult> poll(PollerRequest pollerRequest) {
        CompletableFuture<PollerResult> future = new CompletableFuture<PollerResult>();
        try {
            if (pollerRequest.getAddress().equals(InetAddress.getLocalHost())) {
                LOG.info("{} service is Up", (Object)pollerRequest.getServiceName());
                future.complete((PollerResult)ImmutablePollerResult.newBuilder().setStatus(Status.Up).build());
                return future;
            }
        }
        catch (UnknownHostException e) {
            future.completeExceptionally(e);
            return future;
        }
        future.complete((PollerResult)ImmutablePollerResult.newBuilder().setStatus(Status.Down).setReason("unknown address, sample works on localhost").build());
        return future;
    }
}

