/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.operations;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.openjdk.jol.Operation;
import org.openjdk.jol.heap.HeapDumpReader;
import org.openjdk.jol.info.ClassData;
import org.openjdk.jol.info.FieldData;
import org.openjdk.jol.util.Multiset;

public class ObjectShapes
implements Operation {
    @Override
    public String label() {
        return "shapes";
    }

    @Override
    public String description() {
        return "Dump the object shapes present in JAR files or heap dumps.";
    }

    @Override
    public void run(String ... args) throws Exception {
        if (args.length == 0) {
            System.err.println("Expected one or more JAR/heapdump file names.");
            System.exit(1);
        }
        ExecutorService threadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ExecutorCompletionService<Multiset<String>> cs = new ExecutorCompletionService<Multiset<String>>(threadPool);
        for (final String arg : args) {
            if (arg.endsWith(".jar")) {
                cs.submit(new Callable<Multiset<String>>(){

                    @Override
                    public Multiset<String> call() throws Exception {
                        return ObjectShapes.this.processJAR(arg);
                    }
                });
            }
            if (!arg.endsWith(".dump") && !arg.endsWith("hprof") && !arg.endsWith("hprof.gz")) continue;
            cs.submit(new Callable<Multiset<String>>(){

                @Override
                public Multiset<String> call() throws Exception {
                    return ObjectShapes.this.processHeapDump(arg);
                }
            });
        }
        Multiset shapes = new Multiset();
        for (String arg : args) {
            Multiset ms = (Multiset)cs.take().get();
            shapes.merge(ms);
        }
        threadPool.shutdown();
        for (String key : shapes.keys()) {
            System.out.printf("%d\t%s%n", shapes.count((Object)key), key);
        }
    }

    private Multiset<String> processHeapDump(String arg) {
        Multiset shapes = new Multiset();
        try {
            HeapDumpReader reader = new HeapDumpReader(new File(arg));
            Multiset data = reader.parse();
            for (ClassData cd : data.keys()) {
                String shape = this.parseClassData(cd);
                shapes.add((Object)shape, data.count((Object)cd));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return shapes;
    }

    private Multiset<String> processJAR(String jarName) {
        Multiset shapes = new Multiset();
        try {
            URLClassLoader cl = URLClassLoader.newInstance(new URL[]{new URL("jar:file:" + jarName + "!/")});
            JarFile jarFile = new JarFile(jarName);
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry je = e.nextElement();
                String name = je.getName();
                if (je.isDirectory() || !name.endsWith(".class")) continue;
                String className = name.substring(0, name.length() - 6).replace('/', '.');
                try {
                    Class<?> klass = cl.loadClass(className);
                    ClassData cd = ClassData.parseClass(klass);
                    String shape = this.parseClassData(cd);
                    shapes.add((Object)shape);
                }
                catch (Error klass) {
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            jarFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return shapes;
    }

    private String parseClassData(ClassData cd) {
        StringBuilder sb = new StringBuilder();
        for (String cn : cd.classHierarchy()) {
            for (FieldData fd : cd.fieldsFor(cn)) {
                sb.append(ObjectShapes.toTypeLabel(fd.typeClass()));
            }
            sb.append("|");
        }
        if (sb.length() == 0) {
            sb.append("|");
        }
        if (sb.charAt(0) != '|') {
            sb.insert(0, '|');
        }
        return sb.toString();
    }

    private static char toTypeLabel(String s) {
        if ("boolean".equals(s)) {
            return 'Z';
        }
        if ("byte".equals(s)) {
            return 'B';
        }
        if ("char".equals(s)) {
            return 'C';
        }
        if ("short".equals(s)) {
            return 'S';
        }
        if ("int".equals(s)) {
            return 'I';
        }
        if ("float".equals(s)) {
            return 'F';
        }
        if ("long".equals(s)) {
            return 'L';
        }
        if ("double".equals(s)) {
            return 'D';
        }
        return 'L';
    }
}

