/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol;

import java.util.Arrays;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openjdk.jol.Operation;
import org.openjdk.jol.operations.HeapDump;
import org.openjdk.jol.operations.ObjectEstimates;
import org.openjdk.jol.operations.ObjectExternals;
import org.openjdk.jol.operations.ObjectFootprint;
import org.openjdk.jol.operations.ObjectIdealPacking;
import org.openjdk.jol.operations.ObjectInternals;
import org.openjdk.jol.operations.StringCompress;

public class Main {
    private static SortedMap<String, Operation> operations = new TreeMap<String, Operation>();

    private static void registerOperation(Operation op) {
        operations.put(op.label(), op);
    }

    public static void main(String ... args) throws Exception {
        String mode;
        Operation op;
        if (args.length < 1) {
            System.err.println("Usage: jol-cli.jar <mode> [optional arguments]*");
            System.err.println("  Use mode \"help\" to get the list of available modes.");
            System.exit(1);
        }
        if ((op = (Operation)operations.get(mode = args[0])) != null) {
            String[] modeArgs = Arrays.copyOfRange(args, 1, args.length);
            op.run(modeArgs);
        } else {
            System.out.println("Available modes: ");
            for (Operation lop : operations.values()) {
                System.out.printf("  %20s: %s%n", lop.label(), lop.description());
            }
            if (!mode.equals("help")) {
                System.err.println("Unknown mode: " + mode);
                System.exit(1);
            } else {
                System.exit(0);
            }
        }
    }

    static {
        Main.registerOperation(new ObjectInternals());
        Main.registerOperation(new ObjectExternals());
        Main.registerOperation(new ObjectEstimates());
        Main.registerOperation(new ObjectFootprint());
        Main.registerOperation(new ObjectIdealPacking());
        Main.registerOperation(new StringCompress());
        Main.registerOperation(new HeapDump());
    }
}

