/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.operations;

import org.openjdk.jol.datamodel.DataModel;
import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.layouters.HotSpotLayouter;
import org.openjdk.jol.layouters.Layouter;
import org.openjdk.jol.operations.ClasspathedOperation;
import org.openjdk.jol.operations.EstimatedModels;

public class ObjectEstimates
extends ClasspathedOperation {
    @Override
    public String label() {
        return "estimates";
    }

    @Override
    public String description() {
        return "Simulate the class layout in different VM modes.";
    }

    @Override
    protected void runWith(Class<?> klass) {
        HotSpotLayouter l;
        for (DataModel model : EstimatedModels.MODELS_JDK8) {
            l = new HotSpotLayouter(model, 8);
            System.out.println("***** " + l);
            System.out.println(ClassLayout.parseClass(klass, (Layouter)l).toPrintable());
        }
        for (DataModel model : EstimatedModels.MODELS_JDK8) {
            l = new HotSpotLayouter(model, 15);
            System.out.println("***** " + l);
            System.out.println(ClassLayout.parseClass(klass, (Layouter)l).toPrintable());
        }
        for (DataModel model : EstimatedModels.MODELS_JDK15) {
            l = new HotSpotLayouter(model, 15);
            System.out.println("***** " + l);
            System.out.println(ClassLayout.parseClass(klass, (Layouter)l).toPrintable());
        }
        for (DataModel model : EstimatedModels.MODELS_LILLIPUT) {
            l = new HotSpotLayouter(model, 99);
            System.out.println("***** " + l);
            System.out.println(ClassLayout.parseClass(klass, (Layouter)l).toPrintable());
        }
    }
}

