/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.operations;

import java.io.FileNotFoundException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.openjdk.jol.Operation;
import org.openjdk.jol.datamodel.CurrentDataModel;
import org.openjdk.jol.datamodel.DataModel;
import org.openjdk.jol.info.ClassData;
import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.layouters.CurrentLayouter;
import org.openjdk.jol.layouters.HotSpotLayouter;
import org.openjdk.jol.layouters.RawLayouter;

public class ObjectIdealPacking
implements Operation {
    @Override
    public String label() {
        return "idealpack";
    }

    @Override
    public String description() {
        return "Compute the object footprint under different field layout strategies.";
    }

    @Override
    public void run(String ... args) throws Exception {
        if (args.length == 0) {
            System.err.println("Expected one or more JAR file names.");
            System.exit(1);
        }
        CurrentDataModel model = new CurrentDataModel();
        for (String jarName : args) {
            try {
                System.err.println("Parsing " + jarName);
                URLClassLoader cl = URLClassLoader.newInstance(new URL[]{new URL("jar:file:" + jarName + "!/")});
                JarFile jarFile = new JarFile(jarName);
                Enumeration<JarEntry> e = jarFile.entries();
                while (e.hasMoreElements()) {
                    JarEntry je = e.nextElement();
                    String name = je.getName();
                    if (je.isDirectory() || !name.endsWith(".class")) continue;
                    String className = name.substring(0, name.length() - 6).replace('/', '.');
                    try {
                        boolean[] BOOLS;
                        Class<?> klass = cl.loadClass(className);
                        ClassData cd = ClassData.parseClass(klass);
                        ClassLayout raw = new RawLayouter((DataModel)model).layout(cd);
                        ClassLayout vm = new CurrentLayouter().layout(cd);
                        System.out.printf("%3d, %3d, %3d, ", model.headerSize(), raw.instanceSize(), vm.instanceSize());
                        for (boolean hierarchyGaps : BOOLS = new boolean[]{false, true}) {
                            for (boolean superClassGaps : BOOLS) {
                                for (boolean autoAlign : BOOLS) {
                                    for (boolean compactFields : BOOLS) {
                                        for (int fieldAllocationStyle : new int[]{0, 1, 2}) {
                                            ClassLayout l = new HotSpotLayouter((DataModel)model, hierarchyGaps, superClassGaps, autoAlign, compactFields, fieldAllocationStyle).layout(cd);
                                            System.out.printf("%3d, ", l.instanceSize());
                                        }
                                    }
                                }
                            }
                        }
                        System.out.printf("%s%n", klass.getName());
                    }
                    catch (ClassFormatError | ClassNotFoundException | IncompatibleClassChangeError | NoClassDefFoundError | SecurityException | VerifyError klass) {
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                jarFile.close();
            }
            catch (FileNotFoundException | ZipException iOException) {
                // empty catch block
            }
        }
    }
}

