/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol;

import java.io.FileNotFoundException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.openjdk.jol.datamodel.CurrentDataModel;
import org.openjdk.jol.datamodel.DataModel;
import org.openjdk.jol.info.ClassData;
import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.layouters.CurrentLayouter;
import org.openjdk.jol.layouters.HotSpotLayouter;
import org.openjdk.jol.layouters.RawLayouter;

public class MainObjectIdealPacking {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Usage: jol-idealpack.jar [jar-name]*");
            System.exit(1);
        }
        CurrentDataModel model = new CurrentDataModel();
        for (String jarName : args) {
            try {
                System.err.println("Parsing " + jarName);
                URLClassLoader cl = URLClassLoader.newInstance(new URL[]{new URL("jar:file:" + jarName + "!/")});
                JarFile jarFile = new JarFile(jarName);
                Enumeration<JarEntry> e = jarFile.entries();
                while (e.hasMoreElements()) {
                    JarEntry je = e.nextElement();
                    String name = je.getName();
                    if (je.isDirectory() || !name.endsWith(".class")) continue;
                    String className = name.substring(0, name.length() - 6).replace('/', '.');
                    try {
                        Class<?> klass = cl.loadClass(className);
                        ClassData cd = ClassData.parseClass(klass);
                        ClassLayout raw = new RawLayouter((DataModel)model).layout(cd);
                        ClassLayout vm = new CurrentLayouter().layout(cd);
                        ClassLayout hsDefault_m = new HotSpotLayouter((DataModel)model, false, false, false).layout(cd);
                        ClassLayout hsHier_m = new HotSpotLayouter((DataModel)model, true, false, false).layout(cd);
                        ClassLayout hsSuper_m = new HotSpotLayouter((DataModel)model, true, true, false).layout(cd);
                        ClassLayout hsDefault_a = new HotSpotLayouter((DataModel)model, false, false, true).layout(cd);
                        ClassLayout hsHier_a = new HotSpotLayouter((DataModel)model, true, false, true).layout(cd);
                        ClassLayout hsSuper_a = new HotSpotLayouter((DataModel)model, true, true, true).layout(cd);
                        System.out.printf("%3d, %3d, %3d, %3d, %3d, %3d, %3d, %3d, %3d, %s%n", model.headerSize(), raw.instanceSize(), vm.instanceSize(), hsDefault_m.instanceSize(), hsHier_m.instanceSize(), hsSuper_m.instanceSize(), hsDefault_a.instanceSize(), hsHier_a.instanceSize(), hsSuper_a.instanceSize(), klass.getName());
                    }
                    catch (VerifyError t) {
                    }
                    catch (IncompatibleClassChangeError t) {
                    }
                    catch (SecurityException t) {
                    }
                    catch (ClassFormatError t) {
                    }
                    catch (ClassNotFoundException t) {
                    }
                    catch (NoClassDefFoundError t) {
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                jarFile.close();
            }
            catch (ZipException t) {
            }
            catch (FileNotFoundException t) {
                // empty catch block
            }
        }
    }
}

