/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.bytecode;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.openjdk.jmh.generators.bytecode.ASMGeneratorSource;
import org.openjdk.jmh.generators.core.BenchmarkGenerator;
import org.openjdk.jmh.generators.core.FileSystemDestination;
import org.openjdk.jmh.generators.core.GeneratorDestination;
import org.openjdk.jmh.generators.core.GeneratorSource;
import org.openjdk.jmh.generators.core.SourceError;

public class JmhBytecodeGenerator {
    public static void main(String[] args) throws IOException {
        File compiledBytecodeDirectory = new File(args[0]);
        File outputSourceDirectory = new File(args[1]);
        File outputResourceDirectory = new File(args[2]);
        ASMGeneratorSource source = new ASMGeneratorSource();
        FileSystemDestination destination = new FileSystemDestination(outputResourceDirectory, outputSourceDirectory);
        Collection<File> classes = JmhBytecodeGenerator.getClasses(compiledBytecodeDirectory);
        System.out.println("Processing " + classes.size() + " classes from " + compiledBytecodeDirectory);
        System.out.println("Writing out Java source to " + outputSourceDirectory + " and resources to " + outputResourceDirectory);
        source.processClasses(classes);
        BenchmarkGenerator gen = new BenchmarkGenerator();
        gen.generate((GeneratorSource)source, (GeneratorDestination)destination);
        gen.complete((GeneratorSource)source, (GeneratorDestination)destination);
        if (destination.hasErrors()) {
            for (SourceError e : destination.getErrors()) {
                System.err.println(e.toString() + "\n");
            }
            System.exit(1);
        }
    }

    public static Collection<File> getClasses(File root) {
        ArrayList<File> result = new ArrayList<File>();
        ArrayList<File> newDirs = new ArrayList<File>();
        newDirs.add(root);
        while (!newDirs.isEmpty()) {
            ArrayList<File> add = new ArrayList<File>();
            for (File dir : newDirs) {
                File[] files = dir.listFiles();
                if (files == null) continue;
                for (File f : files) {
                    if (f.isDirectory()) {
                        add.add(f);
                        continue;
                    }
                    if (!f.getName().endsWith(".class")) continue;
                    result.add(f);
                }
            }
            newDirs.clear();
            newDirs = add;
        }
        return result;
    }
}

