/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.bytecode;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.reflective.RFClassInfo;

public class ClassInfoRepo {
    private final Map<String, ClassInfo> map = new HashMap<String, ClassInfo>();

    public ClassInfo get(String desc) {
        ClassInfo info = this.map.get(desc = desc.replace('/', '.'));
        if (info != null) {
            return info;
        }
        try {
            return new RFClassInfo(Class.forName(desc, false, Thread.currentThread().getContextClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to resolve class: " + desc);
        }
    }

    public void put(String desc, ClassInfo info) {
        desc = desc.replace('/', '.');
        this.map.put(desc, info);
    }

    public Collection<ClassInfo> getInfos() {
        return this.map.values();
    }
}

