/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.bytecode;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.objectweb.asm.AnnotationVisitor;
import org.openjdk.jmh.util.internal.HashMultimap;
import org.openjdk.jmh.util.internal.Multimap;

public class AnnotationInvocationHandler
extends AnnotationVisitor
implements InvocationHandler {
    private final Multimap<String, Object> values = new HashMultimap();

    public AnnotationInvocationHandler(AnnotationVisitor annotationVisitor) {
        super(262144, annotationVisitor);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object value;
        String key = method.getName();
        Class<?> returnType = method.getReturnType();
        if (key.equalsIgnoreCase("toString")) {
            return this.values;
        }
        Collection vs = this.values.get((Object)key);
        if (returnType.isArray()) {
            Class<?> componentType = returnType.getComponentType();
            if (componentType.isEnum()) {
                int count = vs.size();
                ArrayList list = new ArrayList(vs);
                Object o = Array.newInstance(componentType, count);
                for (int c = 0; c < count; ++c) {
                    Object v = list.get(c);
                    if (v instanceof String) {
                        Method m = componentType.getMethod("valueOf", String.class);
                        v = m.invoke(null, v);
                    }
                    Array.set(o, c, v);
                }
                return o;
            }
            if (componentType.isPrimitive()) {
                throw new IllegalStateException("Primitive arrays are not handled yet");
            }
            String[] strings = vs.toArray(new String[vs.size()]);
            if (strings.length == 0) {
                strings = (String[])method.getDefaultValue();
            }
            return strings;
        }
        if (vs == null || vs.isEmpty()) {
            value = method.getDefaultValue();
        } else if (vs.size() == 1) {
            value = vs.iterator().next();
        } else {
            throw new IllegalStateException("Expected to see a single value, but got " + vs.size());
        }
        if (returnType.isEnum() && value instanceof String) {
            Method m = returnType.getMethod("valueOf", String.class);
            return m.invoke(null, value);
        }
        return value;
    }

    public void visit(String name, Object value) {
        this.values.put((Object)name, value);
        super.visit(name, value);
    }

    public void visitEnum(String name, String desc, String value) {
        this.values.put((Object)name, (Object)value);
        super.visitEnum(name, desc, value);
    }

    public AnnotationVisitor visitArray(final String name) {
        return new AnnotationVisitor(262144, super.visitArray(name)){

            public void visitEnum(String n, String desc, String value) {
                AnnotationInvocationHandler.this.values.put((Object)name, (Object)value);
                super.visitEnum(n, desc, value);
            }

            public void visit(String n, Object value) {
                AnnotationInvocationHandler.this.values.put((Object)name, value);
                super.visit(n, value);
            }
        };
    }
}

