/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.test;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Assume;
import org.openjdk.jmc.common.util.StringToolkit;
import org.openjdk.jmc.common.version.JavaVMVersionToolkit;
import org.openjdk.jmc.common.version.JavaVersion;
import org.openjdk.jmc.common.version.JavaVersionSupport;

public class MCTestCase {
    public static void assertNull(String message, Object object) {
        if (object != null) {
            MCTestCase.failNotEquals(message, null, object);
        }
    }

    public static void assertNull(Object object) {
        if (object != null) {
            MCTestCase.failNotEquals(null, null, object);
        }
    }

    public static void failNotEquals(String message, Object expected, Object actual) {
        if (!expected.equals(actual)) {
            Assert.fail((String)((String)(message != null ? message + " " : "") + "expected:<" + expected + "> but was:<" + actual + ">"));
        }
    }

    public static void assertMaskedEquals(String message, long expected, long actual, long mask) {
        if (((expected ^ actual) & mask) != 0L) {
            Assert.fail((String)((String)(message != null ? message + " " : "") + "masked with " + MCTestCase.hex(mask) + " expected:<" + MCTestCase.hex(expected) + "> was not:<" + MCTestCase.hex(actual) + ">"));
        }
    }

    public static void assertMaskedEquals(long expected, long actual, long mask) {
        MCTestCase.assertMaskedEquals(null, expected, actual, mask);
    }

    protected static String hex(long val) {
        return "0x" + Long.toHexString(val);
    }

    public static <T extends Comparable<T>> void assertBetween(String message, T min, T max, T actual) {
        if (min.compareTo(actual) > 0 || max.compareTo(actual) < 0) {
            Assert.fail((String)((String)(message != null ? message + " " : "") + "expected in:[" + min + ", " + max + "] was not:<" + actual + ">"));
        }
    }

    public static <T extends Comparable<T>> void assertBetween(T min, T max, T actual) {
        MCTestCase.assertBetween(null, min, max, actual);
    }

    public static <T extends Comparable<T>> void assertMax(String message, T max, T actual) {
        if (max.compareTo(actual) < 0) {
            Assert.fail((String)((String)(message != null ? message + " " : "") + "expected max:<" + max + "> was not:<" + actual + ">"));
        }
    }

    public static <T extends Comparable<T>> void assertMax(T max, T actual) {
        MCTestCase.assertMax(null, max, actual);
    }

    public static <T extends Comparable<T>> void assertMin(String message, T min, T actual) {
        if (min.compareTo(actual) > 0) {
            Assert.fail((String)((String)(message != null ? message + " " : "") + "expected min:<" + min + "> was not:<" + actual + ">"));
        }
    }

    public static <T extends Comparable<T>> void assertMin(T min, T actual) {
        MCTestCase.assertMin(null, min, actual);
    }

    public static <T extends Comparable<T>> void assertLessThan(String message, T greaterVal, T actual) {
        if (greaterVal.compareTo(actual) <= 0) {
            Assert.fail((String)((String)(message != null ? message + " " : "") + "expected less than:<" + greaterVal + "> was not:<" + actual + ">"));
        }
    }

    public static <T extends Comparable<T>> void assertLessThan(T greaterVal, T actual) {
        MCTestCase.assertLessThan(null, greaterVal, actual);
    }

    public static <T extends Comparable<? super T>> void assertGreaterThan(String message, T lesserVal, T actual) {
        if (lesserVal.compareTo(actual) >= 0) {
            Assert.fail((String)((String)(message != null ? message + " " : "") + "expected greater than:<" + lesserVal + "> was not:<" + actual + ">"));
        }
    }

    public static <T extends Comparable<? super T>> void assertGreaterThan(T lesserVal, T actual) {
        MCTestCase.assertGreaterThan(null, lesserVal, actual);
    }

    public static void assertArrayEqualsWithMoreInfo(String message, Object[] expecteds, Object[] actuals) {
        try {
            Assert.assertArrayEquals((String)message, (Object[])expecteds, (Object[])actuals);
        }
        catch (AssertionError e) {
            StringBuilder sb = new StringBuilder();
            sb.append(((Throwable)((Object)e)).getMessage());
            sb.append(" (Expected {");
            sb.append(StringToolkit.join(Arrays.asList(expecteds), (String)", ")).append("}");
            sb.append(", got {");
            sb.append(StringToolkit.join(Arrays.asList(actuals), (String)", ")).append("}");
            throw new AssertionError(sb.toString(), (Throwable)((Object)e));
        }
    }

    protected void skipIfEarlierThan8u0() {
        Assume.assumeTrue((String)"This feature is only valid on JDK8u0 or later.", (this.getClientVersion().compareTo(JVMVersion.JDK8) >= 0 ? 1 : 0) != 0);
    }

    protected void skipIfEarlierThan7u40() {
        Assume.assumeTrue((String)"This feature is only valid on JDK7u40 or later.", (this.getClientVersion().compareTo(JVMVersion.JDK7u40) >= 0 ? 1 : 0) != 0);
    }

    protected void skipIfEarlierThan7u4() {
        Assume.assumeTrue((String)"This feature is only valid on JDK7u4 or later.", (this.getClientVersion().compareTo(JVMVersion.JDK7u4) >= 0 ? 1 : 0) != 0);
    }

    protected void skipIfEarlierThan7u0() {
        Assume.assumeTrue((String)"This feature is only valid on JDK7u0 or later.", (this.getClientVersion().compareTo(JVMVersion.JDK7) >= 0 ? 1 : 0) != 0);
    }

    private JVMVersion getClientVersion() {
        if (JavaVMVersionToolkit.isJRockitJVMName((String)System.getProperty("java.vm.name"))) {
            return JVMVersion.JRockit;
        }
        if (JavaVMVersionToolkit.isHotspotJVMName((String)System.getProperty("java.vm.name"))) {
            JavaVersion javaVersion = new JavaVersion(System.getProperty("java.version"));
            if (javaVersion.isGreaterOrEqualThan(JavaVersionSupport.JDK_8)) {
                return JVMVersion.JDK8;
            }
            if (javaVersion.isGreaterOrEqualThan(JavaVersionSupport.JDK_7_U_40)) {
                return JVMVersion.JDK7u40;
            }
            if (javaVersion.isGreaterOrEqualThan(JavaVersionSupport.JDK_7_U_4)) {
                return JVMVersion.JDK7u4;
            }
            if (javaVersion.isGreaterOrEqualThan(JavaVersionSupport.JDK_7)) {
                return JVMVersion.JDK7;
            }
            if (javaVersion.isGreaterOrEqualThan(JavaVersionSupport.JDK_6)) {
                return JVMVersion.JDK6;
            }
        }
        return JVMVersion.UNKNOWN;
    }

    private static enum JVMVersion {
        ANY,
        UNKNOWN,
        JRockit,
        JDK6,
        JDK7,
        JDK7u4,
        JDK7u40,
        JDK8;

    }
}

