/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.xml.transform;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class Transformer {
    private static TransformerFactory factory;

    public static String transform(URL stylesheet, String in, String systemId) throws IOException, TransformerException {
        return Transformer.transform(stylesheet, in, systemId, (Map<String, String>)null);
    }

    public static String transform(URL stylesheet, String in, String systemId, Map<String, String> parameters) throws IOException, TransformerException {
        return Transformer.transform(stylesheet, (InputStream)new ByteArrayInputStream(in.getBytes()), systemId, parameters);
    }

    public static void transform(URL stylesheet, String in, String systemId, File out) throws IOException, TransformerException {
        Transformer.transform(stylesheet, in, systemId, out, (Map<String, String>)null);
    }

    public static void transform(URL stylesheet, String in, String systemId, File out, Map<String, String> parameters) throws IOException, TransformerException {
        Transformer.transform(stylesheet, (InputStream)new ByteArrayInputStream(in.getBytes()), systemId, out, parameters);
    }

    public static void transform(URL stylesheet, String in, String systemId, OutputStream out) throws IOException, TransformerException {
        Transformer.transform(stylesheet, in, systemId, out, (Map<String, String>)null);
    }

    public static void transform(URL stylesheet, String in, String systemId, OutputStream out, Map<String, String> parameters) throws IOException, TransformerException {
        Transformer.transform(stylesheet, (InputStream)new ByteArrayInputStream(in.getBytes()), systemId, out, parameters);
    }

    public static String transform(URL stylesheet, InputStream in, String systemId) throws IOException, TransformerException {
        return Transformer.transform(stylesheet, in, systemId, (Map<String, String>)null);
    }

    public static String transform(URL stylesheet, InputStream in, String systemId, Map<String, String> parameters) throws IOException, TransformerException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Transformer.transform(stylesheet, new StreamSource(in, systemId), new StreamResult(out), parameters);
        return new String(out.toByteArray());
    }

    public static void transform(URL stylesheet, InputStream in, String systemId, File out) throws IOException, TransformerException {
        Transformer.transform(stylesheet, in, systemId, out, (Map<String, String>)null);
    }

    public static void transform(URL stylesheet, InputStream in, String systemId, File out, Map<String, String> parameters) throws IOException, TransformerException {
        out.createNewFile();
        Transformer.transform(stylesheet, new StreamSource(in, systemId), new StreamResult(out), parameters);
    }

    public static void transform(URL stylesheet, InputStream in, String systemId, OutputStream out) throws IOException, TransformerException {
        Transformer.transform(stylesheet, in, systemId, out, (Map<String, String>)null);
    }

    public static void transform(URL stylesheet, InputStream in, String systemId, OutputStream out, Map<String, String> parameters) throws IOException, TransformerException {
        Transformer.transform(stylesheet, new StreamSource(in, systemId), new StreamResult(out), parameters);
    }

    public static String transform(URL stylesheet, URL in) throws IOException, TransformerException {
        return Transformer.transform(stylesheet, in, (Map<String, String>)null);
    }

    public static String transform(URL stylesheet, URL in, Map<String, String> parameters) throws IOException, TransformerException {
        try (InputStream input = in.openStream();){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Transformer.transform(stylesheet, new StreamSource(input, in.toString()), new StreamResult(out), parameters);
            String string = new String(out.toByteArray());
            return string;
        }
    }

    public static void transform(URL stylesheet, URL in, File out) throws IOException, TransformerException {
        Transformer.transform(stylesheet, in, out, (Map<String, String>)null);
    }

    public static void transform(URL stylesheet, URL in, File out, Map<String, String> parameters) throws IOException, TransformerException {
        try (InputStream input = in.openStream();){
            Transformer.transform(stylesheet, new StreamSource(input, in.toString()), new StreamResult(out), parameters);
        }
    }

    public static void transform(URL stylesheet, URLConnection in, File out) throws IOException, TransformerException {
        Transformer.transform(stylesheet, in, out, (Map<String, String>)null);
    }

    public static void transform(URL stylesheet, URLConnection in, File out, Map<String, String> parameters) throws IOException, TransformerException {
        try (InputStream input = in.getInputStream();){
            Transformer.transform(stylesheet, new StreamSource(input, in.toString()), new StreamResult(out), parameters);
        }
    }

    public static void transform(URL stylesheet, URL in, OutputStream out) throws IOException, TransformerException {
        Transformer.transform(stylesheet, in, out, (Map<String, String>)null);
    }

    public static void transform(URL stylesheet, URL in, OutputStream out, Map<String, String> parameters) throws IOException, TransformerException {
        try (InputStream input = in.openStream();){
            Transformer.transform(stylesheet, new StreamSource(input, in.toString()), new StreamResult(out), parameters);
        }
    }

    public static void transform(URL stylesheet, URLConnection in, OutputStream out) throws IOException, TransformerException {
        Transformer.transform(stylesheet, in, out, (Map<String, String>)null);
    }

    public static void transform(URL stylesheet, URLConnection in, OutputStream out, Map<String, String> parameters) throws IOException, TransformerException {
        try (InputStream input = in.getInputStream();){
            Transformer.transform(stylesheet, new StreamSource(input, in.toString()), new StreamResult(out), parameters);
        }
    }

    private static void transform(URL stylesheet, StreamSource in, StreamResult out, Map<String, String> parameters) throws IOException, TransformerException {
        try (InputStream stylesheetIn = stylesheet.openStream();){
            StreamSource streamSource = new StreamSource(stylesheetIn, stylesheet.toString());
            javax.xml.transform.Transformer transformer = factory.newTransformer(streamSource);
            if (parameters != null && parameters.size() > 0) {
                for (Map.Entry<String, String> entry : parameters.entrySet()) {
                    transformer.setParameter(entry.getKey(), entry.getValue());
                }
            }
            transformer.transform(in, out);
        }
    }

    private Transformer() {
    }

    static {
        try {
            factory = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
        }
        catch (TransformerFactoryConfigurationError e) {
            factory = TransformerFactory.newInstance();
        }
    }
}

