/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.tools.web;

import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;

public class ReaderOptions {
    @Option(name="--print-debug", aliases={"-d"}, usage="print debug messages to standard error")
    private boolean debug = false;
    @Option(name="-html", usage="get article html")
    private boolean html = false;
    @Option(name="-text", usage="get article text")
    private boolean text = false;
    @Option(name="-title", usage="get article title")
    private boolean title = false;
    @Option(name="-links", usage="get article links")
    private boolean links = false;
    @Option(name="-images", usage="get article images")
    private boolean images = false;
    @Option(name="-subhead", usage="get article sub-headings")
    private boolean subhead = false;
    @Option(name="-date", usage="get article date")
    private boolean date = false;
    @Argument(required=true, usage="document paths or urls to process", metaVar="files_or_urls")
    private List<String> documents = new ArrayList<String>();

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isHtml() {
        return this.html;
    }

    public boolean isText() {
        return this.text;
    }

    public boolean isTitle() {
        return this.title;
    }

    public boolean isLinks() {
        return this.links;
    }

    public boolean isImages() {
        return this.images;
    }

    public boolean isSubhead() {
        return this.subhead;
    }

    public List<String> getDocuments() {
        return this.documents;
    }

    public boolean isDate() {
        return this.date;
    }

    public boolean isMultiDocument() {
        return this.documents.size() > 1;
    }

    private int countModes() {
        int count = 0;
        if (this.html) {
            ++count;
        }
        if (this.text) {
            ++count;
        }
        if (this.title) {
            ++count;
        }
        if (this.links) {
            ++count;
        }
        if (this.images) {
            ++count;
        }
        if (this.subhead) {
            ++count;
        }
        if (this.date) {
            ++count;
        }
        return count;
    }

    public boolean isMultiMode() {
        return this.countModes() > 1;
    }

    protected void validate() throws CmdLineException {
        if (this.countModes() == 0) {
            throw new CmdLineException(null, "At least one of the [-html, -text, -title, -links or -images] options is required.");
        }
    }
}

