/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.pgm.util;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.procedure.TIntIntProcedure;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.openimaj.io.FileUtils;
import org.openimaj.pgm.util.Corpus;
import org.openimaj.pgm.util.CorpusReader;
import org.openimaj.pgm.util.Document;

public class SimpleCorpusReader
implements CorpusReader {
    private InputStream is;

    public SimpleCorpusReader(InputStream resourceAsStream) {
        this.is = resourceAsStream;
    }

    @Override
    public Corpus readCorpus() throws IOException {
        String[] lines = FileUtils.readlines((InputStream)this.is);
        HashMap<String, Integer> vocabulary = new HashMap<String, Integer>();
        ArrayList<TIntIntHashMap> docs = new ArrayList<TIntIntHashMap>();
        for (String docLine : lines) {
            String[] words = docLine.split(" ");
            TIntIntHashMap d = new TIntIntHashMap();
            for (String word : words) {
                Integer value = 0;
                value = (Integer)vocabulary.get(word);
                if (value == null) {
                    value = vocabulary.size();
                    vocabulary.put(word, value);
                }
                d.adjustValue(value.intValue(), 1);
            }
            docs.add(d);
        }
        Corpus c = new Corpus(vocabulary.size());
        for (TIntIntHashMap doc : docs) {
            final Document d = new Document(c);
            doc.forEachEntry(new TIntIntProcedure(){

                public boolean execute(int word, int count) {
                    d.values.set(word, count);
                    return true;
                }
            });
            c.addDocument(d);
        }
        return c;
    }
}

