/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.timeseries.series;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.openimaj.io.ReadWriteableASCII;
import org.openimaj.ml.timeseries.collection.TimeSeriesCollection;
import org.openimaj.ml.timeseries.series.DoubleTimeSeries;

public class DoubleTimeSeriesCollection
extends TimeSeriesCollection<double[], Double, DoubleTimeSeriesCollection, DoubleTimeSeries>
implements ReadWriteableASCII {
    @Override
    public DoubleTimeSeries internalNewInstance() {
        return new DoubleTimeSeries();
    }

    @Override
    public DoubleTimeSeriesCollection newInstance() {
        return new DoubleTimeSeriesCollection();
    }

    @Override
    public Map<String, double[]> getData() {
        HashMap<String, double[]> ret = new HashMap<String, double[]>();
        for (Map.Entry es : this.timeSeriesHolder.entrySet()) {
            ret.put((String)es.getKey(), ((DoubleTimeSeries)es.getValue()).getData());
        }
        return ret;
    }

    @Override
    public void internalAssign(DoubleTimeSeriesCollection interpolate) {
        this.timeSeriesHolder = interpolate.timeSeriesHolder;
    }

    @Override
    public String toString() {
        String retstr = "A set time series: " + this.timeSeriesHolder.size() + "\n";
        for (Map.Entry dts : this.timeSeriesHolder.entrySet()) {
            retstr = retstr + (String)dts.getKey() + "\n";
            retstr = retstr + dts.getValue() + "\n";
        }
        return retstr;
    }

    public void readASCII(Scanner in) throws IOException {
        while (in.hasNext()) {
            String name = in.next();
            DoubleTimeSeries v = this.internalNewInstance();
            v.readASCII(in);
            in.nextLine();
            this.timeSeriesHolder.put(name, v);
        }
    }

    public String asciiHeader() {
        return "";
    }

    public void writeASCII(PrintWriter out) throws IOException {
        for (Map.Entry es : this.timeSeriesHolder.entrySet()) {
            out.println((String)es.getKey());
            ((DoubleTimeSeries)es.getValue()).writeASCII(out);
        }
    }
}

