/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.learner.perceptron;

import org.openimaj.ml.linear.kernel.VectorKernel;
import org.openimaj.ml.linear.learner.perceptron.MatrixKernelPerceptron;
import org.openimaj.ml.linear.learner.perceptron.PerceptronClass;

public class ThresholdMatrixKernelPerceptron
extends MatrixKernelPerceptron {
    private double rate;
    private double thresh;

    public ThresholdMatrixKernelPerceptron(VectorKernel k) {
        this(0.1, 0.0, k);
    }

    public ThresholdMatrixKernelPerceptron(double weight, double threshold, VectorKernel k) {
        super(k);
        this.rate = weight;
        this.thresh = threshold;
    }

    @Override
    public PerceptronClass predict(double[] x) {
        double apply = this.mapping(x);
        if (Math.abs(apply) < this.thresh) {
            apply = -1.0;
        }
        return PerceptronClass.fromSign(Math.signum(apply));
    }

    @Override
    double getUpdateRate() {
        return this.rate;
    }
}

