/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.learner.perceptron;

import org.openimaj.ml.linear.kernel.VectorKernel;
import org.openimaj.ml.linear.learner.perceptron.MeanCenteredKernelPerceptron;
import org.openimaj.ml.linear.learner.perceptron.PerceptronClass;

public class MarginMeanCenteredPerceptron
extends MeanCenteredKernelPerceptron {
    private static final double DEFAULT_MARGIN = 0.1;
    private double margin = 0.1;

    public MarginMeanCenteredPerceptron(VectorKernel kernel, double margin) {
        super(kernel);
        this.margin = margin;
    }

    public MarginMeanCenteredPerceptron(VectorKernel kernel) {
        super(kernel);
    }

    @Override
    public void process(double[] xt, PerceptronClass yt) {
        double val = this.mapping(xt);
        PerceptronClass yt_prime = PerceptronClass.fromSign(Math.signum(val));
        if (!yt_prime.equals((Object)yt) || Math.abs(val) < this.margin) {
            this.update(xt, yt, yt_prime);
            ++this.errors;
        }
    }
}

